/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.lossy;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.encoding.readfeatures.BaseQualityScore;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.lossy.BaseCategory;
import htsjdk.samtools.cram.lossy.BaseCategoryType;
import htsjdk.samtools.cram.lossy.Binning;
import htsjdk.samtools.cram.lossy.PreservationPolicy;
import htsjdk.samtools.cram.lossy.QualityScoreTreatment;
import htsjdk.samtools.cram.lossy.ReadCategory;
import htsjdk.samtools.cram.ref.ReferenceTracks;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class QualityScorePreservation {
    private final List<PreservationPolicy> policyList;
    private static final Comparator<ReadFeature> readFeaturePositionComparator = new Comparator<ReadFeature>(){

        @Override
        public int compare(ReadFeature o1, ReadFeature o2) {
            return o1.getPosition() - o2.getPosition();
        }
    };

    public QualityScorePreservation(String specification) {
        this.policyList = QualityScorePreservation.parsePolicies(specification);
    }

    public List<PreservationPolicy> getPreservationPolicies() {
        return this.policyList;
    }

    private static int readParam(LinkedList<Character> list) {
        int value = 0;
        while (!list.isEmpty() && Character.isDigit(list.getFirst().charValue())) {
            value = value * 10 + (list.removeFirst().charValue() - 48);
        }
        return value;
    }

    private static QualityScoreTreatment readTreatment(LinkedList<Character> list) {
        QualityScoreTreatment qualityScoreTreatment;
        int param = QualityScorePreservation.readParam(list);
        switch (param) {
            case 0: {
                qualityScoreTreatment = QualityScoreTreatment.drop();
                break;
            }
            case 40: {
                qualityScoreTreatment = QualityScoreTreatment.preserve();
                break;
            }
            default: {
                qualityScoreTreatment = QualityScoreTreatment.bin(param);
            }
        }
        return qualityScoreTreatment;
    }

    private static List<PreservationPolicy> parsePolicies(String spec) {
        ArrayList<PreservationPolicy> policyList = new ArrayList<PreservationPolicy>();
        for (String string : spec.split("-")) {
            if (string.isEmpty()) continue;
            PreservationPolicy policy = QualityScorePreservation.parseSinglePolicy(string);
            policyList.add(policy);
        }
        Collections.sort(policyList, new Comparator<PreservationPolicy>(){

            @Override
            public int compare(PreservationPolicy o1, PreservationPolicy o2) {
                QualityScoreTreatment t1 = o1.treatment;
                QualityScoreTreatment t2 = o2.treatment;
                int result = t2.type.ordinal() - t1.type.ordinal();
                if (result != 0) {
                    return result;
                }
                return 0;
            }
        });
        return policyList;
    }

    private static PreservationPolicy parseSinglePolicy(String spec) {
        PreservationPolicy preservationPolicy = new PreservationPolicy();
        LinkedList<Character> list = new LinkedList<Character>();
        for (char character : spec.toCharArray()) {
            list.add(Character.valueOf(character));
        }
        while (!list.isEmpty()) {
            char code = ((Character)list.removeFirst()).charValue();
            switch (code) {
                case 'R': {
                    preservationPolicy.baseCategories.add(BaseCategory.match());
                    preservationPolicy.treatment = QualityScorePreservation.readTreatment(list);
                    break;
                }
                case 'N': {
                    preservationPolicy.baseCategories.add(BaseCategory.mismatch());
                    preservationPolicy.treatment = QualityScorePreservation.readTreatment(list);
                    break;
                }
                case 'X': {
                    int coverage = QualityScorePreservation.readParam(list);
                    preservationPolicy.baseCategories.add(BaseCategory.lowerThanCoverage(coverage));
                    break;
                }
                case 'D': {
                    preservationPolicy.baseCategories.add(BaseCategory.flankingDeletion());
                    preservationPolicy.treatment = QualityScorePreservation.readTreatment(list);
                    break;
                }
                case 'M': {
                    int score = QualityScorePreservation.readParam(list);
                    preservationPolicy.readCategory = ReadCategory.higher_than_mapping_score(score);
                    break;
                }
                case 'm': {
                    int score = QualityScorePreservation.readParam(list);
                    preservationPolicy.readCategory = ReadCategory.lower_than_mapping_score(score);
                    break;
                }
                case 'U': {
                    preservationPolicy.readCategory = ReadCategory.unplaced();
                    preservationPolicy.treatment = QualityScorePreservation.readTreatment(list);
                    break;
                }
                case 'P': {
                    int mismatches = QualityScorePreservation.readParam(list);
                    preservationPolicy.baseCategories.add(BaseCategory.pileup(mismatches));
                    preservationPolicy.treatment = QualityScorePreservation.readTreatment(list);
                    break;
                }
                case 'I': {
                    preservationPolicy.baseCategories.add(BaseCategory.insertion());
                    preservationPolicy.treatment = QualityScorePreservation.readTreatment(list);
                    break;
                }
                case '_': {
                    preservationPolicy.treatment = QualityScorePreservation.readTreatment(list);
                    break;
                }
                case '*': {
                    preservationPolicy.readCategory = ReadCategory.all();
                    preservationPolicy.treatment = QualityScorePreservation.readTreatment(list);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown read or base category: " + code);
                }
            }
            if (preservationPolicy.treatment != null) continue;
            preservationPolicy.treatment = QualityScoreTreatment.preserve();
        }
        return preservationPolicy;
    }

    private static void applyBinning(byte[] scores) {
        for (int i2 = 0; i2 < scores.length; ++i2) {
            scores[i2] = Binning.ILLUMINA_BINNING_MATRIX[scores[i2]];
        }
    }

    private static byte applyTreatment(byte score, QualityScoreTreatment qualityScoreTreatment) {
        switch (qualityScoreTreatment.type) {
            case BIN: {
                return Binning.ILLUMINA_BINNING_MATRIX[score];
            }
            case DROP: {
                return -1;
            }
            case PRESERVE: {
                return score;
            }
        }
        throw new RuntimeException("Unknown quality score treatment type: " + qualityScoreTreatment.type.name());
    }

    public void addQualityScores(SAMRecord samRecord, CramCompressionRecord cramRecord, ReferenceTracks referenceTracks) {
        if (samRecord.getBaseQualities() == SAMRecord.NULL_QUALS) {
            cramRecord.qualityScores = SAMRecord.NULL_QUALS;
            cramRecord.setForcePreserveQualityScores(false);
            return;
        }
        byte[] scores = new byte[samRecord.getReadLength()];
        Arrays.fill(scores, (byte)-1);
        for (PreservationPolicy preservationPolicy : this.policyList) {
            QualityScorePreservation.addQS(samRecord, cramRecord, scores, referenceTracks, preservationPolicy);
        }
        if (!cramRecord.isForcePreserveQualityScores()) {
            for (int i2 = 0; i2 < scores.length; ++i2) {
                if (scores[i2] <= -1) continue;
                if (cramRecord.readFeatures == null) {
                    cramRecord.readFeatures = new LinkedList<ReadFeature>();
                }
                cramRecord.readFeatures.add(new BaseQualityScore(i2 + 1, scores[i2]));
            }
            if (cramRecord.readFeatures != null) {
                Collections.sort(cramRecord.readFeatures, readFeaturePositionComparator);
            }
        }
        cramRecord.qualityScores = scores;
    }

    public boolean areReferenceTracksRequired() {
        if (this.policyList == null || this.policyList.isEmpty()) {
            return false;
        }
        for (PreservationPolicy preservationPolicy : this.policyList) {
            if (preservationPolicy.baseCategories == null || preservationPolicy.baseCategories.isEmpty()) continue;
            for (BaseCategory c2 : preservationPolicy.baseCategories) {
                switch (c2.type) {
                    case LOWER_COVERAGE: 
                    case PILEUP: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static void addQS(SAMRecord samRecord, CramCompressionRecord cramRecord, byte[] scores, ReferenceTracks referenceTracks, PreservationPolicy preservationPolicy) {
        int alSpan = samRecord.getAlignmentEnd() - samRecord.getAlignmentStart();
        byte[] qualityScores = samRecord.getBaseQualities();
        if (preservationPolicy.readCategory != null) {
            boolean properRead = false;
            switch (preservationPolicy.readCategory.type) {
                case ALL: {
                    properRead = true;
                    break;
                }
                case UNPLACED: {
                    properRead = samRecord.getReadUnmappedFlag();
                    break;
                }
                case LOWER_MAPPING_SCORE: {
                    properRead = samRecord.getMappingQuality() < preservationPolicy.readCategory.param;
                    break;
                }
                case HIGHER_MAPPING_SCORE: {
                    properRead = samRecord.getMappingQuality() > preservationPolicy.readCategory.param;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown read category: " + preservationPolicy.readCategory.type.name());
                }
            }
            if (!properRead) {
                return;
            }
        }
        if (preservationPolicy.baseCategories == null || preservationPolicy.baseCategories.isEmpty()) {
            switch (preservationPolicy.treatment.type) {
                case BIN: {
                    if (cramRecord.qualityScores == null) {
                        cramRecord.qualityScores = samRecord.getBaseQualities();
                    }
                    System.arraycopy(samRecord.getBaseQualities(), 0, scores, 0, scores.length);
                    QualityScorePreservation.applyBinning(scores);
                    cramRecord.setForcePreserveQualityScores(true);
                    break;
                }
                case PRESERVE: {
                    System.arraycopy(samRecord.getBaseQualities(), 0, scores, 0, scores.length);
                    cramRecord.setForcePreserveQualityScores(true);
                    break;
                }
                case DROP: {
                    cramRecord.qualityScores = null;
                    cramRecord.setForcePreserveQualityScores(false);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown quality score treatment type: " + preservationPolicy.treatment.type.name());
                }
            }
            return;
        }
        boolean[] mask = new boolean[qualityScores.length];
        int alStart = samRecord.getAlignmentStart();
        if (alStart == 0) {
            return;
        }
        referenceTracks.ensureRange(alStart, alSpan);
        block24: for (BaseCategory baseCategory : preservationPolicy.baseCategories) {
            switch (baseCategory.type) {
                case FLANKING_DELETION: {
                    int pos = 0;
                    for (CigarElement cigarElement : samRecord.getCigar().getCigarElements()) {
                        if (cigarElement.getOperator() == CigarOperator.D) {
                            mask[pos] = true;
                            if (pos + 1 < mask.length) {
                                mask[pos + 1] = true;
                            }
                        }
                        pos += cigarElement.getOperator().consumesReadBases() ? cigarElement.getLength() : 0;
                    }
                    continue block24;
                }
                case MATCH: 
                case MISMATCH: {
                    int i2;
                    int pos = 0;
                    int refPos = samRecord.getAlignmentStart();
                    for (CigarElement cigarElement : samRecord.getCigar().getCigarElements()) {
                        if (cigarElement.getOperator().consumesReadBases()) {
                            for (i2 = 0; i2 < cigarElement.getLength(); ++i2) {
                                boolean match = samRecord.getReadBases()[pos + i2] == referenceTracks.baseAt(refPos + i2);
                                mask[pos + i2] = baseCategory.type == BaseCategoryType.MATCH && match || baseCategory.type == BaseCategoryType.MISMATCH && !match;
                            }
                            pos += cigarElement.getLength();
                        }
                        refPos += cigarElement.getOperator().consumesReferenceBases() ? cigarElement.getLength() : 0;
                    }
                    continue block24;
                }
                case INSERTION: {
                    int i2;
                    int pos = 0;
                    for (CigarElement cigarElement : samRecord.getCigar().getCigarElements()) {
                        switch (cigarElement.getOperator()) {
                            case I: {
                                for (i2 = 0; i2 < cigarElement.getLength(); ++i2) {
                                    mask[pos + i2] = true;
                                }
                                break;
                            }
                        }
                        pos += cigarElement.getOperator().consumesReadBases() ? cigarElement.getLength() : 0;
                    }
                    continue block24;
                }
                case LOWER_COVERAGE: {
                    int i2;
                    int pos = 1;
                    int refPos = samRecord.getAlignmentStart();
                    for (CigarElement cigarElement : samRecord.getCigar().getCigarElements()) {
                        switch (cigarElement.getOperator()) {
                            case M: 
                            case EQ: 
                            case X: {
                                for (i2 = 0; i2 < cigarElement.getLength(); ++i2) {
                                    mask[pos + i2 - 1] = referenceTracks.coverageAt(refPos + i2) < baseCategory.param;
                                }
                                break;
                            }
                        }
                        pos += cigarElement.getOperator().consumesReadBases() ? cigarElement.getLength() : 0;
                        refPos += cigarElement.getOperator().consumesReferenceBases() ? cigarElement.getLength() : 0;
                    }
                    continue block24;
                }
                case PILEUP: {
                    for (int i3 = 0; i3 < qualityScores.length; ++i3) {
                        if (referenceTracks.mismatchesAt(alStart + i3) <= baseCategory.param) continue;
                        mask[i3] = true;
                    }
                    continue block24;
                }
            }
        }
        int maskedCount = 0;
        for (int i4 = 0; i4 < mask.length; ++i4) {
            if (!mask[i4]) continue;
            scores[i4] = QualityScorePreservation.applyTreatment(qualityScores[i4], preservationPolicy.treatment);
            ++maskedCount;
        }
        if (maskedCount > samRecord.getReadLength() / 2) {
            cramRecord.setForcePreserveQualityScores(true);
        }
    }
}

