/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.Log;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="References")
public class SAMSequenceDictionary
implements Serializable {
    public static final long serialVersionUID = 1L;
    @XmlElement(name="Reference")
    private List<SAMSequenceRecord> mSequences = new ArrayList<SAMSequenceRecord>();
    private final Map<String, SAMSequenceRecord> mSequenceMap = new HashMap<String, SAMSequenceRecord>();
    private static Log log = Log.getInstance(SAMSequenceDictionary.class);
    private static String DICT_MISMATCH_TEMPLATE = "SAM dictionaries are not the same: %s.";
    public static final List<String> DEFAULT_DICTIONARY_EQUAL_TAG = Arrays.asList("M5", "LN");

    public SAMSequenceDictionary() {
    }

    public SAMSequenceDictionary(List<SAMSequenceRecord> list) {
        this();
        this.setSequences(list);
    }

    @XmlTransient
    public List<SAMSequenceRecord> getSequences() {
        return Collections.unmodifiableList(this.mSequences);
    }

    public SAMSequenceRecord getSequence(String name) {
        return this.mSequenceMap.get(name);
    }

    public void setSequences(List<SAMSequenceRecord> list) {
        this.mSequences = list;
        this.mSequenceMap.clear();
        int index = 0;
        for (SAMSequenceRecord record : list) {
            record.setSequenceIndex(index++);
            if (this.mSequenceMap.put(record.getSequenceName(), record) == null) continue;
            throw new IllegalArgumentException("Cannot add sequence that already exists in SAMSequenceDictionary: " + record.getSequenceName());
        }
    }

    public void addSequence(SAMSequenceRecord sequenceRecord) {
        if (this.mSequenceMap.containsKey(sequenceRecord.getSequenceName())) {
            throw new IllegalArgumentException("Cannot add sequence that already exists in SAMSequenceDictionary: " + sequenceRecord.getSequenceName());
        }
        sequenceRecord.setSequenceIndex(this.mSequences.size());
        this.mSequences.add(sequenceRecord);
        this.mSequenceMap.put(sequenceRecord.getSequenceName(), sequenceRecord);
    }

    public SAMSequenceRecord getSequence(int sequenceIndex) {
        if (sequenceIndex < 0 || sequenceIndex >= this.mSequences.size()) {
            return null;
        }
        return this.mSequences.get(sequenceIndex);
    }

    public int getSequenceIndex(String sequenceName) {
        SAMSequenceRecord record = this.mSequenceMap.get(sequenceName);
        if (record == null) {
            return -1;
        }
        return record.getSequenceIndex();
    }

    public int size() {
        return this.mSequences.size();
    }

    public long getReferenceLength() {
        long len = 0L;
        for (SAMSequenceRecord seq : this.getSequences()) {
            len += (long)seq.getSequenceLength();
        }
        return len;
    }

    public boolean isEmpty() {
        return this.mSequences.isEmpty();
    }

    public void assertSameDictionary(SAMSequenceDictionary that) {
        if (this == that) {
            return;
        }
        Iterator<SAMSequenceRecord> thatSequences = that.mSequences.iterator();
        for (SAMSequenceRecord thisSequence : this.mSequences) {
            if (!thatSequences.hasNext()) {
                throw new AssertionError((Object)String.format(DICT_MISMATCH_TEMPLATE, thisSequence + " is present in only one dictionary"));
            }
            SAMSequenceRecord thatSequence = thatSequences.next();
            if (!thatSequence.isSameSequence(thisSequence)) {
                throw new AssertionError((Object)String.format(DICT_MISMATCH_TEMPLATE, thatSequence + " was found when " + thisSequence + " was expected"));
            }
        }
        if (thatSequences.hasNext()) {
            throw new AssertionError((Object)String.format(DICT_MISMATCH_TEMPLATE, thatSequences.next() + " is present in only one dictionary"));
        }
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SAMSequenceDictionary that = (SAMSequenceDictionary)o2;
        return this.mSequences.equals(that.mSequences);
    }

    public SAMSequenceRecord addSequenceAlias(String originalName, String altName) {
        if (originalName == null) {
            throw new IllegalArgumentException("original name cannot be null");
        }
        if (altName == null) {
            throw new IllegalArgumentException("alt name cannot be null");
        }
        SAMSequenceRecord originalSeqRecord = this.getSequence(originalName);
        if (originalSeqRecord == null) {
            throw new IllegalArgumentException("Sequence " + originalName + " doesn't exist in dictionary.");
        }
        if (originalName.equals(altName)) {
            return originalSeqRecord;
        }
        SAMSequenceRecord altSeqRecord = this.getSequence(altName);
        if (altSeqRecord != null) {
            if (altSeqRecord.equals(originalSeqRecord)) {
                return originalSeqRecord;
            }
            throw new IllegalArgumentException("Alias " + altName + " was already set to " + altSeqRecord.getSequenceName());
        }
        this.mSequenceMap.put(altName, originalSeqRecord);
        return originalSeqRecord;
    }

    public String md5() {
        if (this.isEmpty()) {
            return "";
        }
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            for (SAMSequenceRecord samSequenceRecord : this.mSequences) {
                String md5_tag;
                if (samSequenceRecord.getSequenceIndex() > 0) {
                    md5.update((byte)32);
                }
                if ((md5_tag = samSequenceRecord.getAttribute("M5")) != null) {
                    md5.update(md5_tag.getBytes());
                    continue;
                }
                md5.update(samSequenceRecord.getSequenceName().getBytes());
                md5.update(String.valueOf(samSequenceRecord.getSequenceLength()).getBytes());
            }
            String hash = new BigInteger(1, md5.digest()).toString(16);
            if (hash.length() != 32) {
                String zeros = "00000000000000000000000000000000";
                hash = "00000000000000000000000000000000".substring(0, 32 - hash.length()) + hash;
            }
            return hash;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public int hashCode() {
        return this.mSequences.hashCode();
    }

    public String toString() {
        return "SAMSequenceDictionary:( sequences:" + this.size() + " length:" + this.getReferenceLength() + " " + " md5:" + this.md5() + ")";
    }

    public static SAMSequenceDictionary mergeDictionaries(SAMSequenceDictionary dict1, SAMSequenceDictionary dict2, List<String> tagsToMatch) {
        if (!tagsToMatch.contains("M5") || !tagsToMatch.contains("LN")) {
            throw new IllegalArgumentException("Both M5 and LN must be matched when merging dictionaries. Found: " + String.join((CharSequence)",", tagsToMatch));
        }
        if (!dict1.getSequences().stream().map(SAMSequenceRecord::getSequenceName).collect(Collectors.toList()).equals(dict2.getSequences().stream().map(SAMSequenceRecord::getSequenceName).collect(Collectors.toList()))) {
            throw new IllegalArgumentException(String.format("Do not use this function to merge dictionaries with different sequences in them. Sequences must be in the same order as well. Found [%s] and [%s].", String.join((CharSequence)", ", dict1.getSequences().stream().map(SAMSequenceRecord::getSequenceName).collect(Collectors.toList())), String.join((CharSequence)", ", dict2.getSequences().stream().map(SAMSequenceRecord::getSequenceName).collect(Collectors.toList()))));
        }
        SAMSequenceDictionary finalDict = new SAMSequenceDictionary();
        for (int sequenceIndex = 0; sequenceIndex < dict1.getSequences().size(); ++sequenceIndex) {
            SAMSequenceRecord s1 = dict1.getSequence(sequenceIndex);
            SAMSequenceRecord s2 = dict2.getSequence(sequenceIndex);
            String sName = s1.getSequenceName();
            SAMSequenceRecord sMerged = new SAMSequenceRecord(sName, 0);
            finalDict.addSequence(sMerged);
            HashSet allTags = new HashSet();
            s1.getAttributes().stream().forEach(a2 -> allTags.add(a2.getKey()));
            s2.getAttributes().stream().forEach(a2 -> allTags.add(a2.getKey()));
            for (String tag : allTags) {
                String value1 = s1.getAttribute(tag);
                String value2 = s2.getAttribute(tag);
                if (value1 != null && value2 != null && !value1.equals(value2)) {
                    String baseMessage = String.format("Found sequence entry for which tags differ: %s and tag %s has the two values: %s and %s.", sName, tag, value1, value2);
                    if (tagsToMatch.contains(tag)) {
                        log.error("Cannot merge dictionaries. ", baseMessage);
                        throw new IllegalArgumentException("Cannot merge dictionaries. " + baseMessage);
                    }
                    log.warn(baseMessage, " Using ", value1);
                }
                sMerged.setAttribute(tag, value1 == null ? value2 : value1);
            }
            int length1 = s1.getSequenceLength();
            int length2 = s2.getSequenceLength();
            if (length1 != 0 && length2 != 0 && length1 != length2) {
                throw new IllegalArgumentException(String.format("Cannot merge the two dictionaries. Found sequence entry for which lengths differ: %s has lengths %s and %s", sName, length1, length2));
            }
            sMerged.setSequenceLength(length1 == 0 ? length2 : length1);
        }
        return finalDict;
    }
}

