/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.CigarOperator;
import java.io.Serializable;

public class CigarElement
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final int length;
    private final CigarOperator operator;

    public CigarElement(int length, CigarOperator operator) {
        if (length < 0) {
            throw new IllegalArgumentException(String.format("Cigar element being constructed with negative length: %d and operation: %s", length, operator.name()));
        }
        this.length = length;
        this.operator = operator;
    }

    public int getLength() {
        return this.length;
    }

    public CigarOperator getOperator() {
        return this.operator;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof CigarElement)) {
            return false;
        }
        CigarElement that = (CigarElement)o2;
        if (this.length != that.length) {
            return false;
        }
        return this.operator == that.operator;
    }

    public int hashCode() {
        int result = this.length;
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.valueOf(this.length) + (Object)((Object)this.operator);
    }
}

