/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.Bin;
import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import java.util.List;

public class BinningIndexBuilder {
    private final int referenceSequence;
    private final Bin[] bins;
    private int binsSeen = 0;
    private final long[] index = new long[LinearIndex.MAX_LINEAR_INDEX_SIZE];
    private int largestIndexSeen = -1;

    public BinningIndexBuilder(int referenceSequence, int sequenceLength) {
        this.referenceSequence = referenceSequence;
        int numBins = sequenceLength <= 0 ? 37451 : AbstractBAMFileIndex.getMaxBinNumberForSequenceLength(sequenceLength) + 1;
        this.bins = new Bin[numBins];
    }

    public BinningIndexBuilder(int referenceSequence) {
        this(referenceSequence, 0);
    }

    public void processFeature(FeatureToBeIndexed feature) {
        Bin bin;
        int binNum;
        Integer binNumber = feature.getIndexingBin();
        int n2 = binNum = binNumber == null ? this.computeIndexingBin(feature) : binNumber.intValue();
        if (this.bins[binNum] != null) {
            bin = this.bins[binNum];
        } else {
            this.bins[binNum] = bin = new Bin(this.referenceSequence, binNum);
            ++this.binsSeen;
        }
        Chunk newChunk = feature.getChunk();
        long chunkStart = newChunk.getChunkStart();
        long chunkEnd = newChunk.getChunkEnd();
        List<Chunk> oldChunks = bin.getChunkList();
        if (!bin.containsChunks()) {
            bin.addInitialChunk(newChunk);
        } else {
            Chunk lastChunk = bin.getLastChunk();
            if (BlockCompressedFilePointerUtil.areInSameOrAdjacentBlocks(lastChunk.getChunkEnd(), chunkStart)) {
                lastChunk.setChunkEnd(chunkEnd);
            } else {
                oldChunks.add(newChunk);
                bin.setLastChunk(newChunk);
            }
        }
        int featureEnd = feature.getEnd();
        int startWindow = LinearIndex.convertToLinearIndexOffset(feature.getStart());
        int endWindow = featureEnd == 0 ? (startWindow = LinearIndex.convertToLinearIndexOffset(feature.getStart() - 1)) : LinearIndex.convertToLinearIndexOffset(featureEnd);
        if (endWindow > this.largestIndexSeen) {
            this.largestIndexSeen = endWindow;
        }
        for (int win = startWindow; win <= endWindow; ++win) {
            if (this.index[win] != 0L && chunkStart >= this.index[win]) continue;
            this.index[win] = chunkStart;
        }
    }

    public BinningIndexContent generateIndexContent() {
        if (this.binsSeen == 0) {
            return null;
        }
        long[] newIndex = new long[this.largestIndexSeen + 1];
        long lastNonZeroOffset = 0L;
        for (int i2 = 0; i2 <= this.largestIndexSeen; ++i2) {
            if (this.index[i2] == 0L) {
                this.index[i2] = lastNonZeroOffset;
            } else {
                lastNonZeroOffset = this.index[i2];
            }
            newIndex[i2] = this.index[i2];
        }
        LinearIndex linearIndex = new LinearIndex(this.referenceSequence, 0, newIndex);
        return new BinningIndexContent(this.referenceSequence, new BinningIndexContent.BinList(this.bins, this.binsSeen), linearIndex);
    }

    private int computeIndexingBin(FeatureToBeIndexed feature) {
        int start = feature.getStart() - 1;
        int end = feature.getEnd();
        if (end <= 0) {
            end = start + 1;
        }
        return GenomicIndexUtil.regionToBin(start, end);
    }

    public static interface FeatureToBeIndexed {
        public int getStart();

        public int getEnd();

        public Integer getIndexingBin();

        public Chunk getChunk();
    }
}

