/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core.experimental;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.core.experimental.ExperimentalEncoding;
import htsjdk.samtools.cram.encoding.core.experimental.GolombIntegerCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class GolombIntegerEncoding
extends ExperimentalEncoding<Integer> {
    private final int offset;
    private final int m;

    private GolombIntegerEncoding(int offset, int m) {
        super(EncodingID.GOLOMB);
        this.offset = offset;
        this.m = m;
    }

    public static GolombIntegerEncoding fromParams(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int offset = ITF8.readUnsignedITF8(buffer);
        int m = ITF8.readUnsignedITF8(buffer);
        return new GolombIntegerEncoding(offset, m);
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        ITF8.writeUnsignedITF8(this.offset, buffer);
        ITF8.writeUnsignedITF8(this.m, buffer);
        buffer.flip();
        byte[] array = new byte[buffer.limit()];
        buffer.get(array);
        return array;
    }

    @Override
    public CRAMCodec<Integer> buildCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, Map<Integer, ByteArrayInputStream> externalBlockInputMap, Map<Integer, ByteArrayOutputStream> externalBlockOutputMap) {
        return new GolombIntegerCodec(coreBlockInputStream, coreBlockOutputStream, this.m, this.offset);
    }
}

