/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;

public class ReorderableJList<T>
extends JList {
    DefaultListModel model;

    public ReorderableJList() {
        this.setTransferHandler(new MyListDropHandler());
        new MyDragListener(this);
    }

    public void setElements(List<T> elements) {
        this.model = new DefaultListModel();
        this.setModel(this.model);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT);
        for (T obj : elements) {
            this.model.addElement(obj);
        }
    }

    public List<T> getElements() {
        ArrayList elementList = new ArrayList();
        Enumeration en = this.model.elements();
        if (en != null) {
            while (en.hasMoreElements()) {
                elementList.add(en.nextElement());
            }
        }
        return elementList;
    }

    public static void main(String[] a) {
        List<String> list = Arrays.asList("a", "b", "c");
        JDialog f = new JDialog();
        f.setModal(true);
        ReorderableJList<String> roList = new ReorderableJList<String>();
        roList.setElements(list);
        f.add(new JScrollPane(roList));
        f.setSize(300, 300);
        f.setVisible(true);
        for (String s : roList.getElements()) {
            System.out.println(s);
        }
    }

    class MyListDropHandler
    extends TransferHandler {
        MyListDropHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            JList.DropLocation dl = (JList.DropLocation)support.getDropLocation();
            return dl.getIndex() != -1;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            String indexString;
            if (!this.canImport(support)) {
                return false;
            }
            Transferable transferable = support.getTransferable();
            try {
                indexString = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                return false;
            }
            int fromIndex = Integer.parseInt(indexString);
            JList.DropLocation dl = (JList.DropLocation)support.getDropLocation();
            int toIndex = dl.getIndex();
            if (fromIndex < toIndex) {
                --toIndex;
            }
            Object obj = ReorderableJList.this.model.remove(fromIndex);
            ReorderableJList.this.model.add(toIndex, obj);
            ReorderableJList.this.invalidate();
            return true;
        }
    }

    class MyDragListener
    implements DragSourceListener,
    DragGestureListener {
        ReorderableJList list;
        DragSource ds = new DragSource();

        public MyDragListener(ReorderableJList list) {
            this.list = list;
            DragGestureRecognizer dgr = this.ds.createDefaultDragGestureRecognizer(list, 2, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            StringSelection transferable = new StringSelection(Integer.toString(this.list.getSelectedIndex()));
            this.ds.startDrag(dge, DragSource.DefaultCopyDrop, transferable, this);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (dsde.getDropSuccess()) {
                // empty if block
            }
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    }
}

