/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.variant.vcf;

import htsjdk.variant.variantcontext.GenotypeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.variant.Allele;
import org.broad.igv.variant.Genotype;
import org.broad.igv.variant.vcf.VCFAllele;

public class VCFGenotype
implements Genotype {
    htsjdk.variant.variantcontext.Genotype vcfGenotype;
    Map<String, Object> attributes;
    List<Allele> alleles;

    public VCFGenotype(htsjdk.variant.variantcontext.Genotype wrappedGenotype) {
        int i;
        this.vcfGenotype = wrappedGenotype;
        this.attributes = new HashMap<String, Object>();
        if (this.vcfGenotype.hasDP()) {
            this.attributes.put("DP", this.vcfGenotype.getDP());
        }
        if (this.vcfGenotype.hasAD()) {
            String adString = "";
            int[] ad = this.vcfGenotype.getAD();
            for (i = 0; i < ad.length; ++i) {
                if (i != 0) {
                    adString = adString + ",";
                }
                adString = adString + String.valueOf(ad[i]);
            }
            this.attributes.put("AD", adString);
        }
        if (this.vcfGenotype.hasGQ()) {
            this.attributes.put("GQ", this.vcfGenotype.getGQ());
        }
        if (this.vcfGenotype.hasPL()) {
            String plString = "";
            int[] pl = this.vcfGenotype.getPL();
            for (i = 0; i < pl.length; ++i) {
                if (i != 0) {
                    plString = plString + ",";
                }
                plString = plString + String.valueOf(pl[i]);
            }
            this.attributes.put("PL", plString);
        }
        this.attributes.putAll(this.vcfGenotype.getExtendedAttributes());
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getGenotypeString() {
        return this.vcfGenotype.getGenotypeString();
    }

    @Override
    public double getPhredScaledQual() {
        return this.vcfGenotype.getGQ();
    }

    @Override
    public String getTypeString() {
        return this.vcfGenotype.getType().toString();
    }

    @Override
    public GenotypeType getType() {
        return this.vcfGenotype.getType();
    }

    @Override
    public boolean isHomVar() {
        return this.vcfGenotype.isHomVar();
    }

    @Override
    public boolean isHet() {
        return this.vcfGenotype.isHet();
    }

    @Override
    public boolean isHomRef() {
        return this.vcfGenotype.isHomRef();
    }

    @Override
    public boolean isNoCall() {
        return this.vcfGenotype.isNoCall();
    }

    @Override
    public List<Allele> getAlleles() {
        if (this.alleles == null) {
            this.alleles = new ArrayList<Allele>();
            List<htsjdk.variant.variantcontext.Allele> tmp = this.vcfGenotype.getAlleles();
            if (tmp != null) {
                for (htsjdk.variant.variantcontext.Allele a : tmp) {
                    this.alleles.add(new VCFAllele(a.getBases()));
                }
            }
        }
        return this.alleles;
    }

    @Override
    public double getAttributeAsDouble(String s) {
        return this.vcfGenotype.getAttributeAsDouble(s, Double.NaN);
    }
}

