/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import htsjdk.tribble.util.URLHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.util.HttpUtils;

public class IGVUrlHelper
implements URLHelper {
    static Logger log = Logger.getLogger(IGVUrlHelper.class);
    URL url;
    private static Map<URL, Long> contentLengths = new HashMap<URL, Long>();

    public IGVUrlHelper(URL url) {
        this.url = url;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public long getContentLength() throws IOException {
        if (contentLengths.containsKey(this.url)) {
            return contentLengths.get(this.url);
        }
        long length = HttpUtils.getInstance().getContentLength(this.url);
        contentLengths.put(this.url, length);
        return length;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return HttpUtils.getInstance().openConnectionStream(this.url);
    }

    @Override
    public InputStream openInputStreamForRange(long start, long end) throws IOException {
        String byteRange = "bytes=" + start + "-" + end;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Range", byteRange);
        URL url = this.addStartEndQueryString(start, end);
        return HttpUtils.getInstance().openConnectionStream(url, params);
    }

    private URL addStartEndQueryString(long start, long end) throws MalformedURLException {
        String surl;
        String nurl = surl = this.url.toExternalForm();
        String toadd = String.format("start=%d&end=%d", start, end);
        String[] parts = surl.split("\\?", 2);
        if (parts.length == 2) {
            nurl = String.format("%s?%s", parts[0], toadd);
            nurl = nurl + "&" + parts[1];
        }
        if (log.isTraceEnabled()) {
            log.trace("old url: " + surl);
            log.trace("HttpUtils.createURL: " + nurl);
        }
        return HttpUtils.createURL(nurl);
    }

    @Override
    public boolean exists() {
        return HttpUtils.getInstance().resourceAvailable(this.url.toExternalForm());
    }
}

