/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.Font;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.UIManager;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;

public class FontManager {
    private static Font defaultFont;
    static Hashtable<String, Font> fontCache;
    private static double scaleFactor;

    public static Font getDefaultFont() {
        if (defaultFont == null) {
            FontManager.updateDefaultFont();
        }
        return defaultFont;
    }

    public static Font getFont(int sz) {
        IGVPreferences prefManager = PreferencesManager.getPreferences();
        int size = (int)(scaleFactor * (double)sz);
        String fontFamily = prefManager.get("DEFAULT_FONT_FAMILY");
        int attribute = prefManager.getAsInt("DEFAULT_FONT_ATTRIBUTE");
        String key = fontFamily + "_" + attribute + "_" + size;
        Font font = fontCache.get(key);
        if (font == null) {
            font = new Font(fontFamily, attribute, size);
            fontCache.put(key, font);
        }
        return font;
    }

    public static Font getFont(int attribute, int sz) {
        int size = (int)(scaleFactor * (double)sz);
        IGVPreferences prefManager = PreferencesManager.getPreferences();
        String fontFamily = prefManager.get("DEFAULT_FONT_FAMILY");
        String key = fontFamily + "_" + attribute + "_" + size;
        Font font = fontCache.get(key);
        if (font == null) {
            font = new Font(fontFamily, attribute, size);
            fontCache.put(key, font);
        }
        return font;
    }

    public static void updateDefaultFont() {
        IGVPreferences prefManager = PreferencesManager.getPreferences();
        String fontFamily = prefManager.get("DEFAULT_FONT_FAMILY");
        int fontSize = prefManager.getAsInt("DEFAULT_FONT_SIZE");
        int attribute = prefManager.getAsInt("DEFAULT_FONT_ATTRIBUTE");
        defaultFont = new Font(fontFamily, attribute, fontSize);
    }

    public static void resetDefaultFont() {
        IGVPreferences prefMgr = PreferencesManager.getPreferences();
        prefMgr.remove("DEFAULT_FONT_SIZE");
        prefMgr.remove("DEFAULT_FONT_FAMILY");
        prefMgr.remove("DEFAULT_FONT_ATTRIBUTE");
        FontManager.updateDefaultFont();
    }

    public static void updateSystemFontSize(int size) {
        Object[] keys;
        Set keySet = UIManager.getLookAndFeelDefaults().keySet();
        for (Object key : keys = keySet.toArray(new Object[keySet.size()])) {
            Font font;
            if (key == null || !key.toString().toLowerCase().contains("font") || (font = UIManager.getDefaults().getFont(key)) == null) continue;
            font = font.deriveFont((float)size);
            UIManager.put(key, font);
        }
    }

    public static void scaleFontSize(double sf) {
        Object[] keys;
        scaleFactor = sf;
        Set keySet = UIManager.getLookAndFeelDefaults().keySet();
        for (Object key : keys = keySet.toArray(new Object[keySet.size()])) {
            Font font;
            if (key == null || !key.toString().toLowerCase().contains("font") || (font = UIManager.getDefaults().getFont(key)) == null) continue;
            int newSize = (int)(scaleFactor * (double)font.getSize());
            font = font.deriveFont((float)newSize);
            UIManager.put(key, font);
        }
    }

    static {
        fontCache = new Hashtable();
        scaleFactor = 1.0;
    }
}

