/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ga4gh;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.TextCigarCodec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SAMAlignment;

public class Ga4ghAlignment
extends SAMAlignment {
    private static Logger log = Logger.getLogger(Ga4ghAlignment.class);
    private final Map<String, String> tags;
    int inferredInsertSize;
    int mappingQuality = 255;
    String readName;
    protected String readSequence;
    private boolean negativeStrand;
    private int readNumber;
    private boolean duplicateFragment;
    private int numberReads;
    private boolean properPlacement;
    private boolean supplementaryAlignment;
    private boolean failedVendorQualityChecks;
    private boolean secondaryAlignment;
    private String cigarString;
    private boolean mapped;
    static Map<String, String> CigarMap = new HashMap<String, String>();

    public Ga4ghAlignment(JsonObject json) {
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        this.readName = json.get("fragmentName").getAsString();
        this.properPlacement = Ga4ghAlignment.hasNonNullValue(json, "properPlacement") ? json.get("properPlacement").getAsBoolean() : true;
        this.duplicateFragment = Ga4ghAlignment.hasNonNullValue(json, "duplicateFragment") ? json.get("duplicateFragment").getAsBoolean() : false;
        this.numberReads = Ga4ghAlignment.hasNonNullValue(json, "numberReads") ? json.get("numberReads").getAsInt() : 1;
        this.inferredInsertSize = Ga4ghAlignment.hasNonNullValue(json, "fragmentLength") ? json.get("fragmentLength").getAsInt() : 0;
        this.readNumber = Ga4ghAlignment.hasNonNullValue(json, "readNumber") ? json.get("readNumber").getAsInt() : 0;
        this.failedVendorQualityChecks = Ga4ghAlignment.hasNonNullValue(json, "failedVendorQualityChecks") ? json.get("failedVendorQualityChecks").getAsBoolean() : false;
        JsonObject alignmentObject = json.getAsJsonObject("alignment");
        if (alignmentObject == null) {
            this.mapped = false;
        } else {
            this.mapped = true;
            JsonObject positionObject = alignmentObject.getAsJsonObject("position");
            String refName = positionObject.get("referenceName").getAsString();
            this.setChr(genome == null ? refName : genome.getCanonicalChrName(refName));
            this.alignmentStart = positionObject.get("position").getAsInt();
            this.mappingQuality = Ga4ghAlignment.hasNonNullValue(alignmentObject, "mappingQuality") ? alignmentObject.get("mappingQuality").getAsInt() : 256;
            this.negativeStrand = Ga4ghAlignment.hasNonNullValue(positionObject, "reverseStrand") && positionObject.get("reverseStrand").getAsBoolean();
            this.cigarString = this.generateCigarString(alignmentObject.getAsJsonArray("cigar"));
            this.start = this.alignmentStart;
            this.end = this.alignmentEnd = this.alignmentStart + this.getReferenceLength(this.cigarString);
        }
        this.secondaryAlignment = Ga4ghAlignment.hasNonNullValue(json, "secondaryAlignment") ? json.get("secondaryAlignment").getAsBoolean() : false;
        this.supplementaryAlignment = Ga4ghAlignment.hasNonNullValue(json, "supplementaryAlignment") ? json.get("supplementaryAlignment").getAsBoolean() : false;
        this.readSequence = Ga4ghAlignment.hasNonNullValue(json, "alignedSequence") ? json.get("alignedSequence").getAsString() : null;
        byte[] baseQualities = Ga4ghAlignment.hasNonNullValue(json, "alignedQuality") ? this.generateBaseQualities(json.getAsJsonArray("alignedQuality")) : null;
        JsonObject mateObject = json.getAsJsonObject("nextMatePosition");
        if (mateObject == null) {
            this.setMate(new ReadMate("*", 0, false, true));
        } else {
            String mateReferenceName = mateObject.get("referenceName").getAsString();
            String mateChr = genome == null ? mateReferenceName : genome.getCanonicalChrName(mateReferenceName);
            int matePosition = Integer.parseInt(mateObject.get("position").getAsString());
            boolean mateNegStrand = Ga4ghAlignment.hasNonNullValue(mateObject, "reverseStrand") && mateObject.get("reverseStrand").getAsBoolean();
            this.setMate(new ReadMate(mateChr, matePosition, mateNegStrand, false));
        }
        JsonObject infoObject = json.getAsJsonObject("info");
        this.tags = this.generateTags(infoObject);
        this.setPairOrientation();
        this.setPairStrands();
        this.createAlignmentBlocks(this.cigarString, this.readSequence.getBytes(), baseQualities);
    }

    public static boolean hasNonNullValue(JsonObject json, String name) {
        return json.has(name) && !json.get(name).isJsonNull();
    }

    private Map<String, String> generateTags(JsonObject infoObject) {
        HashMap<String, String> tags = new HashMap<String, String>();
        if (infoObject != null) {
            for (Map.Entry<String, JsonElement> entry : infoObject.entrySet()) {
                String key = entry.getKey();
                JsonArray valueArray = entry.getValue().getAsJsonArray();
                String value = valueArray.get(0).getAsString();
                for (int i = 1; i < valueArray.size(); ++i) {
                    value = value + "," + valueArray.get(i).getAsString();
                }
                tags.put(key, value);
            }
        }
        return tags;
    }

    private byte[] generateBaseQualities(JsonArray alignedQuality) {
        byte[] baseQualities = new byte[alignedQuality.size()];
        Iterator<JsonElement> iter = alignedQuality.iterator();
        int i = 0;
        while (iter.hasNext()) {
            baseQualities[i++] = iter.next().getAsByte();
        }
        return baseQualities;
    }

    private String generateCigarString(JsonArray cigar) {
        StringBuffer cigarStr = new StringBuffer();
        Iterator<JsonElement> iter = cigar.iterator();
        while (iter.hasNext()) {
            JsonObject op = iter.next().getAsJsonObject();
            cigarStr.append(op.getAsJsonPrimitive("operationLength").getAsString());
            cigarStr.append(CigarMap.get(op.getAsJsonPrimitive("operation").getAsString()));
        }
        return cigarStr.toString();
    }

    @Override
    public int getAlignmentStart() {
        return this.alignmentStart;
    }

    @Override
    public int getAlignmentEnd() {
        return this.alignmentEnd;
    }

    @Override
    public String getReadName() {
        return this.readName;
    }

    @Override
    public int getMappingQuality() {
        return this.mappingQuality;
    }

    @Override
    public int getInferredInsertSize() {
        return this.inferredInsertSize;
    }

    @Override
    public String getCigarString() {
        return this.cigarString;
    }

    @Override
    public int getReadLength() {
        return this.readSequence.length();
    }

    @Override
    public String getReadSequence() {
        return this.readSequence;
    }

    @Override
    protected String getAttributeString(boolean truncate) {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            buffer.append("<br>");
            buffer.append(entry.getKey() + ": " + entry.getValue());
        }
        return buffer.toString();
    }

    @Override
    public boolean isFirstOfPair() {
        return this.readNumber == 0;
    }

    @Override
    public boolean isSecondOfPair() {
        return this.readNumber > 0;
    }

    @Override
    public boolean isDuplicate() {
        return this.duplicateFragment;
    }

    @Override
    public boolean isMapped() {
        return this.mapped;
    }

    @Override
    public boolean isPaired() {
        return this.numberReads > 1;
    }

    @Override
    public boolean isProperPair() {
        return this.properPlacement;
    }

    @Override
    public boolean isSupplementary() {
        return this.supplementaryAlignment;
    }

    @Override
    public boolean isVendorFailedRead() {
        return this.failedVendorQualityChecks;
    }

    @Override
    public boolean isPrimary() {
        return !this.secondaryAlignment;
    }

    @Override
    public Object getAttribute(String key) {
        return this.tags.get(key);
    }

    public int getReferenceLength(String cigarString) {
        TextCigarCodec codec = new TextCigarCodec();
        Cigar cigar = TextCigarCodec.decode(cigarString);
        return cigar.getReferenceLength();
    }

    @Override
    public boolean isNegativeStrand() {
        return this.negativeStrand;
    }

    @Override
    public String getSample() {
        return null;
    }

    @Override
    public String getReadGroup() {
        return null;
    }

    @Override
    public String getLibrary() {
        return null;
    }

    static {
        CigarMap.put("ALIGNMENT_MATCH", "M");
        CigarMap.put("INSERT", "I");
        CigarMap.put("DELETE", "D");
        CigarMap.put("SKIP", "N");
        CigarMap.put("CLIP_SOFT", "S");
        CigarMap.put("CLIP_HARD", "H");
        CigarMap.put("PAD", "P");
        CigarMap.put("SEQUENCE_MATCH", "=");
        CigarMap.put("SEQUENCE_MISMATCH", "X");
    }
}

