/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools.motiffinder;

import htsjdk.samtools.util.SequenceUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.StringUtils;

public class MotifFinderDialog
extends JDialog {
    private static Map<String, String> letterToRegex;
    private static Set<String> validIUPACInputStrings;
    private String[] posTrackNames;
    private String[] negTrackNames;
    private String[] inputPatterns;
    static final int MaxTrackNameLength = 100;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel label2;
    private JLabel label4;
    private JTextArea patternField;
    private JTextArea textArea1;
    private JPanel vSpacer1;
    private JPanel panel1;
    private JLabel label1;
    private JTextField posNameField;
    private JPanel panel2;
    private JLabel label3;
    private JTextField negNameField;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    private static void initLetterToRegex() {
        letterToRegex = ParsingUtils.loadIUPACMap();
        validIUPACInputStrings = new HashSet<String>(letterToRegex.size());
        for (String key : letterToRegex.keySet()) {
            validIUPACInputStrings.add(key.toUpperCase());
        }
    }

    public static boolean isIUPACChar(String c) {
        return validIUPACInputStrings.contains(c);
    }

    public MotifFinderDialog(Frame owner) {
        super(owner, "Find motif");
        this.initComponents();
    }

    public String[] getInputPattern() {
        return this.inputPatterns;
    }

    public String[] getPosTrackName() {
        return this.posTrackNames;
    }

    public String[] getNegTrackName() {
        return this.negTrackNames;
    }

    static String convertMotifToRegex(String motif) {
        String output = motif;
        int outloc = 0;
        for (int inloc = 0; inloc < motif.length(); ++inloc) {
            String inchar = motif.substring(inloc, inloc + 1);
            String rep = letterToRegex.get(inchar);
            output = output.substring(0, outloc) + rep + motif.substring(inloc + 1);
            outloc += rep.length();
        }
        return output;
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    void okButtonActionPerformed(ActionEvent e) {
        this.inputPatterns = null;
        String[] lines = this.patternField.getText().split("[\\r\\n]+");
        String[] patterns = new String[lines.length];
        boolean isMultiMatch = lines.length >= 2;
        this.posTrackNames = new String[lines.length];
        this.negTrackNames = new String[lines.length];
        for (int ii = 0; ii < lines.length; ++ii) {
            boolean patternIsValid;
            String strPattern = lines[ii].toUpperCase().trim();
            if (strPattern.length() == 0) {
                MessageUtils.showMessage("Please enter a search pattern.");
                return;
            }
            boolean isIUPAC = MotifFinderDialog.checkIUPACPatternValid(strPattern);
            boolean isRegex = MotifFinderDialog.checkNucleotideRegex(strPattern);
            boolean bl = patternIsValid = isIUPAC || isRegex;
            if (!patternIsValid) {
                MessageUtils.showMessage("Please enter a valid pattern.\nPatterns using IUPAC ambiguity codes should contain no special characters.\nRegular expressions should contain only 'ACTGN' in addition to special characters.\n" + strPattern + " is invalid");
                return;
            }
            if (isIUPAC) {
                strPattern = MotifFinderDialog.convertMotifToRegex(strPattern);
            }
            if (isMultiMatch) {
                String posName;
                this.posTrackNames[ii] = posName = this.getPosNameFromPattern(strPattern);
                this.negTrackNames[ii] = this.getNegNameFromPositive(posName);
            } else {
                this.posTrackNames[ii] = this.posNameField.getText();
                this.negTrackNames[ii] = this.negNameField.getText();
                if (this.posTrackNames[ii].equalsIgnoreCase(this.negTrackNames[ii])) {
                    MessageUtils.showMessage("Track names must be different");
                    return;
                }
            }
            patterns[ii] = strPattern;
        }
        this.inputPatterns = patterns;
        this.setVisible(false);
    }

    static boolean checkIUPACPatternValid(String strPattern) {
        for (int ii = 0; ii < strPattern.length(); ++ii) {
            String c = strPattern.substring(ii, ii + 1);
            if (MotifFinderDialog.isIUPACChar(c)) continue;
            return false;
        }
        return true;
    }

    static boolean checkNucleotideRegex(String strPattern) {
        try {
            byte[] bytes;
            Pattern pattern = Pattern.compile(strPattern);
            for (byte c : bytes = strPattern.getBytes()) {
                if (!Character.isLetter(c)) continue;
                boolean validBase = SequenceUtil.isValidBase(c);
                if (validBase |= c == 78) continue;
                return false;
            }
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    private boolean isMultiMatch() {
        String patternText = this.patternField.getText();
        return patternText.contains("\n") || patternText.contains("\r");
    }

    private void updateNegNameFieldFromPattern() {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                String posText = MotifFinderDialog.this.posNameField.getText();
                MotifFinderDialog.this.negNameField.setText(MotifFinderDialog.this.getNegNameFromPositive(posText));
                MotifFinderDialog.this.negNameField.setEnabled(!MotifFinderDialog.this.isMultiMatch());
            }
        });
    }

    private void updatePosNameFieldFromPattern() {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                String posNameText = "Auto";
                boolean hasNewlines = MotifFinderDialog.this.isMultiMatch();
                if (!hasNewlines) {
                    String patternText = MotifFinderDialog.this.patternField.getText();
                    posNameText = StringUtils.checkLength(patternText, 100);
                }
                MotifFinderDialog.this.posNameField.setEnabled(!MotifFinderDialog.this.isMultiMatch());
                MotifFinderDialog.this.posNameField.setText(posNameText);
            }
        });
    }

    private String getPosNameFromPattern(String patternText) {
        return StringUtils.checkLength(patternText, 100);
    }

    private String getNegNameFromPositive(String posText) {
        return posText + " Negative";
    }

    private void patternFieldCaretUpdate(CaretEvent e) {
        this.updatePosNameFieldFromPattern();
        this.updateNegNameFieldFromPattern();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.label2 = new JLabel();
        this.label4 = new JLabel();
        this.patternField = new JTextArea();
        this.textArea1 = new JTextArea();
        this.vSpacer1 = new JPanel(null);
        this.panel1 = new JPanel();
        this.label1 = new JLabel();
        this.posNameField = new JTextField();
        this.panel2 = new JPanel();
        this.label3 = new JLabel();
        this.negNameField = new JTextField();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setModal(true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setAlignmentX(0.0f);
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.label2.setText("Search Pattern:");
        this.label2.setLabelFor(this.patternField);
        this.label2.setHorizontalTextPosition(2);
        this.label2.setHorizontalAlignment(2);
        this.label2.setAlignmentX(1.0f);
        this.label2.setMaximumSize(new Dimension(374, 16));
        this.label2.setPreferredSize(new Dimension(374, 16));
        this.contentPanel.add(this.label2);
        this.contentPanel.add(this.label4);
        this.patternField.setToolTipText("Enter multiple patterns, separated by newlines");
        this.patternField.setRows(2);
        this.patternField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                MotifFinderDialog.this.patternFieldCaretUpdate(e);
            }
        });
        this.contentPanel.add(this.patternField);
        this.textArea1.setText("Enter nucleotide sequence (e.g. ACCGCT),  or nucleotide sequence with IUPAC ambiguity codes (e.g. AAARNR),  or regular expression of nucleotides (e.g. TATAAA(A){3,}). ");
        this.textArea1.setEditable(false);
        this.textArea1.setBackground(new Color(238, 238, 238));
        this.textArea1.setLineWrap(true);
        this.textArea1.setWrapStyleWord(true);
        this.textArea1.setFont(this.textArea1.getFont().deriveFont(this.textArea1.getFont().getStyle() | 2, (float)this.textArea1.getFont().getSize() - 2.0f));
        this.textArea1.setMargin(new Insets(0, 25, 0, 0));
        this.textArea1.setFocusable(false);
        this.contentPanel.add(this.textArea1);
        this.vSpacer1.setMinimumSize(new Dimension(12, 20));
        this.vSpacer1.setPreferredSize(new Dimension(10, 20));
        this.contentPanel.add(this.vSpacer1);
        this.panel1.setLayout(new BoxLayout(this.panel1, 0));
        this.label1.setText("Positive Strand Track Name:");
        this.label1.setLabelFor(this.posNameField);
        this.label1.setHorizontalTextPosition(2);
        this.label1.setHorizontalAlignment(2);
        this.label1.setMaximumSize(new Dimension(374, 16));
        this.label1.setPreferredSize(new Dimension(200, 16));
        this.label1.setAlignmentX(1.0f);
        this.panel1.add(this.label1);
        this.panel1.add(this.posNameField);
        this.contentPanel.add(this.panel1);
        this.panel2.setLayout(new BoxLayout(this.panel2, 0));
        this.label3.setText("Negative Strand Track Name:");
        this.label3.setLabelFor(this.negNameField);
        this.label3.setHorizontalTextPosition(2);
        this.label3.setHorizontalAlignment(2);
        this.label3.setMaximumSize(new Dimension(374, 16));
        this.label3.setPreferredSize(new Dimension(200, 16));
        this.label3.setAlignmentX(1.0f);
        this.panel2.add(this.label3);
        this.panel2.add(this.negNameField);
        this.contentPanel.add(this.panel2);
        this.dialogPane.add((Component)this.contentPanel, "North");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MotifFinderDialog.this.okButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MotifFinderDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(450, 300);
        this.setLocationRelativeTo(this.getOwner());
    }

    void setPatternFieldText(String text) {
        this.patternField.setText(text);
    }

    static {
        MotifFinderDialog.initLetterToRegex();
    }
}

