/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.math.stat.StatUtils;
import org.apache.log4j.Logger;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.collections.DownsampledDoubleArrayList;

public class Accumulator {
    private static Logger log = Logger.getLogger(Accumulator.class);
    private static int MAX_VALUE_COUNT = 100000;
    boolean isFinished = false;
    WindowFunction windowFunction;
    float sum = 0.0f;
    int basesCovered = 0;
    int nPts = 0;
    float value = Float.NaN;
    DownsampledDoubleArrayList valueList;
    int nRepValues;
    float[] repData;
    String[] repProbes;
    static Set<WindowFunction> PERCENTILE_WINDOW_FUNCTIONS = new HashSet<WindowFunction>();

    public Accumulator(WindowFunction windowFunction, int nRepValues) {
        this(windowFunction);
        if (nRepValues > 0) {
            this.nRepValues = nRepValues;
            this.repData = new float[nRepValues];
            this.repProbes = new String[nRepValues];
        }
    }

    public Accumulator(WindowFunction windowFunction) {
        this.windowFunction = windowFunction;
        if (PERCENTILE_WINDOW_FUNCTIONS.contains(windowFunction)) {
            this.valueList = new DownsampledDoubleArrayList(100, MAX_VALUE_COUNT);
        }
    }

    public boolean hasData() {
        return this.basesCovered > 0;
    }

    public void add(int nBases, float v, String probe) {
        if (this.isFinished) {
            log.error("Attempt to add data to a finalized accumulator");
            throw new RuntimeException("Attempt to add data to a finalized accumulator");
        }
        if (nBases < 1) {
            nBases = 1;
        }
        if (!Float.isNaN(v)) {
            if (this.repData != null && this.nPts < this.repData.length) {
                this.repData[this.nPts] = v;
                this.repProbes[this.nPts] = probe;
            }
            switch (this.windowFunction) {
                case min: {
                    this.value = Float.isNaN(this.value) ? v : Math.min(this.value, v);
                    break;
                }
                case max: {
                    this.value = Float.isNaN(this.value) ? v : Math.max(this.value, v);
                    break;
                }
                case mean: {
                    this.sum += (float)nBases * v;
                    break;
                }
                default: {
                    if (this.valueList == null) break;
                    this.valueList.add(v);
                }
            }
            ++this.nPts;
            this.basesCovered += nBases;
        }
    }

    public void finish() {
        if (this.isFinished) {
            return;
        }
        if (this.windowFunction == WindowFunction.mean) {
            this.value = Float.isNaN(this.sum) ? Float.NaN : this.sum / (float)this.basesCovered;
        } else if (this.valueList != null) {
            if (this.valueList.size() == 0) {
                this.value = Float.NaN;
            } else if (this.valueList.size() == 1) {
                this.value = (float)this.valueList.get(0);
            } else {
                double[] valueArray = this.valueList.toArray();
                double p = this.getPercentile(this.windowFunction);
                this.value = p > 0.0 ? (float)StatUtils.percentile(valueArray, p) : Float.NaN;
            }
        }
        this.valueList = null;
        this.isFinished = true;
    }

    public int getNpts() {
        return this.nPts;
    }

    public String[] getRepProbes() {
        return this.repProbes;
    }

    public float getValue() {
        if (!this.isFinished) {
            this.finish();
        }
        return this.value;
    }

    public double getPercentile(WindowFunction wf) {
        switch (wf) {
            case percentile2: {
                return 2.0;
            }
            case percentile10: {
                return 10.0;
            }
            case percentile90: {
                return 90.0;
            }
            case percentile98: {
                return 98.0;
            }
            case median: {
                return 50.0;
            }
        }
        return -1.0;
    }

    public float[] getRepData() {
        return this.repData;
    }

    static {
        PERCENTILE_WINDOW_FUNCTIONS.add(WindowFunction.median);
        PERCENTILE_WINDOW_FUNCTIONS.add(WindowFunction.percentile2);
        PERCENTILE_WINDOW_FUNCTIONS.add(WindowFunction.percentile10);
        PERCENTILE_WINDOW_FUNCTIONS.add(WindowFunction.percentile90);
        PERCENTILE_WINDOW_FUNCTIONS.add(WindowFunction.percentile98);
    }

    class PercentileValue {
        int nPoints;
        double value;

        PercentileValue(int nPoints, double value) {
            this.nPoints = nPoints;
            this.value = value;
        }
    }
}

