/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.common.Version;
import java.util.Arrays;
import java.util.Objects;

public final class CramHeader {
    public static final byte[] MAGIC = "CRAM".getBytes();
    private Version version;
    private final byte[] id = new byte[20];
    private SAMFileHeader samFileHeader;

    private CramHeader() {
        Arrays.fill(this.id, (byte)0);
    }

    public CramHeader(Version version, String id, SAMFileHeader samFileHeader) {
        Arrays.fill(this.id, (byte)0);
        this.version = version;
        if (id != null) {
            System.arraycopy(id.getBytes(), 0, this.id, 0, Math.min(id.length(), this.id.length));
        }
        this.samFileHeader = samFileHeader;
    }

    public void setID(String stringID) {
        System.arraycopy(stringID.getBytes(), 0, this.id, 0, Math.min(this.id.length, stringID.length()));
    }

    public CramHeader clone() {
        CramHeader clone = new CramHeader();
        clone.version = this.version;
        System.arraycopy(this.id, 0, clone.id, 0, this.id.length);
        clone.samFileHeader = this.getSamFileHeader().clone();
        return clone;
    }

    public SAMFileHeader getSamFileHeader() {
        return this.samFileHeader;
    }

    public byte[] getId() {
        return this.id;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CramHeader that = (CramHeader)o;
        return Objects.equals(this.version, that.version) && Arrays.equals(this.id, that.id) && Objects.equals(this.samFileHeader, that.samFileHeader);
    }

    public int hashCode() {
        int result = Objects.hash(this.version, this.samFileHeader);
        result = 31 * result + Arrays.hashCode(this.id);
        return result;
    }
}

