/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.block.Block;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class CramIO {
    public static final String CRAM_FILE_EXTENSION = ".cram";
    public static final byte[] ZERO_B_EOF_MARKER = CramIO.bytesFromHex("0b 00 00 00 ff ff ff ff ff e0 45 4f 46 00 00 00 00 01 00 00 01 00 06 06 01 00 01 00 01 00");
    public static final byte[] ZERO_F_EOF_MARKER = CramIO.bytesFromHex("0f 00 00 00 ff ff ff ff 0f e0 45 4f 46 00 00 00 00 01 00 05 bd d9 4f 00 01 00 06 06 01 00 01 00 01 00 ee 63 01 4b");
    private static final int DEFINITION_LENGTH = 26;
    private static final Log log = Log.getInstance(CramIO.class);

    private static byte[] bytesFromHex(String string) {
        String clean = string.replaceAll("[^0-9a-fA-F]", "");
        if (clean.length() % 2 != 0) {
            throw new RuntimeException("Not a hex string: " + string);
        }
        byte[] data = new byte[clean.length() / 2];
        for (int i = 0; i < clean.length(); i += 2) {
            data[i / 2] = Integer.decode("0x" + clean.charAt(i) + clean.charAt(i + 1)).byteValue();
        }
        return data;
    }

    public static long issueEOF(Version version, OutputStream outputStream) {
        try {
            if (version.compatibleWith(CramVersions.CRAM_v3)) {
                outputStream.write(ZERO_F_EOF_MARKER);
                return ZERO_F_EOF_MARKER.length;
            }
            if (version.compatibleWith(CramVersions.CRAM_v2_1)) {
                outputStream.write(ZERO_B_EOF_MARKER);
                return ZERO_B_EOF_MARKER.length;
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return 0L;
    }

    public static long writeHeader(Version cramVersion, OutputStream outStream, SAMFileHeader samFileHeader, String cramID) {
        CramHeader cramHeader = new CramHeader(cramVersion, cramID, samFileHeader);
        return CramIO.writeCramHeader(cramHeader, outStream);
    }

    private static boolean streamEndsWith(SeekableStream seekableStream, byte[] marker) throws IOException {
        byte[] tail = new byte[marker.length];
        seekableStream.seek(seekableStream.length() - (long)marker.length);
        InputStreamUtils.readFully(seekableStream, tail, 0, tail.length);
        if (Arrays.equals(tail, marker)) {
            return true;
        }
        tail[8] = marker[8];
        return Arrays.equals(tail, marker);
    }

    private static boolean checkEOF(Version version, SeekableStream seekableStream) throws IOException {
        if (version.compatibleWith(CramVersions.CRAM_v3)) {
            return CramIO.streamEndsWith(seekableStream, ZERO_F_EOF_MARKER);
        }
        if (version.compatibleWith(CramVersions.CRAM_v2_1)) {
            return CramIO.streamEndsWith(seekableStream, ZERO_B_EOF_MARKER);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkHeaderAndEOF(File file) {
        try (SeekableFileStream seekableStream = new SeekableFileStream(file);){
            CramHeader cramHeader = CramIO.readCramHeader(seekableStream);
            boolean bl = CramIO.checkEOF(cramHeader.getVersion(), seekableStream);
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static long writeCramHeader(CramHeader cramHeader, OutputStream outputStream) {
        try {
            outputStream.write("CRAM".getBytes("US-ASCII"));
            outputStream.write(cramHeader.getVersion().major);
            outputStream.write(cramHeader.getVersion().minor);
            outputStream.write(cramHeader.getId());
            for (int i = cramHeader.getId().length; i < 20; ++i) {
                outputStream.write(0);
            }
            long length = CramIO.writeContainerForSamFileHeader(cramHeader.getVersion().major, cramHeader.getSamFileHeader(), outputStream);
            return 26L + length;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private static CramHeader readFormatDefinition(InputStream inputStream) throws IOException {
        for (byte magicByte : CramHeader.MAGIC) {
            if (magicByte == inputStream.read()) continue;
            throw new RuntimeException("Unknown file format.");
        }
        Version version = new Version(inputStream.read(), inputStream.read(), 0);
        CramHeader header = new CramHeader(version, null, null);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.readFully(header.getId());
        return header;
    }

    public static CramHeader readCramHeader(InputStream inputStream) {
        try {
            CramHeader header = CramIO.readFormatDefinition(inputStream);
            SAMFileHeader samFileHeader = CramIO.readSAMFileHeader(header.getVersion(), inputStream, new String(header.getId()));
            return new CramHeader(header.getVersion(), new String(header.getId()), samFileHeader);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private static byte[] toByteArray(SAMFileHeader samFileHeader) {
        ByteArrayOutputStream headerBodyOS = new ByteArrayOutputStream();
        OutputStreamWriter outStreamWriter = new OutputStreamWriter(headerBodyOS);
        new SAMTextHeaderCodec().encode(outStreamWriter, samFileHeader);
        try {
            outStreamWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(headerBodyOS.size());
        buf.flip();
        byte[] bytes = new byte[buf.limit()];
        buf.get(bytes);
        ByteArrayOutputStream headerOS = new ByteArrayOutputStream();
        try {
            headerOS.write(bytes);
            headerOS.write(headerBodyOS.toByteArray(), 0, headerBodyOS.size());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return headerOS.toByteArray();
    }

    private static long writeContainerForSamFileHeader(int major, SAMFileHeader samFileHeader, OutputStream os) {
        byte[] data = CramIO.toByteArray(samFileHeader);
        int length = Math.max(1024, data.length + data.length / 2);
        byte[] blockContent = new byte[length];
        System.arraycopy(data, 0, blockContent, 0, Math.min(data.length, length));
        Block block = Block.createRawFileHeaderBlock(blockContent);
        Container container = new Container();
        container.blockCount = 1;
        container.blocks = new Block[]{block};
        container.landmarks = new int[0];
        container.slices = new Slice[0];
        container.alignmentSpan = 0;
        container.alignmentStart = -1;
        container.bases = 0L;
        container.globalRecordCounter = 0L;
        container.nofRecords = 0;
        container.sequenceId = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        block.write(major, byteArrayOutputStream);
        container.containerByteSize = byteArrayOutputStream.size();
        int containerHeaderByteSize = ContainerIO.writeContainerHeader(major, container, os);
        try {
            os.write(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return containerHeaderByteSize + byteArrayOutputStream.size();
    }

    private static SAMFileHeader readSAMFileHeader(Version version, InputStream inputStream, String id) {
        Block block;
        Container container = ContainerIO.readContainerHeader(version.major, inputStream);
        if (version.compatibleWith(CramVersions.CRAM_v3)) {
            byte[] bytes = new byte[container.containerByteSize];
            InputStreamUtils.readFully(inputStream, bytes, 0, bytes.length);
            block = Block.read(version.major, new ByteArrayInputStream(bytes));
        } else {
            block = Block.read(version.major, inputStream);
        }
        inputStream = new ByteArrayInputStream(block.getUncompressedContent());
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        try {
            for (int i = 0; i < 4; ++i) {
                buffer.put((byte)inputStream.read());
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        buffer.flip();
        int size = buffer.asIntBuffer().get();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] bytes = new byte[size];
        try {
            dataInputStream.readFully(bytes);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        BufferedLineReader bufferedLineReader = new BufferedLineReader(new ByteArrayInputStream(bytes));
        SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
        return codec.decode(bufferedLineReader, id);
    }

    /*
     * Exception decompiling
     */
    public static boolean replaceCramHeader(File file, CramHeader newHeader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

