/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import picard.PicardException;

public class TileIndex
implements Iterable<TileIndexRecord> {
    private final File tileIndexFile;
    private final List<TileIndexRecord> tiles = new ArrayList<TileIndexRecord>();

    TileIndex(File tileIndexFile) {
        try {
            this.tileIndexFile = tileIndexFile;
            InputStream is = IOUtil.maybeBufferInputStream(new FileInputStream(tileIndexFile));
            ByteBuffer buf = ByteBuffer.allocate(8);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            int absoluteRecordIndex = 0;
            int numTiles = 0;
            while (this.readTileIndexRecord(buf.array(), buf.capacity(), is)) {
                buf.rewind();
                buf.limit(buf.capacity());
                int tile = buf.getInt();
                if (tile < 0) {
                    throw new PicardException("Tile number too large in " + tileIndexFile.getAbsolutePath());
                }
                int numClusters = buf.getInt();
                if (numClusters < 0) {
                    throw new PicardException("Cluster size too large in " + tileIndexFile.getAbsolutePath());
                }
                this.tiles.add(new TileIndexRecord(tile, numClusters, absoluteRecordIndex, numTiles++));
                absoluteRecordIndex += numClusters;
            }
            CloserUtil.close(is);
        }
        catch (IOException e) {
            throw new PicardException("Problem reading " + tileIndexFile.getAbsolutePath(), e);
        }
    }

    public File getFile() {
        return this.tileIndexFile;
    }

    public int getNumTiles() {
        return this.tiles.size();
    }

    private boolean readTileIndexRecord(byte[] buf, int numBytes, InputStream is) throws IOException {
        int bytesRead;
        for (int totalBytesRead = 0; totalBytesRead < numBytes; totalBytesRead += bytesRead) {
            bytesRead = is.read(buf, totalBytesRead, numBytes - totalBytesRead);
            if (bytesRead != -1) continue;
            if (totalBytesRead != 0) {
                throw new PicardException(this.tileIndexFile.getAbsolutePath() + " has incomplete last block");
            }
            return false;
        }
        return true;
    }

    public List<Integer> getTiles() {
        ArrayList<Integer> ret = new ArrayList<Integer>(this.tiles.size());
        for (TileIndexRecord rec : this.tiles) {
            ret.add(rec.tile);
        }
        return ret;
    }

    public List<String> verify(List<Integer> expectedTiles) {
        HashSet<Integer> tileSet = new HashSet<Integer>(this.tiles.size());
        for (TileIndexRecord rec : this.tiles) {
            tileSet.add(rec.tile);
        }
        LinkedList<String> failures = new LinkedList<String>();
        for (int expectedTile : expectedTiles) {
            if (tileSet.contains(expectedTile)) continue;
            failures.add("Tile " + expectedTile + " not found in " + this.tileIndexFile.getAbsolutePath());
        }
        return failures;
    }

    @Override
    public Iterator<TileIndexRecord> iterator() {
        return this.tiles.iterator();
    }

    public TileIndexRecord findTile(int tileNumber) {
        for (TileIndexRecord rec : this) {
            if (rec.tile == tileNumber) {
                return rec;
            }
            if (rec.tile <= tileNumber) continue;
            break;
        }
        throw new NoSuchElementException(String.format("Tile %d not found in %s", tileNumber, this.tileIndexFile));
    }

    public static class TileIndexRecord {
        final int tile;
        final int numClustersInTile;
        final int indexOfFirstClusterInTile;
        final int zeroBasedTileNumber;

        public int getNumClustersInTile() {
            return this.numClustersInTile;
        }

        public int getZeroBasedTileNumber() {
            return this.zeroBasedTileNumber;
        }

        private TileIndexRecord(int tile, int numClustersInTile, int indexOfFirstClusterInTile, int zeroBasedTileNumber) {
            this.tile = tile;
            this.numClustersInTile = numClustersInTile;
            this.indexOfFirstClusterInTile = indexOfFirstClusterInTile;
            this.zeroBasedTileNumber = zeroBasedTileNumber;
        }
    }
}

