/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.FormatUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.directed.TargetMetrics;
import picard.metrics.MultilevelMetrics;
import picard.metrics.PerUnitMetricCollector;
import picard.metrics.SAMRecordMultiLevelCollector;

public abstract class TargetMetricsCollector<METRIC_TYPE extends MultilevelMetrics>
extends SAMRecordMultiLevelCollector<METRIC_TYPE, Integer> {
    private static final int NEAR_PROBE_DISTANCE = 250;
    private final File perTargetCoverage;
    private final String probeSetName;
    private static final Log log = Log.getInstance(TargetMetricsCollector.class);
    private final IntervalList allProbes;
    private final IntervalList allTargets;
    private final OverlapDetector<Interval> targetDetector;
    private final OverlapDetector<Interval> probeDetector;
    private Map<Interval, Double> intervalToGc = null;
    private final long probeTerritory;
    private final long targetTerritory;
    private final long genomeSize;
    private Map<Interval, Coverage> coverageByTargetForRead;
    private Coverage[] cov;

    public abstract METRIC_TYPE convertMetric(TargetMetrics var1);

    protected static <MT extends MetricBase> void reflectiveCopy(TargetMetrics targetMetrics, MT outputMetrics, String[] targetKeys, String[] outputKeys) {
        if (targetKeys == null || outputKeys == null) {
            if (outputKeys != null) {
                throw new PicardException("Target keys is null but output keys == " + StringUtil.join(",", outputKeys));
            }
            if (targetKeys != null) {
                throw new PicardException("Output keys is null but target keys == " + StringUtil.join(",", targetKeys));
            }
        } else if (targetKeys.length != outputKeys.length) {
            throw new PicardException("Target keys and output keys do not have the same length: targetKeys == (" + StringUtil.join(",", targetKeys) + ") " + "outputKeys == (" + StringUtil.join(",", outputKeys) + ")");
        }
        Class<?> mtClass = outputMetrics.getClass();
        Set<Field> targetSet = CollectionUtil.makeSet(TargetMetrics.class.getFields());
        for (String targetKey : targetKeys) {
            if (!targetSet.contains(targetKey)) continue;
            targetSet.remove(targetKey);
        }
        HashSet<String> outputSet = new HashSet<String>();
        for (Field field : outputMetrics.getClass().getFields()) {
            outputSet.add(field.getName());
        }
        for (Field field : targetSet) {
            if (!outputSet.contains(field.getName())) continue;
            try {
                Field outputField = mtClass.getField(field.getName());
                outputField.set(outputMetrics, field.get(targetMetrics));
            }
            catch (Exception e) {
                throw new PicardException("Exception while copying targetMetrics to " + outputMetrics.getClass().getName(), e);
            }
        }
        for (int i = 0; i < targetKeys.length; ++i) {
            try {
                Field targetMetricField = TargetMetrics.class.getField(targetKeys[i]);
                Field outputMetricField = mtClass.getField(outputKeys[i]);
                outputMetricField.set(outputMetrics, targetMetricField.get(targetMetrics));
                continue;
            }
            catch (Exception exc) {
                throw new PicardException("Exception while copying TargetMetrics." + targetKeys[i] + " to " + mtClass.getName() + "." + outputKeys[i], exc);
            }
        }
    }

    public TargetMetricsCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, ReferenceSequenceFile refFile, File perTargetCoverage, IntervalList targetIntervals, IntervalList probeIntervals, String probeSetName) {
        this.perTargetCoverage = perTargetCoverage;
        this.probeSetName = probeSetName;
        this.allProbes = probeIntervals;
        this.allTargets = targetIntervals;
        List<Interval> uniqueBaits = this.allProbes.getUniqueIntervals();
        this.probeDetector = new OverlapDetector(-250, 0);
        this.probeDetector.addAll(uniqueBaits, uniqueBaits);
        this.probeTerritory = Interval.countBases(uniqueBaits);
        List<Interval> uniqueTargets = this.allTargets.getUniqueIntervals();
        this.targetDetector = new OverlapDetector(0, 0);
        this.targetDetector.addAll(uniqueTargets, uniqueTargets);
        this.targetTerritory = Interval.countBases(uniqueTargets);
        int i = 0;
        this.cov = new Coverage[uniqueTargets.size()];
        this.coverageByTargetForRead = new LinkedHashMap<Interval, Coverage>(uniqueTargets.size() * 2, 0.5f);
        for (Interval target : uniqueTargets) {
            Coverage coverage = new Coverage(target, 0);
            this.coverageByTargetForRead.put(target, coverage);
            this.cov[i++] = coverage;
        }
        long genomeSizeAccumulator = 0L;
        for (SAMSequenceRecord seq : this.allProbes.getHeader().getSequenceDictionary().getSequences()) {
            genomeSizeAccumulator += (long)seq.getSequenceLength();
        }
        this.genomeSize = genomeSizeAccumulator;
        if (refFile != null) {
            this.intervalToGc = new HashMap<Interval, Double>();
            for (Interval target : uniqueTargets) {
                ReferenceSequence rs = refFile.getSubsequenceAt(target.getSequence(), target.getStart(), target.getEnd());
                this.intervalToGc.put(target, SequenceUtil.calculateGc(rs.getBases()));
            }
        }
        this.setup(accumulationLevels, samRgRecords);
    }

    @Override
    protected PerUnitMetricCollector<METRIC_TYPE, Integer, SAMRecord> makeChildCollector(String sample, String library, String readGroup) {
        PerUnitTargetMetricCollector collector = new PerUnitTargetMetricCollector(this.probeSetName, this.coverageByTargetForRead.keySet(), sample, library, readGroup, this.probeTerritory, this.targetTerritory, this.genomeSize, this.intervalToGc);
        if (this.probeSetName != null) {
            collector.setBaitSetName(this.probeSetName);
        }
        return collector;
    }

    @Override
    protected PerUnitMetricCollector<METRIC_TYPE, Integer, SAMRecord> makeAllReadCollector() {
        PerUnitTargetMetricCollector collector = (PerUnitTargetMetricCollector)this.makeChildCollector(null, null, null);
        if (this.perTargetCoverage != null) {
            collector.setPerTargetOutput(this.perTargetCoverage);
        }
        return collector;
    }

    public static class Coverage {
        private final Interval interval;
        private final short[] depths;

        public Coverage(Interval i, int padding) {
            this.interval = i;
            this.depths = new short[this.interval.length() + 2 * padding];
        }

        public void addBase(int offset) {
            if (offset >= 0 && offset < this.depths.length && this.depths[offset] < Short.MAX_VALUE) {
                int n = offset;
                this.depths[n] = (short)(this.depths[n] + 1);
            }
        }

        public boolean hasCoverage() {
            for (short s : this.depths) {
                if (s <= 1) continue;
                return true;
            }
            return false;
        }

        public short[] getDepths() {
            return this.depths;
        }

        public int getTotal() {
            int total = 0;
            for (int i = 0; i < this.depths.length; ++i) {
                total += this.depths[i];
            }
            return total;
        }

        public String toString() {
            return "TargetedMetricCollector(interval=" + this.interval + ", depths = [" + StringUtil.intValuesToString(this.depths) + "])";
        }
    }

    public class PerUnitTargetMetricCollector
    implements PerUnitMetricCollector<METRIC_TYPE, Integer, SAMRecord> {
        private final Map<Interval, Double> intervalToGc;
        private File perTargetOutput;
        private final Map<Interval, Coverage> coverageByTarget;
        private final TargetMetrics metrics = new TargetMetrics();

        public PerUnitTargetMetricCollector(String probeSetName, Set<Interval> coverageTargets, String sample, String library, String readGroup, long probeTerritory, long targetTerritory, long genomeSize, Map<Interval, Double> intervalToGc) {
            this.metrics.SAMPLE = sample;
            this.metrics.LIBRARY = library;
            this.metrics.READ_GROUP = readGroup;
            this.metrics.PROBE_SET = probeSetName;
            this.metrics.PROBE_TERRITORY = probeTerritory;
            this.metrics.TARGET_TERRITORY = targetTerritory;
            this.metrics.GENOME_SIZE = genomeSize;
            this.coverageByTarget = new LinkedHashMap<Interval, Coverage>(coverageTargets.size() * 2, 0.5f);
            for (Interval target : coverageTargets) {
                this.coverageByTarget.put(target, new Coverage(target, 0));
            }
            this.intervalToGc = intervalToGc;
        }

        public void setPerTargetOutput(File perTargetOutput) {
            this.perTargetOutput = perTargetOutput;
        }

        public void setBaitSetName(String name) {
            this.metrics.PROBE_SET = name;
        }

        @Override
        public void acceptRecord(SAMRecord rec) {
            boolean mappedInPair;
            Collection probes;
            Collection targets;
            if (rec.isSecondaryOrSupplementary()) {
                return;
            }
            ++this.metrics.TOTAL_READS;
            if (rec.getReadFailsVendorQualityCheckFlag()) {
                return;
            }
            if (!rec.getReadUnmappedFlag()) {
                Interval read = new Interval(rec.getReferenceName(), rec.getAlignmentStart(), rec.getAlignmentEnd());
                targets = TargetMetricsCollector.this.targetDetector.getOverlaps(read);
                probes = TargetMetricsCollector.this.probeDetector.getOverlaps(read);
            } else {
                targets = null;
                probes = null;
            }
            ++this.metrics.PF_READS;
            this.metrics.PF_BASES += (long)rec.getReadLength();
            if (rec.getReadPairedFlag() && rec.getFirstOfPairFlag() && !rec.getReadUnmappedFlag() && !rec.getMateUnmappedFlag() && probes != null && !probes.isEmpty()) {
                ++this.metrics.PF_SELECTED_PAIRS;
                if (!rec.getDuplicateReadFlag()) {
                    ++this.metrics.PF_SELECTED_UNIQUE_PAIRS;
                }
            }
            if (rec.getDuplicateReadFlag()) {
                return;
            }
            ++this.metrics.PF_UNIQUE_READS;
            if (rec.getReadUnmappedFlag() || rec.getMappingQuality() == 0) {
                return;
            }
            ++this.metrics.PF_UQ_READS_ALIGNED;
            for (AlignmentBlock block : rec.getAlignmentBlocks()) {
                this.metrics.PF_UQ_BASES_ALIGNED += (long)block.getLength();
            }
            boolean bl = mappedInPair = rec.getReadPairedFlag() && !rec.getMateUnmappedFlag();
            if (targets != null && !targets.isEmpty()) {
                for (Interval target : targets) {
                    Coverage coverage = this.coverageByTarget.get(target);
                    for (AlignmentBlock block : rec.getAlignmentBlocks()) {
                        int end = CoordMath.getEnd(block.getReferenceStart(), block.getLength());
                        for (int pos = block.getReferenceStart(); pos <= end; ++pos) {
                            if (pos < target.getStart() || pos > target.getEnd()) continue;
                            ++this.metrics.ON_TARGET_BASES;
                            if (mappedInPair) {
                                ++this.metrics.ON_TARGET_FROM_PAIR_BASES;
                            }
                            coverage.addBase(pos - target.getStart());
                        }
                    }
                }
            }
            int mappedBases = 0;
            for (AlignmentBlock block : rec.getAlignmentBlocks()) {
                mappedBases += block.getLength();
            }
            int onBaitBases = 0;
            if (probes != null && !probes.isEmpty()) {
                for (Interval bait : probes) {
                    for (AlignmentBlock block : rec.getAlignmentBlocks()) {
                        int end = CoordMath.getEnd(block.getReferenceStart(), block.getLength());
                        for (int pos = block.getReferenceStart(); pos <= end; ++pos) {
                            if (pos < bait.getStart() || pos > bait.getEnd()) continue;
                            ++onBaitBases;
                        }
                    }
                }
                this.metrics.ON_PROBE_BASES += (long)onBaitBases;
                this.metrics.NEAR_PROBE_BASES += (long)(mappedBases - onBaitBases);
            } else {
                this.metrics.OFF_PROBE_BASES += (long)mappedBases;
            }
        }

        @Override
        public void finish() {
            this.metrics.PCT_PF_READS = (double)this.metrics.PF_READS / (double)this.metrics.TOTAL_READS;
            this.metrics.PCT_PF_UQ_READS = (double)this.metrics.PF_UNIQUE_READS / (double)this.metrics.TOTAL_READS;
            this.metrics.PCT_PF_UQ_READS_ALIGNED = (double)this.metrics.PF_UQ_READS_ALIGNED / (double)this.metrics.PF_UNIQUE_READS;
            double denominator = this.metrics.ON_PROBE_BASES + this.metrics.NEAR_PROBE_BASES + this.metrics.OFF_PROBE_BASES;
            this.metrics.PCT_SELECTED_BASES = (double)(this.metrics.ON_PROBE_BASES + this.metrics.NEAR_PROBE_BASES) / denominator;
            this.metrics.PCT_OFF_PROBE = (double)this.metrics.OFF_PROBE_BASES / denominator;
            this.metrics.ON_PROBE_VS_SELECTED = (double)this.metrics.ON_PROBE_BASES / (double)(this.metrics.ON_PROBE_BASES + this.metrics.NEAR_PROBE_BASES);
            this.metrics.MEAN_PROBE_COVERAGE = (double)this.metrics.ON_PROBE_BASES / (double)this.metrics.PROBE_TERRITORY;
            this.metrics.FOLD_ENRICHMENT = (double)this.metrics.ON_PROBE_BASES / denominator / ((double)this.metrics.PROBE_TERRITORY / (double)this.metrics.GENOME_SIZE);
            this.calculateTargetCoverageMetrics();
            this.calculateGcMetrics();
        }

        private void calculateTargetCoverageMetrics() {
            short[] depths = new short[(int)this.metrics.TARGET_TERRITORY];
            int zeroCoverageTargets = 0;
            int depthIndex = 0;
            double totalCoverage = 0.0;
            int basesConsidered = 0;
            for (Coverage c : this.coverageByTarget.values()) {
                if (!c.hasCoverage()) {
                    ++zeroCoverageTargets;
                    continue;
                }
                short[] targetDepths = c.getDepths();
                basesConsidered += targetDepths.length;
                for (short depth : targetDepths) {
                    depths[depthIndex++] = depth;
                    totalCoverage += (double)depth;
                }
            }
            this.metrics.MEAN_TARGET_COVERAGE = totalCoverage / (double)basesConsidered;
            Arrays.sort(depths);
            int indexOf80thPercentile = Math.max(depths.length - 1 - basesConsidered + (int)((double)basesConsidered * 0.2), 0);
            short coverageAt80thPercentile = depths[indexOf80thPercentile];
            this.metrics.FOLD_80_BASE_PENALTY = this.metrics.MEAN_TARGET_COVERAGE / (double)coverageAt80thPercentile;
            this.metrics.ZERO_CVG_TARGETS_PCT = (double)zeroCoverageTargets / (double)TargetMetricsCollector.this.allTargets.getIntervals().size();
            int totalTargetBases = 0;
            int targetBases2x = 0;
            int targetBases10x = 0;
            int targetBases20x = 0;
            int targetBases30x = 0;
            int targetBases40x = 0;
            int targetBases50x = 0;
            int targetBases100x = 0;
            for (Coverage c : this.coverageByTarget.values()) {
                for (short depth : c.getDepths()) {
                    ++totalTargetBases;
                    if (depth < 2) continue;
                    ++targetBases2x;
                    if (depth < 10) continue;
                    ++targetBases10x;
                    if (depth < 20) continue;
                    ++targetBases20x;
                    if (depth < 30) continue;
                    ++targetBases30x;
                    if (depth < 40) continue;
                    ++targetBases40x;
                    if (depth < 50) continue;
                    ++targetBases50x;
                    if (depth < 100) continue;
                    ++targetBases100x;
                }
            }
            this.metrics.PCT_TARGET_BASES_2X = (double)targetBases2x / (double)totalTargetBases;
            this.metrics.PCT_TARGET_BASES_10X = (double)targetBases10x / (double)totalTargetBases;
            this.metrics.PCT_TARGET_BASES_20X = (double)targetBases20x / (double)totalTargetBases;
            this.metrics.PCT_TARGET_BASES_30X = (double)targetBases30x / (double)totalTargetBases;
            this.metrics.PCT_TARGET_BASES_40X = (double)targetBases40x / (double)totalTargetBases;
            this.metrics.PCT_TARGET_BASES_50X = (double)targetBases50x / (double)totalTargetBases;
            this.metrics.PCT_TARGET_BASES_100X = (double)targetBases100x / (double)totalTargetBases;
        }

        private void calculateGcMetrics() {
            if (this.intervalToGc != null) {
                int i;
                PrintWriter out;
                log.info("Calculating GC metrics");
                FormatUtil fmt = new FormatUtil();
                try {
                    if (this.perTargetOutput != null) {
                        out = new PrintWriter(this.perTargetOutput);
                        out.println("chrom\tstart\tend\tlength\tname\t%gc\tmean_coverage\tnormalized_coverage");
                    } else {
                        out = null;
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeIOException(ioe);
                }
                int bins = 101;
                long[] targetBasesByGc = new long[101];
                long[] alignedBasesByGc = new long[101];
                for (Map.Entry<Interval, Coverage> entry : this.coverageByTarget.entrySet()) {
                    int gc;
                    Interval interval = entry.getKey();
                    Coverage cov = entry.getValue();
                    double gcDouble = this.intervalToGc.get(interval);
                    int n = gc = (int)Math.round(gcDouble * 100.0);
                    targetBasesByGc[n] = targetBasesByGc[n] + (long)interval.length();
                    int n2 = gc;
                    alignedBasesByGc[n2] = alignedBasesByGc[n2] + (long)cov.getTotal();
                    if (out == null) continue;
                    double coverage = (double)cov.getTotal() / (double)interval.length();
                    out.println(interval.getSequence() + "\t" + interval.getStart() + "\t" + interval.getEnd() + "\t" + interval.length() + "\t" + interval.getName() + "\t" + fmt.format(gcDouble) + "\t" + fmt.format(coverage) + "\t" + fmt.format(coverage / this.metrics.MEAN_TARGET_COVERAGE));
                }
                if (out != null) {
                    out.close();
                }
                long totalTarget = 0L;
                long totalBases = 0L;
                for (i = 0; i < targetBasesByGc.length; ++i) {
                    totalTarget += targetBasesByGc[i];
                    totalBases += alignedBasesByGc[i];
                }
                for (i = 0; i < targetBasesByGc.length; ++i) {
                    double alignedPct = (double)alignedBasesByGc[i] / (double)totalBases;
                    double targetPct = (double)targetBasesByGc[i] / (double)totalTarget;
                    double dropout = (alignedPct - targetPct) * 100.0;
                    if (!(dropout < 0.0)) continue;
                    dropout = Math.abs(dropout);
                    if (i <= 50) {
                        this.metrics.AT_DROPOUT += dropout;
                    }
                    if (i < 50) continue;
                    this.metrics.GC_DROPOUT += dropout;
                }
            }
        }

        @Override
        public void addMetricsToFile(MetricsFile<METRIC_TYPE, Integer> hsMetricsComparableMetricsFile) {
            hsMetricsComparableMetricsFile.addMetric(TargetMetricsCollector.this.convertMetric(this.metrics));
        }
    }
}

