/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.color.ColorPalette;
import org.broad.igv.ui.color.ColorUtilities;

public class ColorPanel
extends JPanel
implements Serializable {
    Map<String, ColorPalette> paletteMap;
    List<Palette> paletteList = new ArrayList<Palette>();
    boolean showGrayScale = false;

    public ColorPanel() {
        this.setBackground(Color.white);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                for (Palette p : ColorPanel.this.paletteList) {
                    if (!p.bounds.contains(mouseEvent.getPoint())) continue;
                    for (Swatch s : p.swatches) {
                        Color c;
                        Color newColor;
                        if (!s.bounds.contains(mouseEvent.getPoint()) || (newColor = JColorChooser.showDialog(ColorPanel.this, "Choose new color", c = s.color)) == null) continue;
                        s.color = newColor;
                        ColorPanel.this.repaint(s.bounds);
                    }
                }
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (PreferencesManager.getPreferences().getAsBoolean("ENABLE_ANTIALIASING")) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        for (Palette palette : this.paletteList) {
            g.setColor(Color.black);
            g.drawString(palette.label, palette.x, palette.y);
            for (Swatch swatch : palette.swatches) {
                g.setColor(swatch.color);
                g.fillRect(swatch.bounds.x, swatch.bounds.y, swatch.bounds.width, swatch.bounds.height);
                if (!this.showGrayScale) continue;
                Color gs = ColorUtilities.adjustHSB(swatch.color, 1.0f, 0.0f, 1.0f);
                g.setColor(gs);
                g.fillRect(swatch.bounds.x, swatch.bounds.y, swatch.bounds.width, swatch.bounds.height);
            }
        }
    }

    @Override
    public void doLayout() {
        if (this.paletteMap == null) {
            try {
                this.paletteMap = ColorUtilities.loadPalettes();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int x = 0;
        int ybase = 30;
        this.paletteList.clear();
        int dx = this.showGrayScale ? 35 : 65;
        for (Map.Entry<String, ColorPalette> entry : this.paletteMap.entrySet()) {
            int y = ybase;
            int px0 = x += dx;
            int py0 = y;
            int pw = 35;
            Palette palette = new Palette(entry.getKey(), x, y);
            this.paletteList.add(palette);
            y += 10;
            for (Color c : entry.getValue().getColors()) {
                Rectangle r = new Rectangle(x, y += 20, 18, 18);
                palette.swatches.add(new Swatch(r, c));
            }
            int ph = y - ybase;
            palette.setBounds(new Rectangle(px0, py0, pw, ph));
            if (x <= this.getWidth() - 2 * dx) continue;
            x = 0;
            ybase = 250;
        }
    }

    static class Swatch {
        Color color;
        Rectangle bounds;

        Swatch(Rectangle bounds, Color color) {
            this.bounds = bounds;
            this.color = color;
        }
    }

    static class Palette {
        int x;
        int y;
        String label;
        List<Swatch> swatches;
        Rectangle bounds;

        Palette(String label, int x, int y) {
            this.label = label;
            this.x = x;
            this.y = y;
            this.swatches = new ArrayList<Swatch>();
        }

        public void setBounds(Rectangle bounds) {
            this.bounds = bounds;
        }
    }
}

