/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.vcf.GenotypeConcordanceStates;

public class GenotypeConcordanceScheme {
    protected final Map<GenotypeConcordanceStates.TruthAndCallStates, GenotypeConcordanceStates.ContingencyState[]> scheme = new HashMap<GenotypeConcordanceStates.TruthAndCallStates, GenotypeConcordanceStates.ContingencyState[]>();
    public static final GenotypeConcordanceStates.ContingencyState[] NA = new GenotypeConcordanceStates.ContingencyState[]{GenotypeConcordanceStates.ContingencyState.NA};
    protected static final GenotypeConcordanceStates.ContingencyState[] EMPTY = new GenotypeConcordanceStates.ContingencyState[]{GenotypeConcordanceStates.ContingencyState.EMPTY};
    protected static final GenotypeConcordanceStates.ContingencyState[] TP_ONLY = new GenotypeConcordanceStates.ContingencyState[]{GenotypeConcordanceStates.ContingencyState.TP};
    protected static final GenotypeConcordanceStates.ContingencyState[] FP_ONLY = new GenotypeConcordanceStates.ContingencyState[]{GenotypeConcordanceStates.ContingencyState.FP};
    protected static final GenotypeConcordanceStates.ContingencyState[] TN_ONLY = new GenotypeConcordanceStates.ContingencyState[]{GenotypeConcordanceStates.ContingencyState.TN};
    protected static final GenotypeConcordanceStates.ContingencyState[] FN_ONLY = new GenotypeConcordanceStates.ContingencyState[]{GenotypeConcordanceStates.ContingencyState.FN};
    protected static final GenotypeConcordanceStates.ContingencyState[] TP_FN = new GenotypeConcordanceStates.ContingencyState[]{GenotypeConcordanceStates.ContingencyState.TP, GenotypeConcordanceStates.ContingencyState.FN};
    protected static final GenotypeConcordanceStates.ContingencyState[] TP_FP = new GenotypeConcordanceStates.ContingencyState[]{GenotypeConcordanceStates.ContingencyState.TP, GenotypeConcordanceStates.ContingencyState.FP};
    protected static final GenotypeConcordanceStates.ContingencyState[] TP_TN = new GenotypeConcordanceStates.ContingencyState[]{GenotypeConcordanceStates.ContingencyState.TP, GenotypeConcordanceStates.ContingencyState.TN};
    protected static final GenotypeConcordanceStates.ContingencyState[] FP_FN = new GenotypeConcordanceStates.ContingencyState[]{GenotypeConcordanceStates.ContingencyState.FP, GenotypeConcordanceStates.ContingencyState.FN};
    protected static final GenotypeConcordanceStates.ContingencyState[] FP_TN = new GenotypeConcordanceStates.ContingencyState[]{GenotypeConcordanceStates.ContingencyState.FP, GenotypeConcordanceStates.ContingencyState.TN};
    protected static final GenotypeConcordanceStates.ContingencyState[] FP_TN_FN = new GenotypeConcordanceStates.ContingencyState[]{GenotypeConcordanceStates.ContingencyState.FP, GenotypeConcordanceStates.ContingencyState.TN, GenotypeConcordanceStates.ContingencyState.FN};
    protected static final GenotypeConcordanceStates.ContingencyState[] TP_FP_FN = new GenotypeConcordanceStates.ContingencyState[]{GenotypeConcordanceStates.ContingencyState.TP, GenotypeConcordanceStates.ContingencyState.FP, GenotypeConcordanceStates.ContingencyState.FN};
    protected static final GenotypeConcordanceStates.ContingencyState[] TN_FN = new GenotypeConcordanceStates.ContingencyState[]{GenotypeConcordanceStates.ContingencyState.TN, GenotypeConcordanceStates.ContingencyState.FN};
    private boolean isValidated = false;

    protected void addRow(GenotypeConcordanceStates.CallState callState, GenotypeConcordanceStates.ContingencyState[] ... concordanceStateArrays) {
        if (concordanceStateArrays.length != GenotypeConcordanceStates.TruthState.values().length) {
            throw new PicardException("Length mismatch between concordanceStateArrays and TruthState.values()");
        }
        for (int i = 0; i < concordanceStateArrays.length; ++i) {
            this.scheme.put(new GenotypeConcordanceStates.TruthAndCallStates(GenotypeConcordanceStates.TruthState.values()[i], callState), concordanceStateArrays[i]);
        }
    }

    public GenotypeConcordanceScheme() {
        this.addRow(GenotypeConcordanceStates.CallState.MISSING, NA, TN_ONLY, TN_FN, FN_ONLY, FN_ONLY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY);
        this.addRow(GenotypeConcordanceStates.CallState.HOM_REF, TN_ONLY, TN_ONLY, TN_FN, FN_ONLY, FN_ONLY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY);
        this.addRow(GenotypeConcordanceStates.CallState.HET_REF_VAR1, FP_TN, FP_TN, TP_TN, TP_FN, TP_FN, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY);
        this.addRow(GenotypeConcordanceStates.CallState.HET_REF_VAR2, NA, NA, FP_TN_FN, NA, FP_FN, NA, NA, NA, NA, NA, NA);
        this.addRow(GenotypeConcordanceStates.CallState.HET_REF_VAR3, NA, NA, NA, FP_FN, NA, NA, NA, NA, NA, NA, NA);
        this.addRow(GenotypeConcordanceStates.CallState.HET_VAR1_VAR2, FP_ONLY, FP_ONLY, TP_FP, TP_ONLY, TP_FP_FN, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY);
        this.addRow(GenotypeConcordanceStates.CallState.HET_VAR1_VAR3, NA, NA, NA, TP_FP_FN, NA, NA, NA, NA, NA, NA, NA);
        this.addRow(GenotypeConcordanceStates.CallState.HET_VAR3_VAR4, FP_ONLY, FP_ONLY, FP_FN, FP_FN, FP_FN, NA, NA, NA, NA, NA, NA);
        this.addRow(GenotypeConcordanceStates.CallState.HOM_VAR1, FP_ONLY, FP_ONLY, TP_FP, TP_FN, TP_ONLY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY);
        this.addRow(GenotypeConcordanceStates.CallState.HOM_VAR2, NA, NA, FP_FN, TP_FN, FP_FN, NA, NA, NA, NA, NA, NA);
        this.addRow(GenotypeConcordanceStates.CallState.HOM_VAR3, NA, NA, NA, FP_FN, NA, NA, NA, NA, NA, NA, NA);
        this.addRow(GenotypeConcordanceStates.CallState.NO_CALL, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY);
        this.addRow(GenotypeConcordanceStates.CallState.VC_FILTERED, EMPTY, TN_ONLY, TN_FN, FN_ONLY, FN_ONLY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY);
        this.addRow(GenotypeConcordanceStates.CallState.GT_FILTERED, EMPTY, TN_ONLY, TN_FN, FN_ONLY, FN_ONLY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY);
        this.addRow(GenotypeConcordanceStates.CallState.LOW_GQ, EMPTY, TN_ONLY, TN_FN, FN_ONLY, FN_ONLY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY);
        this.addRow(GenotypeConcordanceStates.CallState.LOW_DP, EMPTY, TN_ONLY, TN_FN, FN_ONLY, FN_ONLY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY);
        this.addRow(GenotypeConcordanceStates.CallState.IS_MIXED, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY);
        this.validateScheme();
    }

    public GenotypeConcordanceStates.ContingencyState[] getConcordanceStateArray(GenotypeConcordanceStates.TruthState truthState, GenotypeConcordanceStates.CallState callState) {
        return this.getConcordanceStateArray(new GenotypeConcordanceStates.TruthAndCallStates(truthState, callState));
    }

    public GenotypeConcordanceStates.ContingencyState[] getConcordanceStateArray(GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates) {
        return this.scheme.get(truthAndCallStates);
    }

    public String getContingencyStateString(GenotypeConcordanceStates.TruthState truthState, GenotypeConcordanceStates.CallState callState) {
        GenotypeConcordanceStates.ContingencyState[] contingencyStateArray = this.getConcordanceStateArray(truthState, callState);
        return contingencyStateArray.length == 0 ? "EMPTY" : StringUtil.join(",", contingencyStateArray);
    }

    public Set<GenotypeConcordanceStates.ContingencyState> getContingencyStateSet(GenotypeConcordanceStates.ContingencyState[] contingencyStateArray) {
        HashSet<GenotypeConcordanceStates.ContingencyState> contingencyStateSet = new HashSet<GenotypeConcordanceStates.ContingencyState>();
        Collections.addAll(contingencyStateSet, contingencyStateArray);
        return contingencyStateSet;
    }

    public void validateScheme() throws PicardException {
        if (!this.isValidated) {
            for (GenotypeConcordanceStates.TruthState truthState : GenotypeConcordanceStates.TruthState.values()) {
                for (GenotypeConcordanceStates.CallState callState : GenotypeConcordanceStates.CallState.values()) {
                    if (this.scheme.containsKey(new GenotypeConcordanceStates.TruthAndCallStates(truthState, callState))) continue;
                    throw new PicardException(String.format("Missing scheme tuple: [%s, %s]", truthState.name(), callState.name()));
                }
            }
        }
        this.isValidated = true;
    }
}

