/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.broad.igv.event.DataLoadedEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.feature.PSLRecord;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.tribble.PSLCodec;
import org.broad.igv.renderer.IGVFeatureRenderer;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.blat.BlatClient;
import org.broad.igv.util.blat.BlatQueryWindow;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BlatTrack
extends FeatureTrack {
    private static Logger log = Logger.getLogger(BlatTrack.class);
    String species;
    String db;
    String sequence;
    Genome genome;
    List<PSLRecord> features;

    public BlatTrack(String species, String sequence, String db, Genome genome) {
        super(sequence, "Blat");
        this.sequence = sequence;
        this.db = db;
        this.species = species;
        this.genome = genome;
        this.setDisplayMode(Track.DisplayMode.SQUISHED);
        this.init();
    }

    public BlatTrack() {
        this.genome = GenomeManager.getInstance().getCurrentGenome();
    }

    private void init() {
        this.setUseScore(true);
        try {
            List<String> tokensList = BlatClient.blat(this.species, this.db, this.sequence);
            PSLCodec codec = new PSLCodec(this.genome, true);
            this.features = new ArrayList<PSLRecord>(tokensList.size());
            for (String tokens : tokensList) {
                PSLRecord f = codec.decode(tokens);
                if (f == null) continue;
                this.features.add(f);
            }
            if (this.features.isEmpty()) {
                MessageUtils.showMessage("No features found");
            }
            this.source = new FeatureCollectionSource(this.features, this.genome);
            this.renderer = new IGVFeatureRenderer();
        }
        catch (IOException e) {
            log.error("Error blatting sequence", e);
            MessageUtils.showErrorMessage("Error blatting sequence", e);
        }
        IGVEventBus.getInstance().subscribe(DataLoadedEvent.class, this);
    }

    private void openTableView() {
        BlatQueryWindow win = new BlatQueryWindow(IGV.getMainFrame(), this.sequence, this.features);
        win.setVisible(true);
    }

    public List<PSLRecord> getFeatures() {
        return this.features;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu menu = TrackMenuUtils.getPopupMenu(Arrays.asList(this), "Menu", te);
        JMenuItem item = new JMenuItem("Open table view");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BlatTrack.this.openTableView();
            }
        });
        menu.addSeparator();
        menu.add(item);
        return menu;
    }

    @Override
    public void marshalXML(Document document, Element element) {
        super.marshalXML(document, element);
        element.setAttribute("db", this.db);
        element.setAttribute("sequence", this.sequence);
        element.setAttribute("species", this.species);
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        super.unmarshalXML(element, version);
        this.sequence = element.getAttribute("sequence");
        this.species = element.getAttribute("species");
        this.db = element.getAttribute("db");
        this.genome = GenomeManager.getInstance().getCurrentGenome();
        this.init();
    }
}

