/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SamFlagField;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.security.AccessControlException;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;

public class Defaults {
    private static final Log log = Log.getInstance(Defaults.class);
    public static final boolean CREATE_INDEX = Defaults.getBooleanProperty("create_index", false);
    public static final boolean CREATE_MD5 = Defaults.getBooleanProperty("create_md5", false);
    public static final boolean USE_ASYNC_IO_READ_FOR_SAMTOOLS = Defaults.getBooleanProperty("use_async_io_read_samtools", false);
    public static final boolean USE_ASYNC_IO_WRITE_FOR_SAMTOOLS = Defaults.getBooleanProperty("use_async_io_write_samtools", false);
    public static final boolean USE_ASYNC_IO_WRITE_FOR_TRIBBLE = Defaults.getBooleanProperty("use_async_io_write_tribble", false);
    public static final int COMPRESSION_LEVEL = Defaults.getIntProperty("compression_level", 5);
    public static final int BUFFER_SIZE = Defaults.getIntProperty("buffer_size", 131072);
    public static final SamFlagField SAM_FLAG_FIELD_FORMAT;
    public static final int NON_ZERO_BUFFER_SIZE;
    public static final File REFERENCE_FASTA;
    public static final String CUSTOM_READER_FACTORY;
    public static final boolean USE_CRAM_REF_DOWNLOAD;
    public static final String EBI_REFERENCE_SERVICE_URL_MASK;
    public static final boolean SRA_LIBRARIES_DOWNLOAD;
    public static final String DISABLE_SNAPPY_PROPERTY_NAME = "snappy.disable";
    public static final boolean DISABLE_SNAPPY_COMPRESSOR;

    public static SortedMap<String, Object> allDefaults() {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        result.put("CREATE_INDEX", CREATE_INDEX);
        result.put("CREATE_MD5", CREATE_MD5);
        result.put("USE_ASYNC_IO_READ_FOR_SAMTOOLS", USE_ASYNC_IO_READ_FOR_SAMTOOLS);
        result.put("USE_ASYNC_IO_WRITE_FOR_SAMTOOLS", USE_ASYNC_IO_WRITE_FOR_SAMTOOLS);
        result.put("USE_ASYNC_IO_WRITE_FOR_TRIBBLE", USE_ASYNC_IO_WRITE_FOR_TRIBBLE);
        result.put("COMPRESSION_LEVEL", COMPRESSION_LEVEL);
        result.put("BUFFER_SIZE", BUFFER_SIZE);
        result.put("NON_ZERO_BUFFER_SIZE", NON_ZERO_BUFFER_SIZE);
        result.put("REFERENCE_FASTA", REFERENCE_FASTA);
        result.put("USE_CRAM_REF_DOWNLOAD", USE_CRAM_REF_DOWNLOAD);
        result.put("EBI_REFERENCE_SERVICE_URL_MASK", EBI_REFERENCE_SERVICE_URL_MASK);
        result.put("CUSTOM_READER_FACTORY", CUSTOM_READER_FACTORY);
        result.put("SAM_FLAG_FIELD_FORMAT", (Object)SAM_FLAG_FIELD_FORMAT);
        result.put("DISABLE_SNAPPY_COMPRESSOR", DISABLE_SNAPPY_COMPRESSOR);
        return Collections.unmodifiableSortedMap(result);
    }

    private static String getStringProperty(String name, String def) {
        try {
            return System.getProperty("samjdk." + name, def);
        }
        catch (AccessControlException error) {
            log.warn(error, "java Security Manager forbids 'System.getProperty(\"" + name + "\")' , returning default value: " + def);
            return def;
        }
    }

    private static boolean hasProperty(String name) {
        try {
            return null != System.getProperty("samjdk." + name);
        }
        catch (AccessControlException error) {
            log.warn(error, "java Security Manager forbids 'System.getProperty(\"" + name + "\")' , returning false");
            return false;
        }
    }

    private static boolean getBooleanProperty(String name, boolean def) {
        String value = Defaults.getStringProperty(name, Boolean.toString(def));
        return Boolean.parseBoolean(value);
    }

    private static int getIntProperty(String name, int def) {
        String value = Defaults.getStringProperty(name, Integer.toString(def));
        return Integer.parseInt(value);
    }

    private static File getFileProperty(String name, String def) {
        String value = Defaults.getStringProperty(name, def);
        return null == value ? null : new File(value);
    }

    static {
        NON_ZERO_BUFFER_SIZE = BUFFER_SIZE == 0 ? 131072 : BUFFER_SIZE;
        REFERENCE_FASTA = Defaults.getFileProperty("reference_fasta", null);
        USE_CRAM_REF_DOWNLOAD = Defaults.getBooleanProperty("use_cram_ref_download", false);
        EBI_REFERENCE_SERVICE_URL_MASK = "https://www.ebi.ac.uk/ena/cram/md5/%s";
        CUSTOM_READER_FACTORY = Defaults.getStringProperty("custom_reader", "");
        SAM_FLAG_FIELD_FORMAT = SamFlagField.valueOf(Defaults.getStringProperty("sam_flag_field_format", SamFlagField.DECIMAL.name()));
        SRA_LIBRARIES_DOWNLOAD = Defaults.getBooleanProperty("sra_libraries_download", false);
        DISABLE_SNAPPY_COMPRESSOR = Defaults.getBooleanProperty(DISABLE_SNAPPY_PROPERTY_NAME, false);
    }
}

