/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.color.ColorChooserPanel;
import org.jdesktop.layout.GroupLayout;

public class HeatmapScaleDialog
extends JDialog {
    boolean canceled = false;
    ContinuousColorScale colorScale;
    private JPanel jPanel2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField minField;
    private JTextField maxField;
    private JTextField neutralFromField;
    private JTextField neutralToField;
    private ColorChooserPanel negColor;
    private ColorChooserPanel posColor;
    private ColorChooserPanel midColor;
    private JPanel legendPanel;
    private JPanel panel3;
    private JPanel jPanel3;
    private JButton cancelButton;
    private JButton okButton1;
    private JLabel label1;

    public HeatmapScaleDialog(Frame parent, ContinuousColorScale colorScale) {
        super(parent, true);
        this.colorScale = new ContinuousColorScale(colorScale);
        this.initComponents();
        this.minField.setText(String.valueOf(colorScale.getMinimum()));
        this.maxField.setText(String.valueOf(colorScale.getMaximum()));
        this.neutralFromField.setText(String.valueOf(colorScale.getNegStart()));
        this.neutralToField.setText(String.valueOf(colorScale.getPosStart()));
        this.negColor.setSelectedColor(colorScale.getMinColor());
        this.posColor.setSelectedColor(colorScale.getMaxColor());
        this.midColor.setSelectedColor(colorScale.getMidColor());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public ContinuousColorScale getColorScale() {
        return this.colorScale;
    }

    private void initComponents() {
        Rectangle bounds;
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.minField = new JTextField();
        this.maxField = new JTextField();
        this.neutralFromField = new JTextField();
        this.neutralToField = new JTextField();
        this.negColor = new ColorChooserPanel();
        this.posColor = new ColorChooserPanel();
        this.midColor = new ColorChooserPanel();
        this.legendPanel = new LegendPanel();
        this.panel3 = new JPanel();
        this.jPanel3 = new JPanel();
        this.cancelButton = new JButton();
        this.okButton1 = new JButton();
        this.label1 = new JLabel();
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(null);
        this.jPanel2.setBorder(null);
        this.jLabel1.setText("Minimum");
        this.jLabel2.setText("Maximum");
        this.jLabel3.setText("Midrange");
        this.jLabel4.setText("to");
        this.minField.setText("jTextField1");
        this.minField.setPreferredSize(new Dimension(120, 28));
        this.minField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                HeatmapScaleDialog.this.minFieldFocusLost(e);
            }
        });
        this.maxField.setText("jTextField2");
        this.maxField.setPreferredSize(new Dimension(120, 28));
        this.maxField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                HeatmapScaleDialog.this.maxFieldFocusLost(e);
            }
        });
        this.neutralFromField.setText("jTextField3");
        this.neutralFromField.setPreferredSize(new Dimension(120, 28));
        this.neutralFromField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                HeatmapScaleDialog.this.neutralFromFieldFocusLost(e);
            }
        });
        this.neutralToField.setText("jTextField4");
        this.neutralToField.setPreferredSize(new Dimension(120, 28));
        this.neutralToField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                HeatmapScaleDialog.this.neutralToFieldFocusLost(e);
            }
        });
        this.negColor.setPreferredSize(new Dimension(60, 28));
        this.negColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatmapScaleDialog.this.setNegColorAction(e);
            }
        });
        this.posColor.setPreferredSize(new Dimension(60, 28));
        this.posColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatmapScaleDialog.this.posColorActionPerformed(e);
            }
        });
        this.midColor.setPreferredSize(new Dimension(60, 28));
        this.midColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatmapScaleDialog.this.midColorActionPerformed(e);
            }
        });
        this.legendPanel.setBackground(new Color(238, 238, 238));
        this.legendPanel.setOpaque(false);
        GroupLayout legendPanelLayout = new GroupLayout(this.legendPanel);
        this.legendPanel.setLayout(legendPanelLayout);
        legendPanelLayout.setHorizontalGroup(legendPanelLayout.createParallelGroup().add(0, 443, Short.MAX_VALUE));
        legendPanelLayout.setVerticalGroup(legendPanelLayout.createParallelGroup().add(0, 54, Short.MAX_VALUE));
        this.panel3.setLayout(null);
        Dimension preferredSize = new Dimension();
        for (int i = 0; i < this.panel3.getComponentCount(); ++i) {
            bounds = this.panel3.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.panel3.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel3.setMinimumSize(preferredSize);
        this.panel3.setPreferredSize(preferredSize);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup().add(jPanel2Layout.createSequentialGroup().add(this.panel3, -2, 26, -2).add(6, 6, 6).add(jPanel2Layout.createParallelGroup().add(this.negColor, -2, -1, -2).add(this.posColor, -2, -1, -2).add(this.midColor, -2, -1, -2)).add(6, 6, 6).add(jPanel2Layout.createParallelGroup().add(this.jLabel1, -2, 62, -2).add(this.jLabel2).add(this.jLabel3, -2, 62, -2)).add(6, 6, 6).add(jPanel2Layout.createParallelGroup().add(this.minField, -2, -1, -2).add(this.maxField, -2, -1, -2).add(this.neutralFromField, -2, -1, -2)).add(6, 6, 6).add(this.jLabel4).add(6, 6, 6).add(this.neutralToField, -2, -1, -2)).add(2, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(this.legendPanel, -2, -1, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup().add(jPanel2Layout.createSequentialGroup().add(jPanel2Layout.createParallelGroup().add(this.panel3, -2, 94, -2).add(jPanel2Layout.createSequentialGroup().add(this.negColor, -2, -1, -2).add(5, 5, 5).add(this.posColor, -2, -1, -2).add(5, 5, 5).add(this.midColor, -2, -1, -2)).add(jPanel2Layout.createSequentialGroup().add(this.jLabel1, -2, 28, -2).add(5, 5, 5).add(this.jLabel2, -2, 28, -2).add(5, 5, 5).add(this.jLabel3, -2, 28, -2)).add(jPanel2Layout.createSequentialGroup().add(this.minField, -2, -1, -2).add(5, 5, 5).add(this.maxField, -2, -1, -2).add(5, 5, 5).add(this.neutralFromField, -2, -1, -2)).add(jPanel2Layout.createSequentialGroup().add(66, 66, 66).add(this.jLabel4, -2, 28, -2)).add(jPanel2Layout.createSequentialGroup().add(66, 66, 66).add(this.neutralToField, -2, -1, -2))).add(41, 41, 41).add(this.legendPanel, -2, -1, -2).add(41, 41, 41)));
        contentPane.add(this.jPanel2);
        this.jPanel2.setBounds(10, 70, 465, 230);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatmapScaleDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.okButton1.setText("OK");
        this.okButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatmapScaleDialog.this.okButton1ActionPerformed(e);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup().add(2, jPanel3Layout.createSequentialGroup().addContainerGap(291, Short.MAX_VALUE).add(this.cancelButton).addPreferredGap(0).add(this.okButton1).add(12, 12, 12)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup().add(2, jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(jPanel3Layout.createParallelGroup(3).add(this.okButton1).add(this.cancelButton)).add(8, 8, 8)));
        contentPane.add(this.jPanel3);
        this.jPanel3.setBounds(10, 295, 470, this.jPanel3.getPreferredSize().height);
        this.label1.setText("Heatmap settings for selected tracks");
        contentPane.add(this.label1);
        this.label1.setBounds(40, 10, 345, this.label1.getPreferredSize().height);
        preferredSize = new Dimension();
        for (int i = 0; i < contentPane.getComponentCount(); ++i) {
            bounds = contentPane.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = contentPane.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        contentPane.setMinimumSize(preferredSize);
        contentPane.setPreferredSize(preferredSize);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.setVisible(false);
    }

    private void okButton1ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void setNegColorAction(ActionEvent evt) {
        this.colorScale.setMinColor(this.negColor.getSelectedColor());
        this.legendPanel.repaint();
    }

    private void posColorActionPerformed(ActionEvent evt) {
        this.colorScale.setMaxColor(this.posColor.getSelectedColor());
        this.legendPanel.repaint();
    }

    private void midColorActionPerformed(ActionEvent evt) {
        this.colorScale.setMidColor(this.midColor.getSelectedColor());
        this.legendPanel.repaint();
    }

    private void minFieldFocusLost(FocusEvent evt) {
        this.minFieldActionPerformed(null);
    }

    private void maxFieldFocusLost(FocusEvent evt) {
        this.maxFieldActionPerformed(null);
    }

    private void neutralFromFieldFocusLost(FocusEvent evt) {
        this.neutralFromFieldActionPerformed(null);
    }

    private void neutralToFieldFocusLost(FocusEvent evt) {
        this.neutralToFieldActionPerformed(null);
    }

    private void minFieldActionPerformed(ActionEvent evt) {
        try {
            this.colorScale.setNegEnd(Double.parseDouble(this.minField.getText()));
            this.legendPanel.repaint();
        }
        catch (NumberFormatException e) {
            this.minField.setText(String.valueOf(this.colorScale.getMinimum()));
        }
    }

    private void maxFieldActionPerformed(ActionEvent evt) {
        try {
            this.colorScale.setPosEnd(Double.parseDouble(this.maxField.getText()));
            this.legendPanel.repaint();
        }
        catch (NumberFormatException e) {
            this.maxField.setText(String.valueOf(this.colorScale.getMaximum()));
        }
    }

    private void neutralFromFieldActionPerformed(ActionEvent evt) {
        try {
            this.colorScale.setNegStart(Double.parseDouble(this.neutralFromField.getText()));
            this.legendPanel.repaint();
        }
        catch (NumberFormatException e) {
            this.neutralFromField.setText(String.valueOf(this.colorScale.getNegStart()));
        }
    }

    private void neutralToFieldActionPerformed(ActionEvent evt) {
        try {
            this.colorScale.setPosStart(Double.parseDouble(this.neutralToField.getText()));
            this.legendPanel.repaint();
        }
        catch (NumberFormatException e) {
            this.neutralToField.setText(String.valueOf(this.colorScale.getPosStart()));
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame jFrame = new JFrame();
                PreferencesManager.getPreferences();
                HeatmapScaleDialog dialog = new HeatmapScaleDialog((Frame)jFrame, IGVPreferences.getDefaultColorScale(TrackType.COPY_NUMBER));
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    class LegendPanel
    extends JPanel {
        LegendPanel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (HeatmapScaleDialog.this.colorScale == null) {
                return;
            }
            DecimalFormat formatter = new DecimalFormat("0.0");
            Graphics2D g2D = null;
            try {
                g2D = (Graphics2D)g.create();
                if (PreferencesManager.getPreferences().getAsBoolean("ENABLE_ANTIALIASING")) {
                    g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
                g2D.setFont(FontManager.getFont(10));
                double max = HeatmapScaleDialog.this.colorScale.getMaximum();
                double min = HeatmapScaleDialog.this.colorScale.getMinimum();
                double neutralFrom = HeatmapScaleDialog.this.colorScale.getNegStart();
                double neutralTo = HeatmapScaleDialog.this.colorScale.getPosStart();
                int margin = 10;
                int w = this.getWidth() - 2 * margin;
                int h = this.getHeight() / 2;
                int npts = 50;
                double dx = (double)w / (double)npts;
                double delta = (max - min) / (double)(npts - 1);
                for (int i = 0; i < npts - 1; ++i) {
                    double val = min + (double)i * delta;
                    Color c = HeatmapScaleDialog.this.colorScale.getColor((float)val);
                    g2D.setColor(c);
                    int x0 = margin + (int)((double)i * dx);
                    int x1 = margin + (int)((double)(i + 1) * dx);
                    g2D.fillRect(x0, 0, x1 - x0, h);
                }
                double[] values = new double[]{min, neutralFrom, neutralTo, max};
                double wPrime = ((double)(w - 2 * margin) - dx) / (max - min);
                g2D.setColor(Color.BLACK);
                for (int i = 0; i < values.length; ++i) {
                    double val = values[i];
                    int x0 = (int)((double)margin + dx + (val - min) * wPrime);
                    g2D.fillRect(x0, 0, 2, h);
                    g2D.drawString(formatter.format(val), x0 - 10, h + 15);
                }
            }
            finally {
                g2D.dispose();
            }
        }
    }
}

