/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.feature.AminoAcidManager;
import org.broad.igv.feature.AminoAcidSequence;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.renderer.SequenceRenderer;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.LoadedDataInterval;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.UIUtilities;

public class SequenceTrack
extends AbstractTrack
implements IGVEventObserver {
    private static Logger log = Logger.getLogger(SequenceTrack.class);
    private static final int SEQUENCE_HEIGHT = 14;
    private static String NAME = "Sequence";
    private Map<String, LoadedDataInterval<SeqCache>> loadedIntervalCache = new HashMap<String, LoadedDataInterval<SeqCache>>(200);
    private Map<String, Boolean> sequenceVisible;
    private SequenceRenderer sequenceRenderer = new SequenceRenderer();
    private boolean shouldShowTranslation = true;
    Strand strand = Strand.POSITIVE;
    private Rectangle arrowRect;

    public SequenceTrack(String name) {
        super(name);
        this.setSortable(false);
        this.shouldShowTranslation = PreferencesManager.getPreferences().getAsBoolean("SHOW_SEQUENCE_TRANSLATION");
        this.loadedIntervalCache = Collections.synchronizedMap(new HashMap());
        this.sequenceVisible = Collections.synchronizedMap(new HashMap());
        IGVEventBus.getInstance().subscribe(FrameManager.ChangeEvent.class, this);
    }

    public SequenceTrack() {
    }

    public static String getReverseComplement(String sequence) {
        char[] complement = new char[sequence.length()];
        int jj = complement.length;
        block10: for (int ii = 0; ii < sequence.length(); ++ii) {
            char c = sequence.charAt(ii);
            --jj;
            switch (c) {
                case 'T': {
                    complement[jj] = 65;
                    continue block10;
                }
                case 'A': {
                    complement[jj] = 84;
                    continue block10;
                }
                case 'C': {
                    complement[jj] = 71;
                    continue block10;
                }
                case 'G': {
                    complement[jj] = 67;
                    continue block10;
                }
                case 't': {
                    complement[jj] = 97;
                    continue block10;
                }
                case 'a': {
                    complement[jj] = 116;
                    continue block10;
                }
                case 'c': {
                    complement[jj] = 103;
                    continue block10;
                }
                case 'g': {
                    complement[jj] = 99;
                    continue block10;
                }
                default: {
                    complement[jj] = c;
                }
            }
        }
        return new String(complement);
    }

    @Override
    public void receiveEvent(Object event) {
        if (event instanceof FrameManager.ChangeEvent) {
            List<ReferenceFrame> frames = ((FrameManager.ChangeEvent)event).getFrames();
            Map<String, LoadedDataInterval<SeqCache>> newCache = Collections.synchronizedMap(new HashMap());
            for (ReferenceFrame f : frames) {
                newCache.put(f.getName(), this.loadedIntervalCache.get(f.getName()));
            }
            this.loadedIntervalCache = newCache;
        } else {
            log.info("Unknown event type: " + event.getClass());
        }
    }

    @Override
    public void renderName(Graphics2D graphics, Rectangle trackRectangle, Rectangle visibleRectangle) {
        Font font = FontManager.getFont(this.fontSize);
        boolean visible = this.sequenceVisible.values().stream().anyMatch(v -> v == true);
        if (visible) {
            graphics.setFont(font);
            int textBaseline = trackRectangle.y + 12;
            graphics.drawString(NAME, trackRectangle.x + 5, textBaseline);
            int rx = trackRectangle.x + trackRectangle.width - 20;
            this.arrowRect = new Rectangle(rx, trackRectangle.y + 2, 15, 10);
            this.drawArrow(graphics);
            if (AminoAcidManager.getInstance().getCodonTable().getId() != 1) {
                Font labFont = font.deriveFont(1);
                graphics.setFont(labFont);
                graphics.drawString("A", rx - 20, textBaseline);
                graphics.setFont(font);
            }
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        }
    }

    private void drawArrow(Graphics2D graphics) {
        GraphicUtils.drawHorizontalArrow(graphics, this.arrowRect, this.strand == Strand.POSITIVE);
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        boolean visible;
        int resolutionThreshold = PreferencesManager.getPreferences().getAsInt("MAX_SEQUENCE_RESOLUTION");
        boolean bl = visible = frame.getScale() < (double)resolutionThreshold && !frame.getChrName().equals("All");
        if (!visible) {
            return true;
        }
        LoadedDataInterval<SeqCache> interval = this.loadedIntervalCache.get(frame.getName());
        return interval != null && interval.contains(frame);
    }

    @Override
    public void load(ReferenceFrame referenceFrame) {
        String sequence;
        String chr = referenceFrame.getChrName();
        Genome currentGenome = GenomeManager.getInstance().getCurrentGenome();
        Chromosome chromosome = currentGenome.getChromosome(chr);
        int start = (int)referenceFrame.getOrigin();
        int chromosomeLength = chromosome.getLength();
        int end = (int)referenceFrame.getEnd();
        int w = end - start;
        start = Math.max(0, start - w / 2 + 2);
        end = Math.min(end + w / 2 + 2, chromosomeLength);
        Genome genome = currentGenome;
        String s1 = sequence = new String(genome.getSequence(chr, start, end));
        String s2 = sequence.substring(1);
        String s3 = sequence.substring(2);
        String s4 = sequence;
        String s5 = sequence.substring(0, sequence.length() - 1);
        String s6 = sequence.substring(0, sequence.length() - 2);
        AminoAcidSequence aa1 = AminoAcidManager.getInstance().getAminoAcidSequence(Strand.POSITIVE, start, s1);
        AminoAcidSequence aa2 = AminoAcidManager.getInstance().getAminoAcidSequence(Strand.POSITIVE, start + 1, s2);
        AminoAcidSequence aa3 = AminoAcidManager.getInstance().getAminoAcidSequence(Strand.POSITIVE, start + 2, s3);
        AminoAcidSequence aa4 = AminoAcidManager.getInstance().getAminoAcidSequence(Strand.NEGATIVE, start, s4);
        AminoAcidSequence aa5 = AminoAcidManager.getInstance().getAminoAcidSequence(Strand.NEGATIVE, start, s5);
        AminoAcidSequence aa6 = AminoAcidManager.getInstance().getAminoAcidSequence(Strand.NEGATIVE, start, s6);
        int deltaStart = start == 0 ? 0 : 2;
        int deltaEnd = end == chromosomeLength ? 0 : 2;
        byte[] seq = sequence.substring(deltaStart, sequence.length() - deltaEnd).getBytes();
        SeqCache cache = new SeqCache(start += deltaStart, seq, aa1, aa2, aa3, aa4, aa5, aa6);
        this.loadedIntervalCache.put(referenceFrame.getName(), new LoadedDataInterval<SeqCache>(chr, start, end -= deltaEnd, cache));
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        LoadedDataInterval<SeqCache> sequenceInterval;
        int resolutionThreshold = PreferencesManager.getPreferences().getAsInt("MAX_SEQUENCE_RESOLUTION");
        boolean visible = context.getReferenceFrame().getScale() < (double)resolutionThreshold && !context.getChr().equals("All");
        String frameName = context.getReferenceFrame().getName();
        if (!this.sequenceVisible.containsKey(frameName)) {
            this.sequenceVisible.put(frameName, false);
        }
        if (visible != this.sequenceVisible.get(frameName)) {
            this.sequenceVisible.put(frameName, visible);
            UIUtilities.invokeAndWaitOnEventThread(() -> context.getPanel().revalidate());
        }
        if (visible && (sequenceInterval = this.loadedIntervalCache.get(frameName)) != null) {
            this.sequenceRenderer.setStrand(this.strand);
            this.sequenceRenderer.draw(sequenceInterval, context, rect, this.shouldShowTranslation, resolutionThreshold);
        }
    }

    @Override
    public int getHeight() {
        boolean visible = this.sequenceVisible.values().stream().anyMatch(v -> v == true);
        return visible ? 14 + (this.shouldShowTranslation ? 42 : 0) : 0;
    }

    @Override
    public boolean handleDataClick(TrackClickEvent e) {
        this.setShouldShowTranslation(!this.shouldShowTranslation);
        Object source = e.getMouseEvent().getSource();
        if (source instanceof JComponent) {
            UIUtilities.invokeOnEventThread(() -> this.repaint());
        }
        return true;
    }

    @Override
    public void handleNameClick(MouseEvent e) {
        if (this.arrowRect != null && this.arrowRect.contains(e.getPoint())) {
            this.flipStrand();
        }
    }

    private void flipStrand() {
        this.strand = this.strand == Strand.POSITIVE ? Strand.NEGATIVE : Strand.POSITIVE;
        IGV.getInstance().clearSelections();
        this.repaint();
    }

    public void setShouldShowTranslation(boolean shouldShowTranslation) {
        this.shouldShowTranslation = shouldShowTranslation;
        PreferencesManager.getPreferences().put("SHOW_SEQUENCE_TRANSLATION", shouldShowTranslation);
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu menu = new IGVPopupMenu();
        JMenuItem m1 = new JMenuItem("Flip strand");
        m1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceTrack.this.flipStrand();
            }
        });
        final JCheckBoxMenuItem m2 = new JCheckBoxMenuItem("Show translation");
        m2.setSelected(this.shouldShowTranslation);
        m2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceTrack.this.setShouldShowTranslation(m2.isSelected());
                SequenceTrack.this.repaint();
                IGV.getInstance().clearSelections();
            }
        });
        menu.add(m1);
        menu.add(m2);
        JMenu transTableMenu = new JMenu("Translation Table");
        for (AminoAcidManager.CodonTable codonTable : AminoAcidManager.getInstance().getAllCodonTables()) {
            JCheckBoxMenuItem item = this.getCodonTableMenuItem(codonTable);
            transTableMenu.add(item);
        }
        menu.add(transTableMenu);
        return menu;
    }

    private JCheckBoxMenuItem getCodonTableMenuItem(AminoAcidManager.CodonTable codonTable) {
        String fullName;
        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
        String shortName = fullName = codonTable.getDisplayName();
        if (fullName.length() > 40) {
            shortName = fullName.substring(0, 37) + "...";
            item.setToolTipText(fullName);
        }
        item.setText(shortName);
        final AminoAcidManager.CodonTableKey curKey = codonTable.getKey();
        item.setSelected(curKey.equals(AminoAcidManager.getInstance().getCodonTable().getKey()));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AminoAcidManager.getInstance().setCodonTable(curKey);
                SequenceTrack.this.repaint();
            }
        });
        return item;
    }

    private void repaint() {
        IGV.getMainFrame().repaint();
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    @Override
    public String getNameValueString(int y) {
        String nvs = "<html>" + super.getNameValueString(y);
        nvs = nvs + "<br>Translation Table: ";
        nvs = nvs + AminoAcidManager.getInstance().getCodonTable().getDisplayName();
        return nvs;
    }

    public Strand getStrand() {
        return this.strand;
    }

    public static class SeqCache {
        public int start;
        public byte[] seq;
        public AminoAcidSequence[] posAA;
        public AminoAcidSequence[] negAA;

        public SeqCache(int start, byte[] seq, AminoAcidSequence aa1, AminoAcidSequence aa2, AminoAcidSequence aa3, AminoAcidSequence aa4, AminoAcidSequence aa5, AminoAcidSequence aa6) {
            this.start = start;
            this.seq = seq;
            this.posAA = new AminoAcidSequence[]{aa1, aa2, aa3};
            this.negAA = new AminoAcidSequence[]{aa4, aa5, aa6};
        }
    }
}

