/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import apple.dts.samplecode.osxadapter.OSXAdapter;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.broad.igv.ui.IGVMenuBar;
import org.broad.igv.ui.ShutdownThread;

public class DesktopIntegration {
    private static Logger log = Logger.getLogger(DesktopIntegration.class);

    public static final void verifyJavaPlatform() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion == null || !javaVersion.startsWith("1.8")) {
            try {
                System.out.println("Detected an unsupported Java version.  Java 8 is required by this release.");
                if (!GraphicsEnvironment.isHeadless()) {
                    JOptionPane.showMessageDialog(null, "Detected an unsupported Java version.  Java 8 is required by this release.");
                }
            }
            finally {
                System.exit(1);
            }
        }
    }

    public static void setDockIcon(Image image) {
        OSXAdapter.setDockIconImage(image);
    }

    public static void setAboutHandler(IGVMenuBar igvMenuBar) {
        try {
            OSXAdapter.setAboutHandler(igvMenuBar, igvMenuBar.getClass().getDeclaredMethod("showAboutDialog", null));
        }
        catch (Exception e) {
            log.error("Error setting apple-specific about handler", e);
        }
    }

    public static void setQuitHandler() {
        try {
            OSXAdapter.setQuitHandler(ShutdownThread.class, ShutdownThread.class.getDeclaredMethod("runS", null));
        }
        catch (Exception e) {
            log.error("Error setting apple-specific quit handler", e);
        }
    }
}

