/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gs.dm;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class GSFileMetadata {
    private boolean isDirectory;
    private String name;
    private String path;
    private String url;
    private String format;
    private String size;

    public GSFileMetadata(String name, String path, String url, String format, String size, boolean isDirectory) {
        this.isDirectory = isDirectory;
        this.name = name;
        this.path = path;
        this.url = url;
        this.format = format;
        this.size = size;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getUrl() {
        return this.url;
    }

    public String getFormat() {
        return this.format;
    }

    public String getSize() {
        return this.size;
    }

    public static GSFileMetadata deserializeElement(JsonElement json) {
        JsonObject jobj = json.getAsJsonObject();
        String name = jobj.get("name").getAsString();
        String path = jobj.get("path").getAsString();
        String url = jobj.get("url").getAsString();
        boolean isDirectory = jobj.get("isDirectory").getAsBoolean();
        String format = "";
        String size = null;
        if (jobj.has("dataFormat")) {
            JsonObject dataFormat = jobj.get("dataFormat").getAsJsonObject();
            format = dataFormat == null ? "" : dataFormat.get("name").getAsString();
            size = jobj.get("size").getAsString();
        }
        return new GSFileMetadata(name, path, url, format, size, isDirectory);
    }

    private static class Deserializer
    implements JsonDeserializer<GSFileMetadata> {
        private Deserializer() {
        }

        @Override
        public GSFileMetadata deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return GSFileMetadata.deserializeElement(json);
        }
    }
}

