/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cli_plugin.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.broad.igv.cli_plugin.PluginSpecReader;
import org.broad.igv.prefs.PreferencesManager;

public class SetPluginPathDialog
extends JDialog {
    String pluginId;
    String toolName;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JTextArea textArea1;
    private JTextField pathInput;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public SetPluginPathDialog(Frame owner, PluginSpecReader pluginSpecReader, PluginSpecReader.Tool tool) {
        super(owner);
        this.initComponents();
        String toolName = tool.name;
        String title = pluginSpecReader.getName() + ": " + toolName;
        this.setTitle(title);
        this.pluginId = pluginSpecReader.getId();
        this.toolName = toolName;
        String currentPath = pluginSpecReader.getToolPath(tool);
        this.pathInput.setText(currentPath);
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent e) {
        PreferencesManager.getPreferences().putToolPath(this.pluginId, this.toolName, this.pathInput.getText());
        this.setVisible(false);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.textArea1 = new JTextArea();
        this.pathInput = new JTextField();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setModal(true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new FlowLayout());
        this.textArea1.setRows(2);
        this.textArea1.setText("Enter the path to the executable.   \nThis can be relative to your PATH environment variable if running locally");
        this.textArea1.setEditable(false);
        this.textArea1.setBackground(UIManager.getColor("Label.background"));
        this.contentPanel.add(this.textArea1);
        this.dialogPane.add((Component)this.contentPanel, "North");
        this.dialogPane.add((Component)this.pathInput, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetPluginPathDialog.this.okButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetPluginPathDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

