/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.cram.old;

import com.google.common.io.LittleEndianDataInputStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import org.broad.igv.sam.cram.old.CRAMFile;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class CRAMFileReader {
    public static CRAMFile openFile(String path) throws IOException {
        SeekableStream stream = IGVSeekableStreamFactory.getInstance().getStreamFor(path);
        LittleEndianDataInputStream lis = new LittleEndianDataInputStream(stream);
        byte[] mn = new byte[4];
        for (int i = 0; i < 4; ++i) {
            mn[i] = lis.readByte();
        }
        String magicNumber = new String(mn);
        int majorFormatNumber = lis.readUnsignedByte();
        int minorFormatNumber = lis.readUnsignedByte();
        byte[] fileId = new byte[20];
        for (int i = 0; i < 20; ++i) {
            fileId[i] = lis.readByte();
        }
        String fileName = new String(fileId);
        return new CRAMFile(path, majorFormatNumber, minorFormatNumber, fileName);
    }

    public static void main(String[] args) throws IOException {
        CRAMFile cramFile = CRAMFileReader.openFile(args[0]);
        cramFile.readContainerHeader(26L);
    }
}

