/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.methyl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.methyl.MethylDataSource;
import org.broad.igv.methyl.MethylScore;
import org.broad.igv.util.collections.LRUCache;

public class CachingMethylSource
implements MethylDataSource {
    private static Logger log = Logger.getLogger(CachingMethylSource.class);
    private static int DEFAULT_TILE_COUNT = 4;
    private int binSize;
    MethylDataSource reader;
    LRUCache<String, Bin> cache;

    public CachingMethylSource(MethylDataSource reader, int binSize) {
        this(reader, DEFAULT_TILE_COUNT, binSize);
    }

    public CachingMethylSource(MethylDataSource reader, int tileCount, int binSize) {
        this.reader = reader;
        this.cache = new LRUCache(tileCount);
        this.binSize = binSize;
    }

    public void setBinSize(int newSize) {
        this.binSize = newSize;
        this.cache.clear();
    }

    @Override
    public Iterator<MethylScore> query(String chr, int start, int end) {
        List<Bin> tiles;
        int startBin = 0;
        int endBin = 0;
        if (this.binSize > 0) {
            startBin = start / this.binSize;
            endBin = end / this.binSize;
        }
        if ((tiles = this.getBins(chr, startBin, endBin)).size() == 0) {
            return null;
        }
        int recordCount = 0;
        for (Bin t : tiles) {
            recordCount += t.getContainedRecords().size();
        }
        ArrayList<MethylScore> alignments = new ArrayList<MethylScore>(recordCount);
        for (Bin t : tiles) {
            alignments.addAll(t.getContainedRecords());
        }
        return new BinIterator(start, end, alignments);
    }

    private List<Bin> getBins(String seq, int startBin, int endBin) {
        ArrayList<Bin> tiles = new ArrayList<Bin>(endBin - startBin + 1);
        ArrayList<Bin> tilesToLoad = new ArrayList<Bin>(endBin - startBin + 1);
        for (int t = startBin; t <= endBin; ++t) {
            String key = seq + "_" + t;
            Bin tile = this.cache.get(key);
            if (tile == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Tile cache miss: " + t);
                }
                int start = t * this.binSize;
                int end = start + this.binSize;
                tile = new Bin(t, start, end);
                this.cache.put(key, tile);
            }
            tiles.add(tile);
            if (tile.isLoaded()) {
                if (tilesToLoad.size() > 0 && !this.loadTiles(seq, tilesToLoad)) {
                    return tiles;
                }
                tilesToLoad.clear();
                continue;
            }
            tilesToLoad.add(tile);
        }
        if (tilesToLoad.size() > 0) {
            this.loadTiles(seq, tilesToLoad);
        }
        return tiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadTiles(String seq, List<Bin> tiles) {
        int end;
        assert (tiles.size() > 0);
        if (log.isDebugEnabled()) {
            int first = tiles.get(0).getBinNumber();
            end = tiles.get(tiles.size() - 1).getBinNumber();
            log.debug("Loading tiles: " + first + "-" + end);
        }
        int start = tiles.get(0).start + 1;
        end = tiles.get(tiles.size() - 1).end;
        Iterator<MethylScore> iter = null;
        int featureCount = 0;
        long t0 = System.currentTimeMillis();
        try {
            iter = this.reader.query(seq, start, end);
            while (iter != null && iter.hasNext()) {
                MethylScore record = iter.next();
                int aStart = record.getStart();
                int aEnd = record.getEnd();
                int idx0 = 0;
                int idx1 = 0;
                if (this.binSize > 0) {
                    idx0 = Math.max(0, (aStart - start) / this.binSize);
                    idx1 = Math.min(tiles.size() - 1, (aEnd - start) / this.binSize);
                }
                for (int i = idx0; i <= idx1; ++i) {
                    Bin t = tiles.get(i);
                    if (this.binSize != 0 && (aStart < t.start || aStart >= t.end)) continue;
                    t.containedRecords.add(record);
                }
            }
            for (Bin t : tiles) {
                t.setLoaded(true);
            }
            if (log.isDebugEnabled()) {
                long dt = System.currentTimeMillis() - t0;
                long rate = dt == 0L ? Long.MAX_VALUE : (long)featureCount / dt;
                log.debug("Loaded " + featureCount + " reads in " + dt + "ms.  (" + rate + " reads/ms)");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (iter != null) {
                // empty if block
            }
        }
    }

    public class BinIterator
    implements Iterator<MethylScore> {
        Iterator<MethylScore> currentSamIterator;
        int end;
        MethylScore nextRecord;
        int start;
        List<MethylScore> alignments;

        BinIterator(int start, int end, List<MethylScore> alignments) {
            this.alignments = alignments;
            this.start = start;
            this.end = end;
            this.currentSamIterator = alignments.iterator();
            this.advanceToFirstRecord();
        }

        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.nextRecord != null;
        }

        @Override
        public MethylScore next() {
            MethylScore ret = this.nextRecord;
            this.advanceToNextRecord();
            return ret;
        }

        @Override
        public void remove() {
        }

        private void advanceToFirstRecord() {
            this.advanceToNextRecord();
        }

        private void advanceToNextRecord() {
            this.advance();
            while (this.nextRecord != null && this.nextRecord.getEnd() < this.start) {
                this.advance();
            }
        }

        private void advance() {
            if (this.currentSamIterator.hasNext()) {
                this.nextRecord = this.currentSamIterator.next();
                if (this.nextRecord.getStart() > this.end) {
                    this.nextRecord = null;
                }
            } else {
                this.nextRecord = null;
            }
        }

        public Iterator iterator() {
            return this;
        }
    }

    static class Bin {
        private boolean loaded = false;
        private int start;
        private int end;
        private int binNumber;
        private List<MethylScore> containedRecords;

        Bin(int binNumber, int start, int end) {
            this.binNumber = binNumber;
            this.start = start;
            this.end = end;
            this.containedRecords = new ArrayList<MethylScore>(1000);
        }

        public int getBinNumber() {
            return this.binNumber;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public List<MethylScore> getContainedRecords() {
            return this.containedRecords;
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public void setLoaded(boolean loaded) {
            this.loaded = loaded;
        }
    }
}

