/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.basepair;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.broad.igv.feature.basepair.BasePairData;
import org.broad.igv.feature.basepair.BasePairFileParser;
import org.broad.igv.feature.basepair.BasePairRenderer;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;

@XmlType(factoryMethod="getNextTrack")
@XmlSeeAlso(value={RenderOptions.class})
public class BasePairTrack
extends AbstractTrack {
    private static Logger log = Logger.getLogger(BasePairTrack.class);
    private BasePairRenderer basePairRenderer = new BasePairRenderer();
    private BasePairData basePairData = new BasePairData();
    Genome genome;
    private RenderOptions renderOptions = new RenderOptions();

    public BasePairTrack(ResourceLocator locator, String id, String name, Genome genome) {
        super(locator, id, name);
        BasePairFileParser.loadData(locator, genome, this.basePairData, this.renderOptions);
        this.genome = genome;
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        return this.basePairData != null;
    }

    @Override
    public void load(ReferenceFrame frame) {
        BasePairFileParser.loadData(this.getResourceLocator(), this.genome, this.basePairData, this.renderOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(RenderContext context, Rectangle rect) {
        Graphics2D g2d = context.getGraphics();
        Rectangle clip = new Rectangle(g2d.getClip().getBounds());
        g2d.setClip(rect.intersection(clip.getBounds()));
        context.clearGraphicsCache();
        try {
            this.basePairRenderer.draw(this.basePairData, context, rect, this.renderOptions);
            context.clearGraphicsCache();
        }
        finally {
            g2d.setClip(clip);
        }
    }

    @XmlElement(name="BPRenderOptions")
    private void setRenderOptions(RenderOptions renderOptions) {
        this.renderOptions = renderOptions;
    }

    public RenderOptions getRenderOptions() {
        return this.renderOptions;
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    private static BasePairTrack getNextTrack() {
        return (BasePairTrack)IGVSessionReader.getNextTrack();
    }

    @XmlType(name="BPRenderOptions")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RenderOptions {
        public static final String NAME = "BPRenderOptions";
        @XmlAttribute
        private ArcDirection arcDirection = ArcDirection.DOWN;
        @XmlElement
        private List<String> colors = new ArrayList<String>();
        @XmlElement
        private List<String> colorLabels = new ArrayList<String>();

        public void changeColor(Color currentColor, String currentLabel, Color newColor) {
            String currentColorString = ColorUtilities.colorToString(currentColor);
            String newColorString = ColorUtilities.colorToString(newColor);
            for (int i = 0; i < this.getColors().size(); ++i) {
                String colorString = this.getColors().get(i);
                String label = this.getColorLabels().get(i);
                if (!currentColorString.equals(colorString) || !currentLabel.equals(label)) continue;
                this.setColor(i, newColorString);
            }
        }

        public ArcDirection getArcDirection() {
            return this.arcDirection;
        }

        public void setArcDirection(ArcDirection d) {
            this.arcDirection = d;
        }

        public List<String> getColors() {
            return this.colors;
        }

        public void setColors(List<String> l) {
            this.colors = l;
        }

        public List<String> getColorLabels() {
            return this.colorLabels;
        }

        public void setColorLabels(List<String> l) {
            this.colorLabels = l;
        }

        public String getColor(int i) {
            return this.colors.get(i);
        }

        public void setColor(int i, String s) {
            this.colors.set(i, s);
        }

        public String getColorLabel(int i) {
            return this.colorLabels.get(i);
        }

        public void setColorLabel(int i, String s) {
            this.colorLabels.set(i, s);
        }
    }

    public static enum ArcDirection {
        UP,
        DOWN;

    }
}

