/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.batch;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.event.DataLoadedEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.ga4gh.Ga4ghAPIHelper;
import org.broad.igv.ga4gh.OAuthUtils;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.SnapshotUtilities;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.RuntimeUtils;
import org.broad.igv.util.StringUtils;

public class CommandExecutor {
    private static Logger log = Logger.getLogger(CommandExecutor.class);
    private File snapshotDirectory;
    private IGV igv = IGV.getInstance();
    private int sleepInterval = 2000;

    private List<String> getArgs(String[] tokens) {
        ArrayList<String> args = new ArrayList<String>(tokens.length);
        for (String s : tokens) {
            if (s.trim().length() <= 0) continue;
            args.add(s.trim());
        }
        return args;
    }

    public String execute(String command) {
        List<String> args = this.getArgs(StringUtils.breakQuotedString(command, ' ').toArray(new String[0]));
        String result = "OK";
        System.out.println();
        log.debug("Executing: " + command);
        try {
            String param4;
            if (args.size() == 0) {
                return "Empty command string";
            }
            String cmd = args.get(0).toLowerCase();
            String param1 = args.size() > 1 ? args.get(1) : null;
            String param2 = args.size() > 2 ? args.get(2) : null;
            String param3 = args.size() > 3 ? args.get(3) : null;
            String string = param4 = args.size() > 4 ? args.get(4) : null;
            if (cmd.equalsIgnoreCase("echo")) {
                result = cmd;
            } else {
                if (cmd.equalsIgnoreCase("gotoimmediate")) {
                    return this.gotoImmediate(args);
                }
                if (cmd.equalsIgnoreCase("goto")) {
                    result = this.goto1(args);
                } else if (cmd.equalsIgnoreCase("gototrack")) {
                    boolean res = IGV.getInstance().scrollToTrack(param1);
                    result = res ? "OK" : String.format("Error: Track %s not found", param1);
                } else if (cmd.equalsIgnoreCase("snapshotdirectory")) {
                    result = this.setSnapshotDirectory(param1);
                } else if (cmd.equalsIgnoreCase("snapshot")) {
                    String filename = param1;
                    result = this.createSnapshot(filename, param2);
                } else if ((cmd.equalsIgnoreCase("loadfile") || cmd.equalsIgnoreCase("load")) && param1 != null) {
                    result = this.load(param1, param2, param3, param4);
                } else if (cmd.equalsIgnoreCase("genome") && args.size() > 1) {
                    result = this.genome(param1);
                } else if (cmd.equalsIgnoreCase("new") || cmd.equalsIgnoreCase("reset") || cmd.equalsIgnoreCase("clear")) {
                    this.igv.newSession();
                } else if (cmd.equalsIgnoreCase("region")) {
                    this.defineRegion(param1, param2, param3, param4);
                } else if (cmd.equalsIgnoreCase("sort")) {
                    this.sort(param1, param2, param3, param4);
                } else if (cmd.equalsIgnoreCase("group")) {
                    this.group(param1, param2);
                } else if (cmd.equalsIgnoreCase("collapse")) {
                    String trackName = CommandExecutor.parseTrackName(param1);
                    this.igv.setTrackDisplayMode(Track.DisplayMode.COLLAPSED, trackName);
                } else if (cmd.equalsIgnoreCase("expand")) {
                    String trackName = CommandExecutor.parseTrackName(param1);
                    this.igv.setTrackDisplayMode(Track.DisplayMode.EXPANDED, trackName);
                } else if (cmd.equalsIgnoreCase("squish")) {
                    String trackName = CommandExecutor.parseTrackName(param1);
                    this.igv.setTrackDisplayMode(Track.DisplayMode.SQUISHED, trackName);
                } else if (cmd.equalsIgnoreCase("remove")) {
                    String trackName = CommandExecutor.parseTrackName(param1);
                    result = this.removeTrack(trackName);
                } else if (cmd.equalsIgnoreCase("tweakdivider")) {
                    this.igv.tweakPanelDivider();
                } else if (cmd.equalsIgnoreCase("setDataRange")) {
                    result = this.setDataRange(param1, param2);
                } else {
                    if (cmd.equalsIgnoreCase("maxpanelheight") && param1 != null) {
                        return this.setMaxPanelHeight(param1);
                    }
                    if (cmd.equalsIgnoreCase("tofront")) {
                        return UIUtilities.bringToFront();
                    }
                    if (cmd.equalsIgnoreCase("viewaspairs")) {
                        return this.setViewAsPairs(param1, param2);
                    }
                    if (cmd.equalsIgnoreCase("samplingwindowsize")) {
                        return this.setSamplingWindowSize(param1);
                    }
                    if (cmd.equalsIgnoreCase("maxdepth") || cmd.equalsIgnoreCase("samplingreadcount")) {
                        return this.setSamplingReadCount(param1);
                    }
                    if (cmd.equalsIgnoreCase("setSleepInterval")) {
                        return this.setSleepInterval(param1);
                    }
                    if (cmd.equalsIgnoreCase("setCredentials")) {
                        return this.setCredentials(param1, param2);
                    }
                    if (cmd.equalsIgnoreCase("clearCredentials")) {
                        return this.clearCredentials();
                    }
                    if (cmd.equals("preference")) {
                        return this.overridePreference(param1, param2);
                    }
                    if (cmd.equalsIgnoreCase("version")) {
                        return Globals.VERSION;
                    }
                    if (cmd.equals("exit")) {
                        System.exit(0);
                    } else if (cmd.equals("zoomin")) {
                        FrameManager.incrementZoom(1);
                    } else if (cmd.equals("zoomout")) {
                        FrameManager.incrementZoom(-1);
                    } else if ("oauth".equals(cmd)) {
                        try {
                            OAuthUtils.getInstance().setAccessToken(param1);
                        }
                        catch (IOException e1) {
                            log.error(e1);
                            return e1.getMessage();
                        }
                    } else {
                        result = "UNKOWN COMMAND: " + command;
                        log.error(result);
                        return result;
                    }
                }
            }
            this.igv.doRefresh();
            if (RuntimeUtils.getAvailableMemoryFraction() < 0.5) {
                log.debug("Running garbage collection");
                System.gc();
            }
            log.debug("Finished execution: " + command + "  sleeping ....");
            if (this.sleepInterval > 0) {
                try {
                    Thread.sleep(this.sleepInterval);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            log.debug("Finished sleeping");
        }
        catch (IOException e) {
            log.error(e);
            result = "Error: " + e.getMessage();
        }
        log.info(result);
        return result;
    }

    private String removeTrack(String trackName) {
        if (trackName == null) {
            return "Error: NULL TRACK NAME";
        }
        for (Track track : this.igv.getAllTracks()) {
            if (!track.getName().equals(trackName)) continue;
            this.igv.removeTracks(Arrays.asList(track));
            return "OK";
        }
        return String.format("Error: Track %s not found", trackName);
    }

    static String parseTrackName(String param1) {
        return param1 == null ? null : StringUtils.stripQuotes(param1);
    }

    private String overridePreference(String prefKey, String prefVal) {
        PreferencesManager.getPreferences().override(prefKey, prefVal);
        return "OK";
    }

    private String setDataRange(String dataRangeString, String trackName) {
        DataRange range;
        List<Track> tracks;
        block6: {
            tracks = this.igv.getAllTracks();
            String[] tokens = dataRangeString.split(",");
            try {
                if (tokens.length == 2) {
                    range = new DataRange(Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]));
                    break block6;
                }
                if (tokens.length == 3) {
                    range = new DataRange(Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]));
                    break block6;
                }
                throw new IllegalArgumentException(String.format("ERROR: parsing %s for data range. \nString must be of form <min,max> or <min,baseline,max>", dataRangeString));
            }
            catch (NumberFormatException e) {
                return "ERROR: Could not parse input string as a Float. " + e.getMessage();
            }
            catch (IllegalArgumentException e) {
                return e.getMessage();
            }
        }
        for (Track track : tracks) {
            if (trackName != null && !trackName.equalsIgnoreCase(track.getName())) continue;
            track.setDataRange(range);
            track.setAutoScale(false);
        }
        return "OK";
    }

    private String setViewAsPairs(String vAPString, String trackName) {
        List<Track> tracks = this.igv.getAllTracks();
        boolean vAP = !"false".equalsIgnoreCase(vAPString);
        for (Track track : tracks) {
            if (!(track instanceof AlignmentTrack) || trackName != null && !trackName.equalsIgnoreCase(track.getName())) continue;
            AlignmentTrack atrack = (AlignmentTrack)track;
            atrack.setViewAsPairs(vAP);
        }
        return "OK";
    }

    private String setSamplingWindowSize(String windowSize) {
        try {
            Integer.parseInt(windowSize);
            PreferencesManager.getPreferences().override("SAM.SAMPLING_WINDOW", String.valueOf(windowSize));
            return "OK";
        }
        catch (NumberFormatException e) {
            return "ERROR: SAMPLING WINDOW IS NOT A NUMBER: " + windowSize;
        }
    }

    private String setSamplingReadCount(String samplingReadCount) {
        try {
            Integer.parseInt(samplingReadCount);
            PreferencesManager.getPreferences().override("SAM.MAX_LEVELS", String.valueOf(samplingReadCount));
            return "OK";
        }
        catch (NumberFormatException e) {
            return "ERROR: SAMPLING READ COUNT IS NOT A NUMBER: " + samplingReadCount;
        }
    }

    private String gotoImmediate(List<String> args) {
        return this.goto1(args);
    }

    private String setMaxPanelHeight(String param1) {
        try {
            Integer h = Integer.parseInt(param1.trim());
            SnapshotUtilities.setMaxPanelHeight(h);
            return "OK";
        }
        catch (NumberFormatException e) {
            return "ERROR - max panel height value ('" + param1 + ".) must be an integer number";
        }
    }

    public String setSleepInterval(String param1) {
        try {
            this.sleepInterval = Integer.parseInt(param1.trim());
            return "OK";
        }
        catch (NumberFormatException e) {
            return "ERROR - sleep interval value ('" + param1 + ".) must be an integer number";
        }
    }

    private String setCredentials(String param1, String param2) {
        HttpUtils.getInstance().setDefaultUserName(param1);
        HttpUtils.getInstance().setDefaultPassword(param2);
        return "OK";
    }

    private String clearCredentials() {
        HttpUtils.getInstance().clearDefaultCredentials();
        return "OK";
    }

    private String genome(String param1) {
        if (param1 == null) {
            return "ERROR missing genome parameter";
        }
        String result = "OK";
        String genomeID = param1;
        this.igv.selectGenomeFromList(genomeID);
        if (GenomeManager.getInstance().getCurrentGenome().getId().equals(genomeID)) {
            return result;
        }
        String genomePath = genomeID;
        if (!ParsingUtils.pathExists(genomePath)) {
            String workingDirectory = System.getProperty("user.dir", "");
            genomePath = FileUtils.getAbsolutePath(genomeID, workingDirectory);
        }
        if (ParsingUtils.pathExists(genomePath)) {
            try {
                GenomeManager.getInstance().loadGenome(genomePath, null);
            }
            catch (IOException e) {
                result = "ERROR: Could not load genome: " + genomeID;
                MessageUtils.showMessage(result);
            }
        } else {
            result = "ERROR: Could not locate genome: " + genomeID;
            MessageUtils.showMessage(result);
        }
        return result;
    }

    private String load(String fileString, String param2, String param3, String param4) throws IOException {
        String tmpFile = StringUtils.stripQuotes(fileString);
        boolean merge = !tmpFile.endsWith(".xml") && !tmpFile.endsWith(".php") && !tmpFile.endsWith(".php3");
        String name = null;
        String index = null;
        String coverage = null;
        String format = null;
        for (String param : Arrays.asList(param2, param3)) {
            if (param != null && param.startsWith("name=")) {
                name = param.substring(5);
                continue;
            }
            if (param != null && param.startsWith("merge=")) {
                String mergeString = param.substring(6);
                merge = mergeString.equalsIgnoreCase("true");
                continue;
            }
            if (param != null && param.startsWith("index=")) {
                index = param.substring(6);
                continue;
            }
            if (param != null && param.startsWith("coverage=")) {
                coverage = param.substring(9);
                continue;
            }
            if (param == null || !param.startsWith("format=")) continue;
            format = param.substring(7);
        }
        String locus = null;
        Map<String, String> params = null;
        return this.loadFiles(fileString, index, coverage, name, format, locus, merge, params);
    }

    String loadFiles(String fileString, String indexString, String coverageString, String nameString, String formatString, String locus, boolean merge, Map<String, String> params) throws IOException {
        return this.loadFiles(fileString, indexString, coverageString, nameString, formatString, locus, merge, params, null, null);
    }

    String loadFiles(String fileString, String indexString, String coverageString, String nameString, String formatString, String locus, boolean merge, Map<String, String> params, String sort, String sortTag) throws IOException {
        log.debug("Run load files");
        List<String> files = StringUtils.breakQuotedString(fileString, ',');
        List<String> names = StringUtils.breakQuotedString(nameString, ',');
        List<String> indexFiles = StringUtils.breakQuotedString(indexString, ',');
        List<String> coverageFiles = StringUtils.breakQuotedString(coverageString, ',');
        List<String> formats = StringUtils.breakQuotedString(formatString, ',');
        if (files.size() == 1) {
            files = StringUtils.breakQuotedString(fileString.replaceAll("%2C", ","), ',');
            names = nameString != null ? StringUtils.breakQuotedString(nameString.replaceAll("%2C", ","), ',') : null;
            indexFiles = indexString != null ? StringUtils.breakQuotedString(indexString.replaceAll("%2C", ","), ',') : null;
            coverageFiles = coverageString != null ? StringUtils.breakQuotedString(coverageString.replaceAll("%2C", ","), ',') : null;
            List<String> list = formats = formatString != null ? StringUtils.breakQuotedString(formatString.replaceAll("%2C", ","), ',') : null;
        }
        if (names != null && names.size() != files.size()) {
            return "Error: If file is a comma-separated list, names must also be a comma-separated list of the same length";
        }
        if (indexFiles != null && indexFiles.size() != files.size()) {
            return "Error: If file is a comma-separated list, index must also be a comma-separated list of the same length";
        }
        for (int ii = 0; ii < files.size(); ++ii) {
            files.set(ii, CommandExecutor.decodeFileString(files.get(ii).replace("\"", "")));
            if (names != null) {
                names.set(ii, names.get(ii).replace("\"", ""));
            }
            if (indexFiles != null) {
                indexFiles.set(ii, CommandExecutor.decodeFileString(indexFiles.get(ii).replace("\"", "")));
            }
            if (coverageFiles != null) {
                coverageFiles.set(ii, CommandExecutor.decodeFileString(coverageFiles.get(ii).replace("\"", "")));
            }
            if (formatString == null) continue;
            formats.set(ii, CommandExecutor.decodeFileString(formats.get(ii).replace("\"", "")));
        }
        ArrayList<ResourceLocator> fileLocators = new ArrayList<ResourceLocator>();
        ArrayList<String> sessionPaths = new ArrayList<String>();
        if (!merge) {
            boolean unload;
            boolean bl = unload = !merge;
            unload = fileString.endsWith(".xml") || fileString.endsWith(".php") || fileString.endsWith(".php3") ? !merge : MessageUtils.confirm("Unload current session before loading new tracks?");
            if (unload) {
                this.igv.newSession();
            }
        }
        HashSet<String> loadedFiles = new HashSet<String>();
        for (ResourceLocator rl : this.igv.getDataResourceLocators()) {
            loadedFiles.add(rl.getPath());
        }
        for (int fi = 0; fi < files.size(); ++fi) {
            String f = files.get(fi);
            if (loadedFiles.contains(f)) continue;
            if (f.endsWith(".xml") || f.endsWith(".php") || f.endsWith(".php3") || f.endsWith(".session")) {
                sessionPaths.add(f);
                continue;
            }
            ResourceLocator rl = new ResourceLocator(f);
            if (names != null) {
                rl.setName(names.get(fi));
            }
            if (indexFiles != null) {
                rl.setIndexPath(indexFiles.get(fi));
            }
            if (coverageFiles != null) {
                rl.setCoverage(coverageFiles.get(fi));
            }
            if (formats != null) {
                String format = formats.get(fi);
                if (!"ga4gh".equals(format) && !format.startsWith(".")) {
                    format = "." + format;
                }
                rl.setType(format);
            }
            if ("ga4gh".equals(rl.getType())) {
                rl.setAttribute("provider", Ga4ghAPIHelper.GA4GH_GOOGLE_PROVIDER);
            } else {
                File file;
                if (params != null) {
                    String trackLine = this.createTrackLine(params);
                    rl.setTrackLine(trackLine);
                }
                if (rl.isLocal() && !(file = new File(rl.getPath())).exists()) {
                    return "Error: " + f + " does not exist.";
                }
            }
            fileLocators.add(rl);
        }
        for (String sessionPath : sessionPaths) {
            this.igv.restoreSessionSynchronous(sessionPath, locus, merge);
        }
        Future loadTask = this.igv.loadTracks(fileLocators);
        if (locus != null && !locus.equals("null")) {
            this.igv.goToLocus(locus);
            String[] tokens = locus.split(":", 2);
            if (tokens.length == 2) {
                String chr = tokens[0];
                try {
                    int pos = Integer.parseInt(tokens[1].replace(",", ""));
                    if (pos >= 0 && sort == null) {
                        sort = "base";
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (sort != null) {
            this.submitPerformSort(loadTask, sort, sortTag);
        }
        return "OK";
    }

    private void submitPerformSort(final Future loadTask, String sort, final String sortTag) {
        final AlignmentTrack.SortOption sortOption = CommandExecutor.getAlignmentSortOption(sort);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (loadTask != null) {
                        Object v = loadTask.get();
                    }
                    IGVEventBus.getInstance().subscribe(DataLoadedEvent.class, new SortAlignmentsHandler(CommandExecutor.this.igv, sortOption, sortTag));
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), e);
                }
                catch (ExecutionException e) {
                    log.error(e.getMessage(), e);
                }
            }
        };
        LongRunningTask.submit(runnable);
    }

    static String decodeFileString(String fileString) {
        if (CommandExecutor.needsDecode(fileString)) {
            return StringUtils.decodeURL(fileString);
        }
        return fileString;
    }

    static boolean needsDecode(String fileString) {
        String decodedString = CommandExecutor.decodeSafe(fileString);
        return decodedString != null && (HttpUtils.isURL(fileString) || HttpUtils.isURL(decodedString));
    }

    private static String decodeSafe(String string) {
        String tmp = null;
        try {
            tmp = StringUtils.decodeURL(string);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        return tmp;
    }

    private String createTrackLine(Map<String, String> params) {
        return params.get("hgt.customText");
    }

    String setSnapshotDirectory(String param1) {
        String result;
        if (param1 == null) {
            return "ERROR: missing directory parameter";
        }
        param1 = StringUtils.stripQuotes(param1);
        File parentDir = null;
        try {
            parentDir = this.getFile(param1);
        }
        catch (URISyntaxException e) {
            log.error("Error parsing directory path: " + param1, e);
            return "Error parsing directory path: " + param1;
        }
        if (parentDir.exists()) {
            this.snapshotDirectory = parentDir;
            result = "OK";
        } else {
            CommandExecutor.createParents(parentDir);
            parentDir.mkdir();
            if (parentDir.exists()) {
                this.snapshotDirectory = parentDir;
                result = "OK";
            } else {
                result = "ERROR: directory: " + param1 + " does not exist";
            }
        }
        return result;
    }

    private File getFile(String param1) throws URISyntaxException {
        if (param1.startsWith("\"")) {
            param1 = param1.substring(1);
        }
        if (param1.endsWith("\"")) {
            param1 = param1.substring(0, param1.lastIndexOf(34));
        }
        if (param1.indexOf(32) < 0) {
            return new File(param1);
        }
        File f = new File(param1);
        if (f.isAbsolute()) {
            URI outputURI = new URI("file://" + param1.replaceAll(" ", "%20"));
            return new File(outputURI);
        }
        return f;
    }

    private String goto1(List<String> args) {
        if (args == null || args.size() < 2) {
            return "ERROR: missing locus parameter";
        }
        String locus = args.get(1);
        for (int i = 2; i < args.size(); ++i) {
            locus = locus + " " + args.get(i);
        }
        this.igv.goToLocus(locus);
        return "OK";
    }

    private void defineRegion(String param1, String param2, String param3, String param4) {
        Locus locus;
        String desc;
        RegionOfInterest roi = null;
        if (param1 != null && param2 != null && param3 != null) {
            int start = Math.max(0, Integer.parseInt(param2) - 1);
            int end = Integer.parseInt(param3);
            desc = param4 != null ? param4 : "";
            roi = new RegionOfInterest(param1, start, end, desc);
        }
        if (param1 != null && (locus = Locus.fromString(param1)) != null) {
            int start = Math.max(0, locus.getStart() - 1);
            desc = param2 != null ? param2 : "";
            roi = new RegionOfInterest(locus.getChr(), start, locus.getEnd(), desc);
        }
        if (roi != null) {
            this.igv.addRegionOfInterest(roi);
        }
    }

    private void sort(String sortArg, String locusString, String param3, String param4) {
        RegionScoreType regionSortOption = CommandExecutor.getRegionSortOption(sortArg);
        String tag = "";
        if (regionSortOption != null) {
            Locus locus;
            RegionOfInterest roi = null;
            if (locusString != null && (locus = Locus.fromString(locusString)) != null) {
                int start = Math.max(0, locus.getStart() - 1);
                roi = new RegionOfInterest(locus.getChr(), start, locus.getEnd(), "");
            }
            this.igv.sortByRegionScore(roi, regionSortOption, FrameManager.getDefaultFrame());
        } else {
            Double location = null;
            if (param3 != null && param3.trim().length() > 0) {
                try {
                    location = new Double(param3.replace(",", ""));
                    tag = param4;
                }
                catch (NumberFormatException e) {
                    tag = param3;
                }
            } else if (locusString != null && locusString.trim().length() > 0) {
                try {
                    location = new Double(locusString.replace(",", ""));
                    tag = param4;
                }
                catch (NumberFormatException e) {
                    tag = param3;
                }
            }
            if (location != null) {
                Double d = location;
                Double d2 = location = Double.valueOf(location - 1.0);
            }
            this.igv.sortAlignmentTracks(CommandExecutor.getAlignmentSortOption(sortArg), location, tag);
        }
        this.igv.revalidateTrackPanels();
    }

    private void group(String groupArg, String tagArg) {
        this.igv.groupAlignmentTracks(CommandExecutor.getAlignmentGroupOption(groupArg), tagArg, null);
        UIUtilities.invokeAndWaitOnEventThread(() -> this.igv.revalidateTrackPanels());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private String createSnapshot(String filename, String region) {
        if (filename == null) {
            locus = FrameManager.getDefaultFrame().getFormattedLocusString();
            filename = locus.replaceAll(":", "_").replace("-", "_") + ".png";
        } else {
            filename = StringUtils.stripQuotes(filename);
        }
        if (this.snapshotDirectory == null) {
            try {
                file = this.getFile(filename);
                if (file.getAbsoluteFile().getParentFile().exists()) ** GOTO lbl16
                CommandExecutor.createParents(file);
            }
            catch (URISyntaxException e) {
                CommandExecutor.log.error("Error parsing directory path: " + filename, e);
                return "Error parsing directory path: " + filename;
            }
        } else {
            file = new File(this.snapshotDirectory, filename);
        }
lbl16:
        // 3 sources

        System.out.println("Snapshot: " + file.getAbsolutePath());
        target /* !! */  = null;
        if (region == null || region.trim().length() == 0) {
            target /* !! */  = IGV.getInstance().getContentPane().getMainPanel();
        } else if ("trackpanels".equalsIgnoreCase(region)) {
            target /* !! */  = IGV.getInstance().getMainPanel().getCenterSplitPane();
        }
        if (target /* !! */  == null) {
            msg = "ERROR. Could not create snapshot. Unknown region: " + region;
            CommandExecutor.log.error(msg);
            return msg;
        }
        try {
            return IGV.getInstance().createSnapshotNonInteractive(target /* !! */ , file, true);
        }
        catch (IOException e) {
            CommandExecutor.log.error(e);
            return e.getMessage();
        }
    }

    private static void createParents(File outputFile) {
        File parent = outputFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
    }

    private static RegionScoreType getRegionSortOption(String str) {
        if (str == null) {
            return null;
        }
        String option = str.toUpperCase();
        try {
            return RegionScoreType.valueOf(option);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static AlignmentTrack.SortOption getAlignmentSortOption(String str) {
        String string = str = str == null ? "base" : str;
        if (str.equalsIgnoreCase("start") || str.equalsIgnoreCase("position")) {
            return AlignmentTrack.SortOption.START;
        }
        if (str.equalsIgnoreCase("strand")) {
            return AlignmentTrack.SortOption.STRAND;
        }
        if (str.equalsIgnoreCase("base")) {
            return AlignmentTrack.SortOption.NUCLEOTIDE;
        }
        if (str.equalsIgnoreCase("quality")) {
            return AlignmentTrack.SortOption.QUALITY;
        }
        if (str.equalsIgnoreCase("sample")) {
            return AlignmentTrack.SortOption.SAMPLE;
        }
        if (str.equalsIgnoreCase("readGroup") || str.equalsIgnoreCase("read_group")) {
            return AlignmentTrack.SortOption.READ_GROUP;
        }
        if (str.equalsIgnoreCase("insertSize") || str.equalsIgnoreCase("insert_size")) {
            return AlignmentTrack.SortOption.INSERT_SIZE;
        }
        if (str.equalsIgnoreCase("firstOfPairStrand")) {
            return AlignmentTrack.SortOption.FIRST_OF_PAIR_STRAND;
        }
        if (str.equalsIgnoreCase("mateChr")) {
            return AlignmentTrack.SortOption.MATE_CHR;
        }
        try {
            return AlignmentTrack.SortOption.valueOf(str.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.error("Unknown sort option: " + str);
            return AlignmentTrack.SortOption.NUCLEOTIDE;
        }
    }

    private static AlignmentTrack.GroupOption getAlignmentGroupOption(String str) {
        if (str == null || str.length() == 0) {
            return AlignmentTrack.GroupOption.NONE;
        }
        if (str.equalsIgnoreCase("strand")) {
            return AlignmentTrack.GroupOption.STRAND;
        }
        if (str.equalsIgnoreCase("sample")) {
            return AlignmentTrack.GroupOption.SAMPLE;
        }
        if (str.equalsIgnoreCase("library")) {
            return AlignmentTrack.GroupOption.LIBRARY;
        }
        if (str.equalsIgnoreCase("readGroup") || str.equalsIgnoreCase("read_group")) {
            return AlignmentTrack.GroupOption.READ_GROUP;
        }
        try {
            return AlignmentTrack.GroupOption.valueOf(str.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.error("Unknown group by option: " + str);
            return AlignmentTrack.GroupOption.NONE;
        }
    }

    private static class SortAlignmentsHandler
    implements IGVEventObserver {
        private IGV igv = null;
        private AlignmentTrack.SortOption sortOption;
        private String sortTag;

        SortAlignmentsHandler(IGV igv, AlignmentTrack.SortOption sortOption, String sortTag) {
            this.igv = igv;
            this.sortOption = sortOption;
            this.sortTag = sortTag;
            IGVEventBus.getInstance().subscribe(DataLoadedEvent.class, this);
        }

        @Override
        public void receiveEvent(Object event) {
            boolean sorted = this.igv.sortAlignmentTracks(this.sortOption, this.sortTag);
            if (sorted) {
                IGVEventBus.getInstance().unsubscribe(this);
            }
        }
    }
}

