/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.traverse.CrossComponentIterator;
import org.jgrapht.util.FibonacciHeap;
import org.jgrapht.util.FibonacciHeapNode;

public class ClosestFirstIterator<V, E>
extends CrossComponentIterator<V, E, FibonacciHeapNode<QueueEntry<V, E>>> {
    private FibonacciHeap<QueueEntry<V, E>> heap = new FibonacciHeap();
    private double radius = Double.POSITIVE_INFINITY;
    private boolean initialized = false;

    public ClosestFirstIterator(Graph<V, E> graph) {
        this(graph, null);
    }

    public ClosestFirstIterator(Graph<V, E> graph, V v2) {
        this(graph, v2, Double.POSITIVE_INFINITY);
    }

    public ClosestFirstIterator(Graph<V, E> graph, V v2, double d2) {
        super(graph, v2);
        this.radius = d2;
        this.checkRadiusTraversal(this.isCrossComponentTraversal());
        this.initialized = true;
    }

    @Override
    public void setCrossComponentTraversal(boolean bl) {
        if (this.initialized) {
            this.checkRadiusTraversal(bl);
        }
        super.setCrossComponentTraversal(bl);
    }

    public double getShortestPathLength(V v2) {
        FibonacciHeapNode fibonacciHeapNode = (FibonacciHeapNode)this.getSeenData(v2);
        if (fibonacciHeapNode == null) {
            return Double.POSITIVE_INFINITY;
        }
        return fibonacciHeapNode.getKey();
    }

    public E getSpanningTreeEdge(V v2) {
        FibonacciHeapNode fibonacciHeapNode = (FibonacciHeapNode)this.getSeenData(v2);
        if (fibonacciHeapNode == null) {
            return null;
        }
        return ((QueueEntry)fibonacciHeapNode.getData()).spanningTreeEdge;
    }

    @Override
    protected boolean isConnectedComponentExhausted() {
        if (this.heap.size() == 0) {
            return true;
        }
        if (this.heap.min().getKey() > this.radius) {
            this.heap.clear();
            return true;
        }
        return false;
    }

    @Override
    protected void encounterVertex(V v2, E e2) {
        double d2 = e2 == null ? 0.0 : this.calculatePathLength(v2, e2);
        FibonacciHeapNode<QueueEntry<V, E>> fibonacciHeapNode = this.createSeenData(v2, e2);
        this.putSeenData(v2, fibonacciHeapNode);
        this.heap.insert(fibonacciHeapNode, d2);
    }

    @Override
    protected void encounterVertexAgain(V v2, E e2) {
        FibonacciHeapNode fibonacciHeapNode = (FibonacciHeapNode)this.getSeenData(v2);
        if (((QueueEntry)fibonacciHeapNode.getData()).frozen) {
            return;
        }
        double d2 = this.calculatePathLength(v2, e2);
        if (d2 < fibonacciHeapNode.getKey()) {
            ((QueueEntry)fibonacciHeapNode.getData()).spanningTreeEdge = e2;
            this.heap.decreaseKey(fibonacciHeapNode, d2);
        }
    }

    @Override
    protected V provideNextVertex() {
        FibonacciHeapNode<QueueEntry<V, E>> fibonacciHeapNode = this.heap.removeMin();
        fibonacciHeapNode.getData().frozen = true;
        return fibonacciHeapNode.getData().vertex;
    }

    private void assertNonNegativeEdge(E e2) {
        if (this.getGraph().getEdgeWeight(e2) < 0.0) {
            throw new IllegalArgumentException("negative edge weights not allowed");
        }
    }

    private double calculatePathLength(V v2, E e2) {
        this.assertNonNegativeEdge(e2);
        Object v3 = Graphs.getOppositeVertex(this.getGraph(), e2, v2);
        FibonacciHeapNode fibonacciHeapNode = (FibonacciHeapNode)this.getSeenData(v3);
        return fibonacciHeapNode.getKey() + this.getGraph().getEdgeWeight(e2);
    }

    private void checkRadiusTraversal(boolean bl) {
        if (bl && this.radius != Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("radius may not be specified for cross-component traversal");
        }
    }

    private FibonacciHeapNode<QueueEntry<V, E>> createSeenData(V v2, E e2) {
        QueueEntry queueEntry = new QueueEntry();
        queueEntry.vertex = v2;
        queueEntry.spanningTreeEdge = e2;
        return new FibonacciHeapNode(queueEntry);
    }

    static class QueueEntry<V, E> {
        E spanningTreeEdge;
        V vertex;
        boolean frozen;

        QueueEntry() {
        }
    }
}

