/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectId
implements Comparable<ObjectId>,
Serializable {
    private static final long serialVersionUID = -4415279469780082174L;
    static final Logger LOGGER = Logger.getLogger("org.bson.ObjectId");
    final int _time;
    final int _machine;
    final int _inc;
    boolean _new;
    private static AtomicInteger _nextInc = new AtomicInteger(new Random().nextInt());
    private static final int _genmachine;

    public static ObjectId get() {
        return new ObjectId();
    }

    public static boolean isValid(String s2) {
        if (s2 == null) {
            return false;
        }
        int len = s2.length();
        if (len != 24) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F') continue;
            return false;
        }
        return true;
    }

    public static ObjectId massageToObjectId(Object o2) {
        String s2;
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof ObjectId) {
            return (ObjectId)o2;
        }
        if (o2 instanceof String && ObjectId.isValid(s2 = o2.toString())) {
            return new ObjectId(s2);
        }
        return null;
    }

    public ObjectId(Date time) {
        this(time, _genmachine, _nextInc.getAndIncrement());
    }

    public ObjectId(Date time, int inc) {
        this(time, _genmachine, inc);
    }

    public ObjectId(Date time, int machine, int inc) {
        this._time = (int)(time.getTime() / 1000L);
        this._machine = machine;
        this._inc = inc;
        this._new = false;
    }

    public ObjectId(String s2) {
        this(s2, false);
    }

    public ObjectId(String s2, boolean babble) {
        if (!ObjectId.isValid(s2)) {
            throw new IllegalArgumentException("invalid ObjectId [" + s2 + "]");
        }
        if (babble) {
            s2 = ObjectId.babbleToMongod(s2);
        }
        byte[] b2 = new byte[12];
        for (int i2 = 0; i2 < b2.length; ++i2) {
            b2[i2] = (byte)Integer.parseInt(s2.substring(i2 * 2, i2 * 2 + 2), 16);
        }
        ByteBuffer bb = ByteBuffer.wrap(b2);
        this._time = bb.getInt();
        this._machine = bb.getInt();
        this._inc = bb.getInt();
        this._new = false;
    }

    public ObjectId(byte[] b2) {
        if (b2.length != 12) {
            throw new IllegalArgumentException("need 12 bytes");
        }
        ByteBuffer bb = ByteBuffer.wrap(b2);
        this._time = bb.getInt();
        this._machine = bb.getInt();
        this._inc = bb.getInt();
        this._new = false;
    }

    public ObjectId(int time, int machine, int inc) {
        this._time = time;
        this._machine = machine;
        this._inc = inc;
        this._new = false;
    }

    public ObjectId() {
        this._time = (int)(System.currentTimeMillis() / 1000L);
        this._machine = _genmachine;
        this._inc = _nextInc.getAndIncrement();
        this._new = true;
    }

    public int hashCode() {
        int x2 = this._time;
        x2 += this._machine * 111;
        return x2 += this._inc * 17;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        ObjectId other = ObjectId.massageToObjectId(o2);
        if (other == null) {
            return false;
        }
        return this._time == other._time && this._machine == other._machine && this._inc == other._inc;
    }

    public String toStringBabble() {
        return ObjectId.babbleToMongod(this.toStringMongod());
    }

    public String toStringMongod() {
        byte[] b2 = this.toByteArray();
        StringBuilder buf = new StringBuilder(24);
        for (int i2 = 0; i2 < b2.length; ++i2) {
            int x2 = b2[i2] & 0xFF;
            String s2 = Integer.toHexString(x2);
            if (s2.length() == 1) {
                buf.append("0");
            }
            buf.append(s2);
        }
        return buf.toString();
    }

    public byte[] toByteArray() {
        byte[] b2 = new byte[12];
        ByteBuffer bb = ByteBuffer.wrap(b2);
        bb.putInt(this._time);
        bb.putInt(this._machine);
        bb.putInt(this._inc);
        return b2;
    }

    static String _pos(String s2, int p2) {
        return s2.substring(p2 * 2, p2 * 2 + 2);
    }

    public static String babbleToMongod(String b2) {
        int i2;
        if (!ObjectId.isValid(b2)) {
            throw new IllegalArgumentException("invalid object id: " + b2);
        }
        StringBuilder buf = new StringBuilder(24);
        for (i2 = 7; i2 >= 0; --i2) {
            buf.append(ObjectId._pos(b2, i2));
        }
        for (i2 = 11; i2 >= 8; --i2) {
            buf.append(ObjectId._pos(b2, i2));
        }
        return buf.toString();
    }

    public String toString() {
        return this.toStringMongod();
    }

    int _compareUnsigned(int i2, int j2) {
        long li = 0xFFFFFFFFL;
        li = (long)i2 & li;
        long lj = 0xFFFFFFFFL;
        long diff = li - (lj = (long)j2 & lj);
        if (diff < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (diff > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)diff;
    }

    @Override
    public int compareTo(ObjectId id) {
        if (id == null) {
            return -1;
        }
        int x2 = this._compareUnsigned(this._time, id._time);
        if (x2 != 0) {
            return x2;
        }
        x2 = this._compareUnsigned(this._machine, id._machine);
        if (x2 != 0) {
            return x2;
        }
        return this._compareUnsigned(this._inc, id._inc);
    }

    public int getMachine() {
        return this._machine;
    }

    public long getTime() {
        return (long)this._time * 1000L;
    }

    public int getTimeSecond() {
        return this._time;
    }

    public int getInc() {
        return this._inc;
    }

    public int _time() {
        return this._time;
    }

    public int _machine() {
        return this._machine;
    }

    public int _inc() {
        return this._inc;
    }

    public boolean isNew() {
        return this._new;
    }

    public void notNew() {
        this._new = false;
    }

    public static int getGenMachineId() {
        return _genmachine;
    }

    public static int getCurrentInc() {
        return _nextInc.get();
    }

    public static int _flip(int x2) {
        int z = 0;
        z |= x2 << 24 & 0xFF000000;
        z |= x2 << 8 & 0xFF0000;
        z |= x2 >> 8 & 0xFF00;
        return z |= x2 >> 24 & 0xFF;
    }

    static {
        try {
            int machinePiece;
            try {
                StringBuilder sb = new StringBuilder();
                Enumeration<NetworkInterface> e2 = NetworkInterface.getNetworkInterfaces();
                while (e2.hasMoreElements()) {
                    NetworkInterface ni = e2.nextElement();
                    sb.append(ni.toString());
                }
                machinePiece = sb.toString().hashCode() << 16;
            }
            catch (Throwable e3) {
                LOGGER.log(Level.WARNING, e3.getMessage(), e3);
                machinePiece = new Random().nextInt() << 16;
            }
            LOGGER.fine("machine piece post: " + Integer.toHexString(machinePiece));
            int processId = new Random().nextInt();
            try {
                processId = ManagementFactory.getRuntimeMXBean().getName().hashCode();
            }
            catch (Throwable t2) {
                // empty catch block
            }
            ClassLoader loader = ObjectId.class.getClassLoader();
            int loaderId = loader != null ? System.identityHashCode(loader) : 0;
            StringBuilder sb = new StringBuilder();
            sb.append(Integer.toHexString(processId));
            sb.append(Integer.toHexString(loaderId));
            int processPiece = sb.toString().hashCode() & 0xFFFF;
            LOGGER.fine("process piece: " + Integer.toHexString(processPiece));
            _genmachine = machinePiece | processPiece;
            LOGGER.fine("machine : " + Integer.toHexString(_genmachine));
        }
        catch (Exception e4) {
            throw new RuntimeException(e4);
        }
    }
}

