/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.variant.New;

import htsjdk.tribble.Feature;
import org.broad.igv.Globals;

public class Variant
implements Feature {
    String chr;
    int pos;
    String names;
    String referenceBases;
    String alternateBases;
    int quality;
    String filter;
    String info;
    int start;
    int end;
    String[] alleles;

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public String getContig() {
        return this.chr;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public String getValueString(int genomicPosition) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Chr: " + this.chr + "<br>");
        buffer.append("Pos: " + (this.pos + 1));
        if (this.names != null) {
            buffer.append("Names: " + this.names + "<br>");
        }
        buffer.append("Ref: " + this.alleles[0] + "<br>");
        if (this.alleles.length > 1) {
            for (int i2 = 1; i2 < this.alleles.length; ++i2) {
                buffer.append(this.alleles[i2]);
                if (i2 < this.alleles.length - 1) {
                    buffer.append(", ");
                }
                buffer.append("<br>");
            }
        }
        buffer.append("Quality: " + this.quality + "<br>");
        buffer.append("Filter: " + this.filter);
        if (this.info != null) {
            String[] infoFields;
            buffer.append("<hr>");
            for (String ifield : infoFields = Globals.semicolonPattern.split(this.info)) {
                buffer.append(ifield + "<br>");
            }
        }
        return buffer.toString();
    }
}

