/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CloseableIterator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.ChromosomeNameComparator;
import org.broad.igv.feature.genome.fasta.FastaIndexedSequence;
import org.broad.igv.sam.PicardAlignment;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.util.Interval;
import org.broad.igv.util.IntervalTree;
import org.broad.igv.util.ParsingUtils;

public class TutorialUtils {
    public static void main(String[] args) throws IOException {
        TutorialUtils.sliceFasta(args[0], args[1], args[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void extractFasta(String inputFasta, String outputFasta, String regionsFile) throws IOException {
        FastaIndexedSequence inFasta = new FastaIndexedSequence(inputFasta);
        List<Region> regions = TutorialUtils.parseRegions(new File(regionsFile));
        try (PrintWriter outFasta = null;){
            outFasta = new PrintWriter(new BufferedWriter(new FileWriter(outputFasta)));
            for (Region r2 : regions) {
                byte[] sequence = inFasta.getSequence(r2.chr, r2.start, r2.end, true);
                outFasta.println(">" + r2.name);
                outFasta.println(new String(sequence));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void extractAlignments(String inputFile, String outputFile, String regionsFile) throws IOException {
        AlignmentReader reader = AlignmentReaderFactory.getReader(inputFile, true);
        PrintWriter out = null;
        List<Region> regions = TutorialUtils.parseRegions(new File(regionsFile));
        HashMap<String, ArrayList<Region>> regionMap = new HashMap<String, ArrayList<Region>>();
        for (Region r2 : regions) {
            ArrayList<Region> rlist = (ArrayList<Region>)regionMap.get(r2.chr);
            if (rlist == null) {
                rlist = new ArrayList<Region>();
                regionMap.put(r2.chr, rlist);
            }
            rlist.add(r2);
        }
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            out.println("@HD VN:1.5 SO:coordinate");
            for (Region r2 : regions) {
                out.println("@SQ\tSN:" + r2.name + "\tLN:" + (r2.end - r2.start));
            }
            for (Region r2 : regions) {
                CloseableIterator iter = reader.query(r2.chr, r2.start, r2.end, false);
                while (iter.hasNext()) {
                    PicardAlignment alignment = (PicardAlignment)iter.next();
                    SAMRecord record = alignment.getRecord();
                    record.setReferenceName(r2.name);
                    record.setAlignmentStart(record.getAlignmentStart() - r2.start);
                    if (record.getReadPairedFlag() && !record.getMateUnmappedFlag()) {
                        if (record.getMateReferenceName().equals(record.getReferenceName())) {
                            record.setMateReferenceName(r2.name);
                            record.setMateAlignmentStart(record.getMateAlignmentStart() - r2.start);
                        } else {
                            String newMateChr = null;
                            List rlist = (List)regionMap.get(record.getMateReferenceName());
                            if (rlist != null) {
                                for (Region r22 : rlist) {
                                    if (!r22.contains(record.getMateAlignmentStart())) continue;
                                    newMateChr = r2.name;
                                    break;
                                }
                            }
                            if (newMateChr != null) {
                                record.setMateReferenceName(newMateChr);
                            } else {
                                record.setMateUnmappedFlag(true);
                            }
                        }
                    }
                    out.print(record.getSAMString());
                }
                iter.close();
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void extractFeatures(String inputFile, String outputFile, String regionsFile) throws IOException {
        PrintWriter out = null;
        List<Region> regions = TutorialUtils.parseRegions(new File(regionsFile));
        Map<String, IntervalTree<List<Feature>>> featureMap = TutorialUtils.loadFeatures(inputFile);
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            for (Region r2 : regions) {
                IntervalTree<List<Feature>> featureTree = featureMap.get(r2.chr);
                if (featureTree == null) continue;
                List<Interval<List<Feature>>> intervals = featureTree.findOverlapping(r2.start, r2.end);
                for (Interval<List<Feature>> interval : intervals) {
                    List<Feature> features = interval.getValue();
                    for (Feature f2 : features) {
                        if (f2.start < r2.start) continue;
                        String s2 = f2.tanslate(r2.name, r2.start);
                        out.println(s2);
                    }
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Region> parseRegions(File file) throws IOException {
        ArrayList<Region> regions = new ArrayList<Region>();
        try (BufferedReader reader = null;){
            String nextLine;
            reader = new BufferedReader(new FileReader(file));
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens;
                if (nextLine.startsWith("#") || (tokens = Globals.whitespacePattern.split(nextLine)).length <= 3) continue;
                regions.add(new Region(tokens[0], Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), tokens[3]));
            }
        }
        return regions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sliceVCF(String inputFile, String outputFile, String chr, int start, int end) throws IOException {
        BufferedReader reader = null;
        PrintWriter out = null;
        try {
            String nextLine;
            reader = ParsingUtils.openBufferedReader(inputFile);
            out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            while ((nextLine = reader.readLine()) != null) {
                if (nextLine.startsWith("#")) {
                    out.println(nextLine);
                    continue;
                }
                String[] tokens = Globals.tabPattern.split(nextLine);
                String c2 = tokens[0];
                if (!c2.equals(chr)) continue;
                int pos = Integer.parseInt(tokens[1]);
                if (pos >= start && pos <= end) {
                    out.println(nextLine);
                }
                if (pos <= end) continue;
                break;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sampleVCF(String inputFile, String outputFile, int n2) throws IOException {
        BufferedReader reader = null;
        PrintWriter out = null;
        try {
            String nextLine;
            reader = new BufferedReader(new FileReader(inputFile));
            out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            while ((nextLine = reader.readLine()) != null) {
                int i2;
                if (nextLine.startsWith("##")) {
                    out.println(nextLine);
                    continue;
                }
                String[] tokens = Globals.tabPattern.split(nextLine);
                for (i2 = 0; i2 < 9; ++i2) {
                    out.print(tokens[i2]);
                    if (i2 >= 8) continue;
                    out.print('\t');
                }
                for (i2 = 9; i2 < tokens.length; i2 += n2) {
                    if (i2 >= tokens.length) continue;
                    out.print('\t');
                    out.print(tokens[i2]);
                }
                out.println();
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sliceFasta(String inputFasta, String outputFasta, String chr) throws IOException {
        BufferedReader reader = null;
        try (PrintWriter outFasta = null;){
            String nextLine;
            reader = ParsingUtils.openBufferedReader(inputFasta);
            outFasta = new PrintWriter(new BufferedWriter(new FileWriter(outputFasta)));
            boolean chrFound = false;
            while ((nextLine = reader.readLine()) != null) {
                if (chrFound) {
                    if (nextLine.startsWith(">")) {
                        break;
                    }
                    outFasta.println(nextLine);
                    continue;
                }
                if (!nextLine.startsWith(">" + chr)) continue;
                outFasta.println(nextLine);
                chrFound = true;
            }
        }
    }

    private static Comparator<Feature> getPositionComparator() {
        Comparator<Feature> comp = new Comparator<Feature>(){
            private Comparator<String> nameComparator = ChromosomeNameComparator.get();

            @Override
            public int compare(Feature o1, Feature o2) {
                int nameComp = this.nameComparator.compare(o1.chr, o2.chr);
                if (nameComp == 0) {
                    return o1.start - o2.start;
                }
                return nameComp;
            }
        };
        return comp;
    }

    static Map<String, IntervalTree<List<Feature>>> loadFeatures(String file) throws IOException {
        String nextLine;
        BufferedReader reader = null;
        reader = ParsingUtils.openBufferedReader(file);
        String lastChr = null;
        ArrayList<Feature> currentFeatureList = new ArrayList<Feature>();
        int currentMin = Integer.MAX_VALUE;
        int currentMax = 0;
        HashMap<String, IntervalTree<List<Feature>>> map = new HashMap<String, IntervalTree<List<Feature>>>();
        ArrayList<Feature> features = new ArrayList<Feature>();
        while ((nextLine = reader.readLine()) != null) {
            if (nextLine.startsWith("#") || nextLine.startsWith("track") || nextLine.startsWith("browser")) continue;
            String[] tokens = Globals.whitespacePattern.split(nextLine);
            Feature f2 = new Feature(tokens);
            features.add(f2);
        }
        features.sort(TutorialUtils.getPositionComparator());
        for (Feature f2 : features) {
            IntervalTree tree;
            if (lastChr == null) {
                currentMin = f2.start;
                currentMax = f2.end;
                currentFeatureList.add(f2);
                tree = new IntervalTree();
                map.put(f2.chr, tree);
                lastChr = f2.chr;
                continue;
            }
            if (!f2.chr.equals(lastChr)) {
                tree = (IntervalTree)map.get(lastChr);
                tree.insert(new Interval(currentMin, currentMax, currentFeatureList));
                if (map.containsKey(f2.chr)) {
                    System.out.println();
                }
                tree = new IntervalTree();
                map.put(f2.chr, tree);
                lastChr = f2.chr;
                currentFeatureList = new ArrayList();
                currentFeatureList.add(f2);
                currentMin = f2.start;
                currentMax = f2.end;
                continue;
            }
            if (currentFeatureList.size() > 10) {
                tree = (IntervalTree)map.get(lastChr);
                tree.insert(new Interval(currentMin, currentMax, currentFeatureList));
                currentFeatureList = new ArrayList();
                currentFeatureList.add(f2);
                currentMin = f2.start;
                currentMax = f2.end;
                continue;
            }
            currentMin = Math.min(currentMin, f2.start);
            currentMax = Math.max(currentMax, f2.end);
            currentFeatureList.add(f2);
        }
        return map;
    }

    static class Feature {
        String chr;
        int start;
        int end;
        String[] tokens;

        Feature(String[] tokens) {
            this.chr = tokens[2];
            this.start = Integer.parseInt(tokens[4]);
            this.end = Integer.parseInt(tokens[5]);
            this.tokens = tokens;
        }

        boolean overlaps(String chr, int start, int end) {
            return chr.equals(this.chr) && end > this.start && start <= this.end;
        }

        String tanslate(String newChr, int offset) {
            String[] exonEnds;
            String[] exonStarts;
            this.tokens[2] = newChr;
            this.tokens[4] = String.valueOf(this.start - offset);
            this.tokens[5] = String.valueOf(this.end - offset);
            this.tokens[6] = String.valueOf(Integer.parseInt(this.tokens[6]) - offset);
            this.tokens[7] = String.valueOf(Integer.parseInt(this.tokens[7]) - offset);
            String newExonStart = "";
            for (String es : exonStarts = this.tokens[9].split(",")) {
                newExonStart = newExonStart + String.valueOf(Integer.parseInt(es) - offset) + ",";
            }
            this.tokens[9] = newExonStart;
            String newExonEnd = "";
            for (String es : exonEnds = this.tokens[10].split(",")) {
                newExonEnd = newExonEnd + String.valueOf(Integer.parseInt(es) - offset) + ",";
            }
            this.tokens[10] = newExonEnd;
            String record = this.tokens[0];
            for (int i2 = 1; i2 < this.tokens.length; ++i2) {
                record = record + "\t" + this.tokens[i2];
            }
            return record;
        }
    }

    static class Region {
        String chr;
        int start;
        int end;
        String name;

        public Region(String chr, int start, int end, String name) {
            this.end = end;
            this.chr = chr;
            this.start = start;
            this.name = name;
        }

        public boolean contains(int p2) {
            return p2 >= this.start && p2 <= this.end;
        }
    }
}

