/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.broad.igv.session.History;
import org.broad.igv.ui.IGV;

public class HistoryMenu
extends JMenu {
    static int MAX_ITEMS = 30;
    private JMenuItem backItem;
    private JMenuItem forwardItem;
    private JMenuItem clearAllItem;

    public HistoryMenu() {
        this("History");
    }

    public HistoryMenu(String name) {
        super(name);
        final History history = IGV.getInstance().getSession().getHistory();
        this.clearAllItem = new JMenuItem("Clear all");
        this.clearAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                history.clear();
            }
        });
        this.backItem = new JMenuItem("Back          Alt+Arrow");
        this.backItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                history.back();
            }
        });
        this.forwardItem = new JMenuItem("Forward     Alt+Arrow");
        this.forwardItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                history.forward();
            }
        });
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                History history = IGV.getInstance().getSession().getHistory();
                List<History.Entry> allLoci = IGV.getInstance().getSession().getAllHistory();
                boolean hasBack = history.peekBack() != null;
                boolean hasForward = history.peekForward() != null;
                HistoryMenu.this.backItem.setEnabled(hasBack);
                HistoryMenu.this.forwardItem.setEnabled(hasForward);
                HistoryMenu.this.clearAllItem.setEnabled(allLoci.size() > 0);
                HistoryMenu.this.removeAll();
                HistoryMenu.this.add(HistoryMenu.this.backItem);
                HistoryMenu.this.add(HistoryMenu.this.forwardItem);
                HistoryMenu.this.addSeparator();
                int nItems = 0;
                for (int idx = allLoci.size() - 1; idx >= 0; --idx) {
                    final History.Entry s2 = allLoci.get(idx);
                    JMenuItem item = new JMenuItem(s2.toString());
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            IGV.getInstance().getSession().getHistory().processItem(s2);
                        }
                    });
                    HistoryMenu.this.add(item);
                    if (nItems++ > MAX_ITEMS) break;
                }
                HistoryMenu.this.addSeparator();
                HistoryMenu.this.add(HistoryMenu.this.clearAllItem);
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
    }
}

