/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.dnd.AbstractGhostDropManager;
import org.broad.igv.ui.dnd.GhostDropEvent;
import org.broad.igv.ui.dnd.GhostDropListener;
import org.broad.igv.ui.dnd.GhostGlassPane;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelComponent;
import org.broad.igv.ui.util.UIUtilities;
import org.jdesktop.layout.GroupLayout;

public class TrackNamePanel
extends TrackPanelComponent
implements Paintable {
    private static Logger log = Logger.getLogger(TrackNamePanel.class);
    List<GroupExtent> groupExtents = new ArrayList<GroupExtent>();
    BufferedImage dndImage = null;
    TrackGroup selectedGroup = null;
    boolean showGroupNames = true;
    boolean showSampleNamesWhenGrouped = false;
    static List<DropListener> dropListeners = new ArrayList<DropListener>();

    public TrackNamePanel(TrackPanel trackPanel) {
        super(trackPanel);
        this.init();
    }

    Collection<TrackGroup> getGroups() {
        return this.getTrackPanel().getGroups();
    }

    private boolean isGrouped() {
        return this.getGroups().size() > 1;
    }

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (PreferencesManager.getPreferences().getAsBoolean("ENABLE_ANTIALIASING")) {
            ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.removeMousableRegions();
        Rectangle visibleRect = this.getVisibleRect();
        this.paintImpl(g2, visibleRect);
    }

    @Override
    public void paintOffscreen(Graphics2D g2, Rectangle rect) {
        g2.setColor(Color.white);
        g2.fill(rect);
        this.paintImpl(g2, rect);
        Color c2 = g2.getColor();
        g2.setColor(Color.darkGray);
        g2.drawRect(rect.x, rect.y, rect.width, rect.height);
        g2.setColor(c2);
    }

    private void paintImpl(Graphics g2, Rectangle visibleRect) {
        boolean isGrouped;
        Collection<TrackGroup> groups = this.getGroups();
        boolean bl = isGrouped = groups.size() > 1;
        if (!groups.isEmpty()) {
            Graphics2D graphics2D = (Graphics2D)g2;
            graphics2D.setColor(Color.BLACK);
            Graphics2D greyGraphics = (Graphics2D)g2.create();
            greyGraphics.setColor(UIConstants.LIGHT_GREY);
            int regionY = 0;
            this.groupExtents.clear();
            for (TrackGroup group : groups) {
                if ((double)regionY > visibleRect.getMaxY()) break;
                if (!group.isVisible()) continue;
                if (isGrouped) {
                    if (regionY + 10 >= visibleRect.y && (double)regionY < visibleRect.getMaxY()) {
                        greyGraphics.fillRect(0, regionY + 1, this.getWidth(), 9);
                    }
                    regionY += 10;
                }
                if (group.isDrawBorder() && regionY + 10 >= visibleRect.y && (double)regionY < visibleRect.getMaxY()) {
                    g2.drawLine(0, regionY - 1, this.getWidth(), regionY - 1);
                }
                int h2 = group.getHeight();
                Rectangle groupRect = new Rectangle(visibleRect.x, regionY, visibleRect.width, h2);
                Rectangle displayableRect = this.getDisplayableRect(groupRect, visibleRect);
                regionY = this.printTrackNames(group, displayableRect, visibleRect, graphics2D, 0, regionY);
                if (isGrouped) {
                    this.groupExtents.add(new GroupExtent(group, groupRect.y, groupRect.y + groupRect.height));
                    if (this.showGroupNames) {
                        group.renderName(graphics2D, displayableRect, group == this.selectedGroup);
                    }
                }
                if (!group.isDrawBorder()) continue;
                g2.drawLine(0, regionY, this.getWidth(), regionY);
            }
            graphics2D.dispose();
            greyGraphics.dispose();
        }
    }

    private Rectangle getDisplayableRect(Rectangle trackRectangle, Rectangle visibleRect) {
        Rectangle rect = null;
        if (visibleRect != null) {
            Rectangle intersectedRect = trackRectangle.intersection(visibleRect);
            rect = intersectedRect.height > 15 ? intersectedRect : new Rectangle(trackRectangle);
        }
        return rect;
    }

    private int printTrackNames(TrackGroup group, Rectangle visibleRect, Rectangle clipRect, Graphics2D graphics2D, int regionX, int regionY) {
        ArrayList<Track> tmp = new ArrayList<Track>(group.getVisibleTracks());
        Color backgroundColor = PreferencesManager.getPreferences().getAsColor("BACKGROUND_COLOR");
        graphics2D.setBackground(backgroundColor);
        graphics2D.clearRect(visibleRect.x, visibleRect.y, visibleRect.width, visibleRect.height);
        for (Track track : tmp) {
            if (track == null) continue;
            track.setY(regionY);
            int trackHeight = track.getHeight();
            if (!track.isVisible()) continue;
            if (regionY + trackHeight >= clipRect.y && (double)regionY < clipRect.getMaxY()) {
                int width = this.getWidth();
                int height = track.getHeight();
                Rectangle region = new Rectangle(regionX, regionY, width, height);
                this.addMousableRegion(new MouseableRegion(region, track));
                if (!this.isGrouped() || this.showSampleNamesWhenGrouped) {
                    Rectangle rect = new Rectangle(regionX, regionY, width, height);
                    if (track.isSelected()) {
                        graphics2D.setBackground(Color.LIGHT_GRAY);
                        graphics2D.clearRect(rect.x, rect.y, rect.width, rect.height);
                    } else {
                        graphics2D.setBackground(backgroundColor);
                    }
                    Graphics2D trackGraphics = (Graphics2D)graphics2D.create();
                    track.renderName(trackGraphics, rect, visibleRect);
                    trackGraphics.dispose();
                }
            }
            regionY += trackHeight;
        }
        return regionY;
    }

    private void init() {
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setBackground(new Color(255, 255, 255));
        GroupLayout dataTrackNamePanelLayout = new GroupLayout(this);
        this.setLayout(dataTrackNamePanelLayout);
        dataTrackNamePanelLayout.setHorizontalGroup(dataTrackNamePanelLayout.createParallelGroup(1).add(0, 148, Short.MAX_VALUE));
        dataTrackNamePanelLayout.setVerticalGroup(dataTrackNamePanelLayout.createParallelGroup(1).add(0, 528, Short.MAX_VALUE));
        NamePanelMouseAdapter mouseAdapter = new NamePanelMouseAdapter();
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        DropListener dndListener = new DropListener(this);
        TrackNamePanel.addGhostDropListener(dndListener);
    }

    @Override
    protected void openPopupMenu(TrackClickEvent te) {
        ArrayList<Component> extraItems = null;
        if (this.isGrouped()) {
            extraItems = new ArrayList<Component>();
            final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show group names");
            item.setSelected(this.showGroupNames);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    TrackNamePanel.this.showGroupNames = item.isSelected();
                    TrackNamePanel.this.repaint();
                }
            });
            extraItems.add(item);
            final JCheckBoxMenuItem item2 = new JCheckBoxMenuItem("Show sample names");
            item2.setSelected(this.showSampleNamesWhenGrouped);
            item2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    TrackNamePanel.this.showSampleNamesWhenGrouped = item2.isSelected();
                    TrackNamePanel.this.repaint();
                }
            });
            extraItems.add(item2);
        }
        super.openPopupMenu(te, extraItems);
    }

    public String getTooltipTextForLocation(int x2, int y) {
        List<MouseableRegion> mouseableRegions = this.getMouseRegions();
        String text = null;
        for (MouseableRegion mouseableRegion : mouseableRegions) {
            if (!mouseableRegion.containsPoint(x2, y)) continue;
            Set<Track> tracks = mouseableRegion.getTracks();
            if (tracks != null && tracks.size() == 1) {
                Track track = (Track)tracks.iterator().next();
                text = track.getNameValueString(y);
                break;
            }
            text = mouseableRegion.getText();
            break;
        }
        return text;
    }

    private synchronized void createDnDImage() {
        this.dndImage = new BufferedImage(this.getWidth(), 2, 2);
        Graphics g2 = this.dndImage.getGraphics();
        g2.setColor(Color.blue);
        g2.drawLine(1, 0, this.getWidth() - 2, 0);
        g2.drawLine(1, 1, this.getWidth() - 2, 1);
    }

    protected void shiftSelectTracks(MouseEvent e2) {
        for (MouseableRegion mouseRegion : this.mouseRegions) {
            if (!mouseRegion.containsPoint(e2.getX(), e2.getY())) continue;
            Set<Track> clickedTracks = mouseRegion.getTracks();
            if (clickedTracks != null && clickedTracks.size() > 0) {
                Track t2 = (Track)clickedTracks.iterator().next();
                IGV.getInstance().shiftSelectTracks(t2);
            }
            return;
        }
    }

    private TrackGroup getGroup(int y) {
        for (GroupExtent ge : this.groupExtents) {
            if (!ge.contains(y)) continue;
            return ge.group;
        }
        return null;
    }

    private void selectGroup(TrackGroup group) {
        this.selectedGroup = group;
        if (this.selectedGroup != null) {
            for (Track t2 : this.selectedGroup.getVisibleTracks()) {
                t2.setSelected(true);
            }
        }
    }

    int getGroupGapNumber(int y) {
        for (int i2 = 0; i2 < this.groupExtents.size(); ++i2) {
            if (!this.groupExtents.get(i2).isAfter(y)) continue;
            return i2;
        }
        return this.groupExtents.size();
    }

    private static void addGhostDropListener(DropListener listener) {
        if (listener != null) {
            dropListeners.add(listener);
        }
    }

    public static void removeDropListenerFor(TrackNamePanel panel) {
        ArrayList<DropListener> removeThese = new ArrayList<DropListener>();
        for (DropListener dl : dropListeners) {
            if (dl.panel != panel) continue;
            removeThese.add(dl);
        }
        dropListeners.removeAll(removeThese);
    }

    class GroupExtent {
        TrackGroup group;
        int minY;
        int maxY;

        GroupExtent(TrackGroup group, int minY, int maxY) {
            this.group = group;
            this.maxY = maxY;
            this.minY = minY;
        }

        boolean contains(int y) {
            return y > this.minY && y <= this.maxY;
        }

        boolean isAfter(int y) {
            return this.minY > y;
        }
    }

    class DropListener
    extends AbstractGhostDropManager {
        TrackNamePanel panel;

        public DropListener(TrackNamePanel target) {
            super(target);
            this.panel = target;
        }

        @Override
        public void ghostDropped(GhostDropEvent e2) {
            boolean isInTarget;
            Point startPoint = e2.getStartLocation();
            Point dropPoint = this.getTranslatedPoint(e2.getDropLocation());
            Rectangle bounds = this.component.getVisibleRect();
            boolean bl = isInTarget = dropPoint.y > bounds.y && (double)dropPoint.y < bounds.getMaxY();
            if (isInTarget) {
                this.tracksDropped(startPoint, dropPoint, e2.getTracks());
                e2.removeTracksFromSource();
                e2.setTracksDropped(true);
            } else {
                TrackPanel view = (TrackPanel)TrackNamePanel.this.getParent();
                if (e2.isTracksDropped()) {
                    view.removeTracks(e2.getTracks());
                } else {
                    e2.addSourcePanel(view);
                }
            }
        }

        void tracksDropped(Point startPoint, Point dropPoint, List<Track> tracks) {
            TrackPanel panel = (TrackPanel)TrackNamePanel.this.getParent();
            List<MouseableRegion> regions = TrackNamePanel.this.getMouseRegions();
            if (regions.isEmpty()) {
                panel.addTracks(tracks);
            } else {
                Iterator<Track> tmp;
                boolean before = true;
                MouseableRegion dropRegion = null;
                MouseableRegion startRegion = null;
                for (MouseableRegion region : regions) {
                    if (region.containsPoint(dropPoint.x, dropPoint.y)) {
                        dropRegion = region;
                        Rectangle bnds = dropRegion.getBounds();
                        int dy1 = dropPoint.y - bnds.y;
                        int dy2 = bnds.height - dy1;
                        boolean bl = before = dy1 < dy2;
                    }
                    if (region.containsPoint(startPoint.x, startPoint.y)) {
                        startRegion = region;
                    }
                    if (dropRegion == null || startRegion == null) continue;
                    break;
                }
                Track dropTrack = null;
                if (dropRegion != null && (tmp = dropRegion.getTracks().iterator()).hasNext()) {
                    dropTrack = tmp.next();
                }
                panel.moveSelectedTracksTo(tracks, dropTrack, before);
            }
        }
    }

    class NamePanelMouseAdapter
    extends MouseInputAdapter {
        boolean isDragging = false;
        List<Track> dragTracks = new ArrayList<Track>();
        Point dragStart = null;

        NamePanelMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            this.dragStart = e2.getPoint();
            TrackNamePanel.this.requestFocus();
            TrackNamePanel.this.grabFocus();
            boolean isGrouped = TrackNamePanel.this.isGrouped();
            if (e2.isPopupTrigger()) {
                if (isGrouped) {
                    TrackNamePanel.this.clearTrackSelections();
                    TrackGroup g2 = TrackNamePanel.this.getGroup(e2.getY());
                    if (null == g2 || g2 == TrackNamePanel.this.selectedGroup) {
                        TrackNamePanel.this.selectedGroup = null;
                    } else {
                        TrackNamePanel.this.selectGroup(g2);
                    }
                } else if (!TrackNamePanel.this.isTrackSelected(e2)) {
                    TrackNamePanel.this.clearTrackSelections();
                    TrackNamePanel.this.selectTracks(e2);
                }
                TrackClickEvent te = new TrackClickEvent(e2, null);
                TrackNamePanel.this.openPopupMenu(te);
            } else if (e2.getButton() == 1) {
                if (isGrouped) {
                    TrackNamePanel.this.clearTrackSelections();
                    TrackGroup g3 = TrackNamePanel.this.getGroup(e2.getY());
                    if (g3 == TrackNamePanel.this.selectedGroup) {
                        TrackNamePanel.this.selectedGroup = null;
                    } else {
                        TrackNamePanel.this.selectGroup(TrackNamePanel.this.getGroup(e2.getY()));
                    }
                } else if (e2.isMetaDown() || e2.isControlDown()) {
                    TrackNamePanel.this.toggleTrackSelections(e2);
                } else if (e2.isShiftDown()) {
                    TrackNamePanel.this.shiftSelectTracks(e2);
                } else if (!TrackNamePanel.this.isTrackSelected(e2)) {
                    TrackNamePanel.this.clearTrackSelections();
                    TrackNamePanel.this.selectTracks(e2);
                }
            } else if (!isGrouped && !TrackNamePanel.this.isTrackSelected(e2)) {
                TrackNamePanel.this.clearTrackSelections();
                TrackNamePanel.this.selectTracks(e2);
            }
            IGV.getInstance().repaintNamePanels();
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (log.isTraceEnabled()) {
                log.trace("Enter mouseReleased");
            }
            if (this.isDragging) {
                Component c2 = e2.getComponent();
                IGV.getInstance().endDnD();
                GhostGlassPane glassPane = IGV.getInstance().getDnDGlassPane();
                Point p2 = (Point)e2.getPoint().clone();
                SwingUtilities.convertPointToScreen(p2, c2);
                Point eventPoint = (Point)p2.clone();
                SwingUtilities.convertPointFromScreen(p2, glassPane);
                glassPane.setPoint(p2);
                glassPane.setVisible(false);
                glassPane.setImage(null);
                this.fireGhostDropEvent(new GhostDropEvent(this.dragStart, eventPoint, this.dragTracks));
                if (TrackNamePanel.this.selectedGroup != null) {
                    int idx = TrackNamePanel.this.getGroupGapNumber(e2.getY());
                    TrackPanel dataTrackView = (TrackPanel)TrackNamePanel.this.getParent();
                    dataTrackView.moveGroup(TrackNamePanel.this.selectedGroup, idx);
                    dataTrackView.repaint();
                }
                TrackNamePanel.this.selectedGroup = null;
            }
            if (e2.isPopupTrigger()) {
                TrackClickEvent te = new TrackClickEvent(e2, null);
                TrackNamePanel.this.openPopupMenu(te);
            } else if (!(this.isDragging || e2.isMetaDown() || e2.isControlDown() || e2.isShiftDown())) {
                TrackNamePanel.this.clearTrackSelections();
                TrackNamePanel.this.selectTracks(e2);
                IGV.getInstance().repaintNamePanels();
            }
            this.isDragging = false;
            this.dragTracks.clear();
            TrackNamePanel.this.dndImage = null;
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            Component c2 = e2.getComponent();
            if (e2.isPopupTrigger()) {
                return;
            }
            if (!this.isDragging) {
                if (this.dragStart == null) {
                    this.dragStart = e2.getPoint();
                    return;
                }
                if (e2.getPoint().distance(this.dragStart) < 5.0) {
                    return;
                }
                this.dragStart.x = TrackNamePanel.this.getWidth() / 2;
                IGV.getInstance().startDnD();
                if (TrackNamePanel.this.dndImage == null) {
                    TrackNamePanel.this.createDnDImage();
                }
                IGV.getInstance().getDnDGlassPane().setImage(TrackNamePanel.this.dndImage);
                this.isDragging = true;
                this.dragTracks.clear();
                this.dragTracks.addAll(IGV.getInstance().getSelectedTracks());
                TrackNamePanel.this.selectedGroup = TrackNamePanel.this.getGroups().size() > 0 ? TrackNamePanel.this.getGroup(e2.getY()) : null;
            }
            if (this.isDragging) {
                final GhostGlassPane glassPane = IGV.getInstance().getDnDGlassPane();
                Point p2 = (Point)e2.getPoint().clone();
                p2.x = TrackNamePanel.this.getWidth() / 2;
                SwingUtilities.convertPointToScreen(p2, c2);
                SwingUtilities.convertPointFromScreen(p2, glassPane);
                glassPane.setPoint(p2);
                UIUtilities.invokeOnEventThread(new Runnable(){

                    @Override
                    public void run() {
                        Rectangle bounds = new Rectangle(TrackNamePanel.this.getBounds());
                        bounds.height = 10000;
                        glassPane.paintImmediately(bounds);
                    }
                });
            }
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            int x2 = e2.getX();
            int y = e2.getY();
            TrackNamePanel.this.setToolTipText(TrackNamePanel.this.getTooltipTextForLocation(x2, y));
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            for (MouseableRegion mouseRegion : TrackNamePanel.this.mouseRegions) {
                Iterator<Track> iterator;
                if (!mouseRegion.containsPoint(e2.getX(), e2.getY()) || !(iterator = mouseRegion.getTracks().iterator()).hasNext()) continue;
                Track t2 = iterator.next();
                t2.handleNameClick(e2);
                return;
            }
        }

        protected void fireGhostDropEvent(GhostDropEvent evt) {
            Iterator<DropListener> it = dropListeners.iterator();
            while (it.hasNext()) {
                ((GhostDropListener)it.next()).ghostDropped(evt);
            }
        }
    }
}

