/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.InsertionManager;
import org.broad.igv.sam.InsertionMarker;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.panel.ReferenceFrame;

public class DataPanelPainter {
    private static Logger log = Logger.getLogger(DataPanelPainter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void paint(Collection<TrackGroup> groups, RenderContext context, int width, Color background, Rectangle visibleRect) {
        Graphics2D graphics2D = context.getGraphics2D("BACKGROUND");
        graphics2D.setBackground(background);
        graphics2D.clearRect(visibleRect.x, visibleRect.y, visibleRect.width, visibleRect.height);
        graphics2D.setColor(Color.BLACK);
        ReferenceFrame referenceFrame = context.getReferenceFrame();
        context.setInsertionMarkers(InsertionManager.getInstance().getInsertions(referenceFrame.getChrName(), referenceFrame.getOrigin(), referenceFrame.getEnd()));
        InsertionMarker i2 = InsertionManager.getInstance().getSelectedInsertion(referenceFrame.getChrName());
        if (i2 != null) {
            double start = referenceFrame.getOrigin();
            try {
                double scale = referenceFrame.getScale();
                int p0 = 0;
                int w2 = (int)(((double)i2.position - start) / scale);
                this.paintSection(groups, context, p0, visibleRect.y, w2, visibleRect.height, 0);
                i2.pixelPosition = p0 + w2;
                p0 += w2;
                context.multiframe = true;
                referenceFrame.origin = i2.position;
                w2 = (int)Math.ceil((double)i2.size / context.getScale());
                this.paintExpandedInsertion(i2, groups, context, p0, visibleRect.y, w2, visibleRect.height);
                int g2 = (int)((double)i2.size / scale);
                context.getReferenceFrame().origin = i2.position;
                w2 = width - (p0 += g2);
                if (w2 <= 0) return;
                this.paintSection(groups, context, p0, visibleRect.y, width - p0, visibleRect.height, g2);
                return;
            }
            finally {
                referenceFrame.origin = start;
            }
        } else {
            this.paintFrame(groups, context, width, visibleRect);
        }
    }

    private void paintSection(Collection<TrackGroup> groups, RenderContext context, int px, int py, int w2, int h2, int delta) {
        context.clearGraphicsCache();
        Graphics2D dG = context.getGraphics();
        Rectangle dRect = new Rectangle(0, py, w2, h2);
        dG.translate(delta, 0);
        dG.setClip(dRect);
        context.translateX = px;
        this.paintFrame(groups, context, w2, dRect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintFrame(Collection<TrackGroup> groups, RenderContext dContext, int width, Rectangle dRect) {
        int trackX = 0;
        int trackY = 0;
        for (TrackGroup group : groups) {
            List<Track> trackList;
            if (dRect != null && trackY > dRect.y + dRect.height) break;
            if (!group.isVisible()) continue;
            if (groups.size() > 1) {
                Graphics2D greyGraphics = dContext.getGraphic2DForColor(UIConstants.LIGHT_GREY);
                greyGraphics.fillRect(0, trackY + 1, width, 9);
                trackY += 10;
            }
            if (group.isDrawBorder()) {
                Graphics2D graphics2D = dContext.getGraphic2DForColor(Color.black);
                graphics2D.drawLine(0, trackY - 1, width, trackY - 1);
            }
            List<Track> list = trackList = group.getVisibleTracks();
            synchronized (list) {
                for (Track track : trackList) {
                    if (track == null) continue;
                    int trackHeight = track.getHeight();
                    if (dRect != null) {
                        if (trackY > dRect.y + dRect.height) break;
                        if (trackY + trackHeight < dRect.y) {
                            if (!track.isVisible()) continue;
                            trackY += trackHeight;
                            continue;
                        }
                    }
                    if (!track.isVisible()) continue;
                    Rectangle rect = new Rectangle(trackX, trackY, width, trackHeight);
                    this.draw(track, rect, dContext);
                    trackY += trackHeight;
                }
            }
            if (!group.isDrawBorder()) continue;
            Graphics2D graphics2D = dContext.getGraphic2DForColor(Color.black);
            graphics2D.drawLine(0, trackY, width, trackY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintExpandedInsertion(InsertionMarker insertionMarker, Collection<TrackGroup> groups, RenderContext context, int px, int py, int w2, int h2) {
        context.clearGraphicsCache();
        Graphics2D dG = context.getGraphics();
        Rectangle dRect = new Rectangle(0, py, w2, h2);
        dG.translate(px, 0);
        dG.setClip(dRect);
        context.translateX = px;
        int trackY = 0;
        for (TrackGroup group : groups) {
            List<Track> trackList;
            if (!group.isVisible()) continue;
            List<Track> list = trackList = group.getVisibleTracks();
            synchronized (list) {
                for (Track track : trackList) {
                    if (track == null) continue;
                    int trackHeight = track.getHeight();
                    if (dRect != null) {
                        if (trackY > dRect.y + dRect.height) break;
                        if (trackY + trackHeight < dRect.y) {
                            if (!track.isVisible()) continue;
                            trackY += trackHeight;
                            continue;
                        }
                    }
                    if (track instanceof AlignmentTrack && track.isVisible()) {
                        Rectangle rect = new Rectangle(dRect.x, trackY, dRect.width, trackHeight);
                        ((AlignmentTrack)track).renderExpandedInsertion(insertionMarker, context, rect);
                    }
                    if (!track.isVisible()) continue;
                    trackY += trackHeight;
                }
            }
        }
    }

    private final void draw(Track track, Rectangle rect, RenderContext context) {
        track.render(context, rect);
        List<Track> overlayTracks = IGV.getInstance().getOverlayTracks(track);
        if (overlayTracks != null) {
            for (Track overlayTrack : overlayTracks) {
                if (overlayTrack == track) continue;
                overlayTrack.overlay(context, rect);
            }
        }
    }
}

