/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.gs.GSFileBrowser;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MessageUtils;

public class LoadGenomeFromGSMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(LoadGenomeFromGSMenuAction.class);
    IGV igv;

    public LoadGenomeFromGSMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
        this.setToolTipText("Load genome from GenomeSpace");
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        try {
            GSFileBrowser dlg = new GSFileBrowser(IGV.getMainFrame());
            dlg.setVisible(true);
            String url = dlg.getFileURL();
            if (url != null) {
                GenomeManager.getInstance().loadGenome(url, null);
            }
        }
        catch (Exception e1) {
            log.error("Error fetching directory listing on GenomeSpace server.", e1);
            MessageUtils.showMessage("Error fetching directory listing on GenomeSpace server: " + e1.getMessage());
        }
    }
}

