/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.Globals;
import org.broad.igv.feature.Strand;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.Gap;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SAMAlignment;
import org.broad.igv.track.WindowFunction;

public class LinkedAlignment
implements Alignment {
    final String tag;
    final String name;
    String haplotype;
    String sample;
    String readGroup;
    String library;
    String chr;
    Strand strand;
    int alignmentStart;
    int alignmentEnd;
    List<Alignment> alignments;
    Map<String, Object> attributes = new HashMap<String, Object>();
    static final Comparator<Alignment> ALIGNMENT_START_COMPARATOR = new Comparator<Alignment>(){

        @Override
        public int compare(Alignment o1, Alignment o2) {
            return o1.getAlignmentStart() - o2.getAlignmentStart();
        }
    };

    public LinkedAlignment(String tag, String bc) {
        this.tag = tag;
        this.name = bc;
        this.attributes.put(tag, this.name);
        this.alignments = new ArrayList<Alignment>();
    }

    public void addAlignment(Alignment alignment) {
        String sample = alignment.getSample();
        String readGroup = alignment.getReadGroup();
        String library = alignment.getLibrary();
        if (this.alignments.isEmpty()) {
            this.chr = alignment.getChr();
            this.alignmentStart = alignment.getAlignmentStart();
            this.alignmentEnd = alignment.getAlignmentEnd();
            Object hp = alignment.getAttribute("HP");
            this.haplotype = hp == null ? null : hp.toString();
            this.strand = alignment.getReadStrand();
            this.sample = sample == null ? "" : sample;
            this.readGroup = readGroup == null ? "" : readGroup;
            this.library = library == null ? "" : library;
        } else {
            if (!this.chr.equals(alignment.getChr())) {
                throw new RuntimeException("Mixed chromosome linked alignments not supported");
            }
            this.alignmentStart = Math.min(alignment.getAlignmentStart(), this.alignmentStart);
            this.alignmentEnd = Math.max(alignment.getAlignmentEnd(), this.alignmentEnd);
            Object hp = alignment.getAttribute("HP");
            if (hp != null && !hp.toString().equals(this.haplotype)) {
                this.haplotype = "MIXED";
            }
            if (this.strand != alignment.getReadStrand()) {
                this.strand = Strand.NONE;
            }
            if (!this.sample.equals(sample)) {
                this.sample = this.sample + ", " + sample;
            }
            if (!this.readGroup.equals(readGroup)) {
                this.readGroup = this.readGroup + ", " + readGroup;
            }
            if (!this.library.equals(library)) {
                this.library = this.library + ", " + library;
            }
        }
        this.alignments.add(alignment);
    }

    public Strand getStrand() {
        return this.strand;
    }

    public Strand getStrandAtPosition(double position) {
        if (this.strand == Strand.NONE) {
            for (Alignment a2 : this.alignments) {
                if (!a2.contains(position)) continue;
                return a2.getReadStrand();
            }
        }
        return this.strand;
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public int getAlignmentStart() {
        return this.alignmentStart;
    }

    @Override
    public int getAlignmentEnd() {
        return this.alignmentEnd;
    }

    @Override
    public int getStart() {
        return this.alignmentStart;
    }

    @Override
    public int getEnd() {
        return this.alignmentEnd;
    }

    @Override
    public boolean contains(double location) {
        return location >= (double)this.alignmentStart && location <= (double)this.alignmentEnd;
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public String getValueString(double position, int mouseX, WindowFunction windowFunction) {
        if (this.alignments.size() == 1) {
            return this.alignments.get(0).getValueString(position, mouseX, windowFunction);
        }
        for (Alignment a2 : this.alignments) {
            for (AlignmentBlock block : a2.getInsertions()) {
                if (!block.containsPixel(mouseX)) continue;
                return a2.getValueString(position, mouseX, windowFunction);
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Linking id (" + this.tag + ") = " + this.name);
        if (this.haplotype != null) {
            buffer.append("<br>Haplotype = " + this.haplotype);
        }
        buffer.append("<br># alignments = " + this.alignments.size());
        buffer.append("<br>Total span = " + Globals.DECIMAL_FORMAT.format(this.getAlignmentEnd() - this.getAlignmentStart()) + "bp");
        if ("READNAME".equals(this.tag)) {
            buffer.append("<br>Strands = ");
            for (Alignment a3 : this.alignments) {
                buffer.append(a3.getReadStrand() == Strand.POSITIVE ? "+" : "-");
            }
            for (Alignment a3 : this.alignments) {
                if (!(a3 instanceof SAMAlignment)) continue;
                buffer.append("<br>");
                buffer.append(((SAMAlignment)a3).getSynopsisString());
            }
        }
        for (Alignment a3 : this.alignments) {
            if (!a3.contains(position)) continue;
            buffer.append("<hr>");
            buffer.append(a3.getValueString(position, mouseX, windowFunction));
        }
        return buffer.toString();
    }

    @Override
    public Object getAttribute(String key) {
        if ("HP".equals(key)) {
            return this.haplotype;
        }
        return this.attributes.get(key);
    }

    @Override
    public int getMappingQuality() {
        return 30;
    }

    @Override
    public String getReadName() {
        return "READNAME".equals(this.tag) ? this.name : null;
    }

    @Override
    public String getReadSequence() {
        return null;
    }

    @Override
    public AlignmentBlock[] getAlignmentBlocks() {
        return null;
    }

    @Override
    public AlignmentBlock[] getInsertions() {
        int n2 = 0;
        for (Alignment a2 : this.alignments) {
            n2 += a2.getInsertions().length;
        }
        AlignmentBlock[] insertions = new AlignmentBlock[n2];
        n2 = 0;
        for (Alignment a3 : this.alignments) {
            AlignmentBlock[] blocks = a3.getInsertions();
            System.arraycopy(blocks, 0, insertions, n2, blocks.length);
            n2 += blocks.length;
        }
        return insertions;
    }

    @Override
    public String getCigarString() {
        return null;
    }

    @Override
    public List<Gap> getGaps() {
        return null;
    }

    @Override
    public int getInferredInsertSize() {
        return 0;
    }

    @Override
    public ReadMate getMate() {
        return null;
    }

    @Override
    public Strand getReadStrand() {
        return null;
    }

    @Override
    public boolean isProperPair() {
        return false;
    }

    @Override
    public boolean isPaired() {
        return false;
    }

    @Override
    public boolean isFirstOfPair() {
        return false;
    }

    @Override
    public boolean isSecondOfPair() {
        return false;
    }

    @Override
    public boolean isNegativeStrand() {
        return this.strand == Strand.NEGATIVE;
    }

    @Override
    public boolean isDuplicate() {
        return false;
    }

    @Override
    public boolean isPrimary() {
        return false;
    }

    @Override
    public boolean isSupplementary() {
        return false;
    }

    @Override
    public byte getBase(double position) {
        byte base = 0;
        for (Alignment al : this.alignments) {
            if (!al.contains(position)) continue;
            byte b2 = al.getBase(position);
            if (base == 0) {
                base = b2;
                continue;
            }
            if (base == b2) continue;
            base = 0;
            break;
        }
        return base;
    }

    @Override
    public byte getPhred(double position) {
        return 0;
    }

    @Override
    public void setMateSequence(String sequence) {
    }

    @Override
    public String getPairOrientation() {
        return null;
    }

    @Override
    public Strand getFirstOfPairStrand() {
        return null;
    }

    @Override
    public Strand getSecondOfPairStrand() {
        return null;
    }

    @Override
    public boolean isVendorFailedRead() {
        return false;
    }

    @Override
    public Color getYcColor() {
        return null;
    }

    @Override
    public String getSample() {
        return this.sample;
    }

    @Override
    public String getReadGroup() {
        return null;
    }

    @Override
    public String getLibrary() {
        return null;
    }

    @Override
    public String getClipboardString(double location, int mouseX) {
        return null;
    }

    @Override
    public void finish() {
        this.alignments.sort(ALIGNMENT_START_COMPARATOR);
    }

    @Override
    public void setStart(int start) {
    }

    @Override
    public void setEnd(int end) {
    }

    @Override
    public float getScore() {
        return 0.0f;
    }

    @Override
    public String getContig() {
        return null;
    }
}

