/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gs.dm;

import biz.source_code.base64Coder.Base64Coder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.broad.igv.gs.dm.GSDirectoryListing;
import org.broad.igv.gs.dm.GSFileMetadata;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.util.HttpUtils;

public class DMUtils {
    private static Logger log = Logger.getLogger(DMUtils.class);
    private static final String UPLOAD_SERVICE = "uploadurl";
    public static final String DEFAULT_DIRECTORY = "defaultdirectory";
    public static final String PERSONAL_DIRECTORY = "personaldirectory";

    public static GSDirectoryListing getDirectoryListing(URL directoryURL) throws IOException {
        String str = HttpUtils.getInstance().getContentsAsJSON(directoryURL);
        JsonParser parser = new JsonParser();
        JsonObject obj = parser.parse(str).getAsJsonObject();
        JsonObject directory = obj.get("directory").getAsJsonObject();
        String dirUrlString = directory.get("url").getAsString();
        LinkedList<GSFileMetadata> elements = new LinkedList<GSFileMetadata>();
        if (obj.has("contents")) {
            JsonElement c2 = obj.get("contents");
            ArrayList<JsonObject> contents = new ArrayList<JsonObject>();
            if (c2 instanceof JsonObject) {
                contents.add((JsonObject)c2);
            } else {
                JsonArray tmp = (JsonArray)c2;
                int l2 = tmp.size();
                for (int i2 = 0; i2 < l2; ++i2) {
                    contents.add((JsonObject)tmp.get(i2));
                }
            }
            ArrayList<GSFileMetadata> dirElements = new ArrayList<GSFileMetadata>();
            ArrayList<GSFileMetadata> fileElements = new ArrayList<GSFileMetadata>();
            int contentsLength = contents.size();
            for (int i3 = 0; i3 < contentsLength; ++i3) {
                JsonObject o2 = (JsonObject)contents.get(i3);
                GSFileMetadata metaData = GSFileMetadata.deserializeElement(o2);
                if (metaData.isDirectory()) {
                    dirElements.add(metaData);
                    continue;
                }
                fileElements.add(metaData);
            }
            elements.addAll(dirElements);
            elements.addAll(fileElements);
        }
        return new GSDirectoryListing(dirUrlString, elements);
    }

    public static void uploadFile(File localFile, String gsPath) throws IOException, URISyntaxException {
        byte[] md5 = DMUtils.computeMD5(localFile);
        String base64String = new String(Base64Coder.encode(md5));
        long contentLength = localFile.length();
        String contentType = "application/text";
        String tmp = PreferencesManager.getPreferences().get("GENOME_SPACE_DM_SERVER") + UPLOAD_SERVICE + gsPath + "?Content-Length=" + contentLength + "&Content-MD5=" + URLEncoder.encode(base64String, "UTF-8") + "&Content-Type=" + contentType;
        String uploadURL = HttpUtils.getInstance().getContentsAsJSON(new URL(tmp));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-MD5", base64String);
        headers.put("Content-Length", String.valueOf(contentLength));
        headers.put("Content-Type", contentType);
        HttpUtils.getInstance().uploadGenomeSpaceFile(uploadURL, localFile, headers);
    }

    public static GSFileMetadata createDirectory(String putURL) throws IOException {
        JsonObject dirMeta = new JsonObject();
        dirMeta.add("isDirectory", new JsonPrimitive(true));
        System.out.println(dirMeta.toString());
        String body = "{\"isDirectory\":true}";
        String response = HttpUtils.getInstance().createGenomeSpaceDirectory(new URL(putURL), body);
        JsonParser parser = new JsonParser();
        JsonElement obj = parser.parse(response);
        return GSFileMetadata.deserializeElement(obj);
    }

    static void deleteFileOrDirectory(String delURL) throws IOException {
        HttpUtils.getInstance().delete(new URL(delURL));
    }

    public static byte[] computeMD5(File file) throws IOException {
        try (BufferedInputStream in = null;){
            MessageDigest md = MessageDigest.getInstance("MD5");
            in = new BufferedInputStream(new FileInputStream(file));
            int theByte = 0;
            while ((theByte = in.read()) != -1) {
                md.update((byte)theByte);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
    }

    public static String toHexString(byte[] v2) {
        String HEX_DIGITS = "0123456789abcdef";
        StringBuffer sb = new StringBuffer(v2.length * 2);
        for (int i2 = 0; i2 < v2.length; ++i2) {
            int b2 = v2[i2] & 0xFF;
            sb.append("0123456789abcdef".charAt(b2 >>> 4)).append("0123456789abcdef".charAt(b2 & 0xF));
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        String testFile = "/Users/jrobinso/projects/igv/test/data/bed/Unigene.sample.bed";
        File localFile = new File("/Users/jrobinso/projects/igv/test/data/bed/Unigene.sample.bed");
        DMUtils.uploadFile(localFile, "/users/test/Unigene.sample.bed");
        System.exit(-1);
    }
}

