/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import org.broad.igv.Globals;
import org.broad.igv.feature.EncodePeakFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.UCSCCodec;

public class EncodePeakCodec
extends UCSCCodec {
    Genome genome;

    public EncodePeakCodec() {
        this((Genome)null);
    }

    public EncodePeakCodec(Genome genome) {
        super(EncodePeakFeature.class);
        this.genome = genome;
    }

    @Override
    public EncodePeakFeature decode(String nextLine) {
        int strandChar;
        if (nextLine.trim().length() == 0) {
            return null;
        }
        if (nextLine.startsWith("#") || nextLine.startsWith("track") || nextLine.startsWith("browser")) {
            return null;
        }
        String[] tokens = Globals.tabPattern.split(nextLine);
        int tokenCount = tokens.length;
        if (tokenCount < 9) {
            return null;
        }
        String c2 = tokens[0];
        String chr = this.genome == null ? c2 : this.genome.getCanonicalChrName(c2);
        int start = Integer.parseInt(tokens[1]);
        int end = Integer.parseInt(tokens[2]);
        EncodePeakFeature feature = new EncodePeakFeature(chr, start, end);
        feature.setName(tokens[3]);
        feature.setScore(Float.parseFloat(tokens[4]));
        String strandString = tokens[5].trim();
        int n2 = strandChar = strandString.length() == 0 ? 32 : (int)strandString.charAt(0);
        Strand strand = strandChar == 45 ? Strand.NEGATIVE : (strandChar == 43 ? Strand.POSITIVE : Strand.NONE);
        feature.setStrand(strand);
        feature.setSignal((float)Double.parseDouble(tokens[6]));
        feature.setPValue((float)Double.parseDouble(tokens[7]));
        feature.setQValue((float)Double.parseDouble(tokens[8]));
        return feature;
    }

    @Override
    public boolean canDecode(String s2) {
        return s2.toLowerCase().endsWith("peak");
    }
}

