/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.tribble.TribbleException;
import htsjdk.variant.vcf.VCFLineParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class VCF4Parser
implements VCFLineParser {
    VCF4Parser() {
    }

    @Override
    public Map<String, String> parseLine(String valueLine, List<String> expectedTagOrder) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        String key = "";
        int index = 0;
        boolean inQuote = false;
        boolean escape = false;
        for (char c2 : valueLine.toCharArray()) {
            if (c2 == '\"') {
                if (escape) {
                    builder.append(c2);
                    escape = false;
                } else {
                    inQuote = !inQuote;
                }
            } else if (inQuote) {
                if (escape) {
                    if (c2 == '\\') {
                        builder.append(c2);
                    } else {
                        builder.append('\\');
                        builder.append(c2);
                    }
                    escape = false;
                } else if (c2 != '\\') {
                    builder.append(c2);
                } else {
                    escape = true;
                }
            } else {
                escape = false;
                switch (c2) {
                    case '<': {
                        if (index == 0) break;
                    }
                    case '>': {
                        if (index != valueLine.length() - 1) break;
                        ret.put(key, builder.toString().trim());
                        break;
                    }
                    case '=': {
                        key = builder.toString().trim();
                        builder = new StringBuilder();
                        break;
                    }
                    case ',': {
                        ret.put(key, builder.toString().trim());
                        builder = new StringBuilder();
                        break;
                    }
                    default: {
                        builder.append(c2);
                    }
                }
            }
            ++index;
        }
        if (inQuote) {
            throw new TribbleException.InvalidHeader("Unclosed quote in header line value " + valueLine);
        }
        index = 0;
        if (expectedTagOrder != null) {
            if (ret.size() > expectedTagOrder.size()) {
                throw new TribbleException.InvalidHeader("unexpected tag count " + ret.size() + " in line " + valueLine);
            }
            Object object = ret.keySet().iterator();
            while (object.hasNext()) {
                String str = (String)object.next();
                if (!expectedTagOrder.get(index).equals(str)) {
                    throw new TribbleException.InvalidHeader("Unexpected tag " + str + " in line " + valueLine);
                }
                ++index;
            }
        }
        return ret;
    }
}

