/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.IntervalTree;
import htsjdk.samtools.util.Locatable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OverlapDetector<T> {
    private final Map<Object, IntervalTree<Set<T>>> cache = new HashMap<Object, IntervalTree<Set<T>>>();
    private final int lhsBuffer;
    private final int rhsBuffer;

    public OverlapDetector(int lhsBuffer, int rhsBuffer) {
        this.lhsBuffer = lhsBuffer;
        this.rhsBuffer = rhsBuffer;
    }

    public static <T extends Locatable> OverlapDetector<T> create(List<T> intervals) {
        OverlapDetector<T> detector = new OverlapDetector<T>(0, 0);
        detector.addAll(intervals, intervals);
        return detector;
    }

    public void addLhs(T object, Locatable interval) {
        Set alreadyThere;
        if (object == null) {
            throw new IllegalArgumentException("null object");
        }
        if (interval == null) {
            throw new IllegalArgumentException("null interval");
        }
        String seqId = interval.getContig();
        IntervalTree<Set<Object>> tree = this.cache.get(seqId);
        if (tree == null) {
            tree = new IntervalTree();
            this.cache.put(seqId, tree);
        }
        int start = interval.getStart() + this.lhsBuffer;
        int end = interval.getEnd() - this.lhsBuffer;
        HashSet<T> objects = new HashSet<T>(1);
        objects.add(object);
        if (start <= end && (alreadyThere = (Set)tree.put(start, end, objects)) != null) {
            alreadyThere.add(object);
            tree.put(start, end, alreadyThere);
        }
    }

    public void addAll(List<T> objects, List<? extends Locatable> intervals) {
        if (objects == null) {
            throw new IllegalArgumentException("null objects");
        }
        if (intervals == null) {
            throw new IllegalArgumentException("null intervals");
        }
        if (objects.size() != intervals.size()) {
            throw new IllegalArgumentException("Objects and intervals must be the same size but were " + objects.size() + " and " + intervals.size());
        }
        for (int i2 = 0; i2 < objects.size(); ++i2) {
            this.addLhs(objects.get(i2), intervals.get(i2));
        }
    }

    public Set<T> getAll() {
        HashSet all = new HashSet();
        for (IntervalTree<Set<T>> tree : this.cache.values()) {
            for (IntervalTree.Node<Set<T>> node : tree) {
                all.addAll(node.getValue());
            }
        }
        return all;
    }

    public boolean overlapsAny(Locatable locatable) {
        int end;
        if (locatable == null) {
            throw new IllegalArgumentException("null locatable");
        }
        String seqId = locatable.getContig();
        IntervalTree<Set<T>> tree = this.cache.get(seqId);
        if (tree == null) {
            return false;
        }
        int start = locatable.getStart() + this.rhsBuffer;
        if (start > (end = locatable.getEnd() - this.rhsBuffer)) {
            return false;
        }
        Iterator<IntervalTree.Node<Set<T>>> it = tree.overlappers(start, end);
        while (it.hasNext()) {
            IntervalTree.Node<Set<T>> node = it.next();
            if (node.getValue().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Set<T> getOverlaps(Locatable locatable) {
        int end;
        if (locatable == null) {
            throw new IllegalArgumentException("null locatable");
        }
        String seqId = locatable.getContig();
        IntervalTree<Set<T>> tree = this.cache.get(seqId);
        if (tree == null) {
            return Collections.emptySet();
        }
        int start = locatable.getStart() + this.rhsBuffer;
        if (start > (end = locatable.getEnd() - this.rhsBuffer)) {
            return Collections.emptySet();
        }
        HashSet matches = new HashSet();
        Iterator<IntervalTree.Node<Set<T>>> it = tree.overlappers(start, end);
        while (it.hasNext()) {
            IntervalTree.Node<Set<T>> node = it.next();
            matches.addAll(node.getValue());
        }
        return matches;
    }
}

