/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5CalculatingOutputStream
extends OutputStream {
    private final OutputStream os;
    private final MessageDigest md5;
    private final Path digestFile;
    private String hash = null;

    public Md5CalculatingOutputStream(OutputStream os, Path digestFile) {
        this.os = os;
        this.digestFile = digestFile;
        try {
            this.md5 = MessageDigest.getInstance("MD5");
            this.md5.reset();
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException("MD5 algorithm not found", e2);
        }
    }

    public Md5CalculatingOutputStream(OutputStream os, File digestFile) {
        this(os, digestFile == null ? (Path)null : digestFile.toPath());
    }

    @Override
    public void write(int b2) throws IOException {
        this.md5.update((byte)b2);
        this.os.write(b2);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.md5.update(b2);
        this.os.write(b2);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        this.md5.update(b2, off, len);
        this.os.write(b2, off, len);
    }

    public String md5() {
        if (this.hash == null) {
            throw new SAMException("Attempting to access md5 digest before the entire file is written!  Call close first.");
        }
        return this.hash;
    }

    private String makeHash() {
        if (this.hash == null) {
            this.hash = new BigInteger(1, this.md5.digest()).toString(16);
            if (this.hash.length() != 32) {
                String zeros = "00000000000000000000000000000000";
                this.hash = "00000000000000000000000000000000".substring(0, 32 - this.hash.length()) + this.hash;
            }
            return this.hash;
        }
        throw new SAMException("Calling close on Md5CalculatingOutputStream twice!");
    }

    @Override
    public void close() throws IOException {
        this.os.close();
        this.makeHash();
        if (this.digestFile != null) {
            BufferedWriter writer = Files.newBufferedWriter(this.digestFile, new OpenOption[0]);
            writer.write(this.hash);
            writer.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }
}

