/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

class GolombRiceIntegerCodec
extends AbstractBitCodec<Integer> {
    private final int m;
    private final int log2m;
    private final long mask;
    private boolean quotientBit = false;
    private int offset = 0;

    public GolombRiceIntegerCodec(int offset, int log2m) {
        this.log2m = log2m;
        this.m = 1 << log2m;
        this.quotientBit = true;
        this.offset = offset;
        this.mask = ~(-1 << log2m);
    }

    @Override
    public final Integer read(BitInputStream bitInputStream) throws IOException {
        int unary = 0;
        while (bitInputStream.readBit() == this.quotientBit) {
            ++unary;
        }
        int remainder = bitInputStream.readBits(this.log2m);
        int result = unary * this.m + remainder;
        return result - this.offset;
    }

    @Override
    public final long write(BitOutputStream bitOutputStream, Integer value) throws IOException {
        long newValue = value + this.offset;
        long quotient = newValue >>> this.log2m;
        if (quotient > Integer.MAX_VALUE) {
            for (long i2 = 0L; i2 < quotient; ++i2) {
                bitOutputStream.write(this.quotientBit);
            }
        } else if (quotient > 0L) {
            int qi = (int)quotient;
            for (int i3 = 0; i3 < qi; ++i3) {
                bitOutputStream.write(this.quotientBit);
            }
        }
        bitOutputStream.write(!this.quotientBit);
        long remainder = newValue & this.mask;
        long reminderMask = 1 << this.log2m - 1;
        for (int i4 = this.log2m - 1; i4 >= 0; --i4) {
            long b2 = remainder & reminderMask;
            bitOutputStream.write(b2 != 0L);
            reminderMask >>>= 1;
        }
        return quotient + 1L + (long)this.log2m;
    }

    @Override
    public final long numberOfBits(Integer value) {
        return (value + this.offset) / this.m + 1 + this.log2m;
    }

    @Override
    public Integer read(BitInputStream bitInputStream, int length) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

