/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import java.util.BitSet;

public class GenomicIndexUtil {
    public static final int BIN_GENOMIC_SPAN = 0x20000000;
    public static final int[] LEVEL_STARTS = new int[]{0, 1, 9, 73, 585, 4681};
    public static final int MAX_BINS = 37450;
    public static final int MAX_LINEAR_INDEX_SIZE = 37451 - LEVEL_STARTS[LEVEL_STARTS.length - 1];
    public static final int UNSET_GENOMIC_LOCATION = 0;

    public static int regionToBin(int beg, int end) {
        if (beg >> 14 == --end >> 14) {
            return 4681 + (beg >> 14);
        }
        if (beg >> 17 == end >> 17) {
            return 585 + (beg >> 17);
        }
        if (beg >> 20 == end >> 20) {
            return 73 + (beg >> 20);
        }
        if (beg >> 23 == end >> 23) {
            return 9 + (beg >> 23);
        }
        if (beg >> 26 == end >> 26) {
            return 1 + (beg >> 26);
        }
        return 0;
    }

    public static BitSet regionToBins(int startPos, int endPos) {
        int k2;
        int end;
        int maxPos = 0x1FFFFFFF;
        int start = startPos <= 0 ? 0 : startPos - 1 & 0x1FFFFFFF;
        int n2 = end = endPos <= 0 ? 0x1FFFFFFF : endPos - 1 & 0x1FFFFFFF;
        if (start > end) {
            return null;
        }
        BitSet bitSet = new BitSet(37450);
        bitSet.set(0);
        for (k2 = 1 + (start >> 26); k2 <= 1 + (end >> 26); ++k2) {
            bitSet.set(k2);
        }
        for (k2 = 9 + (start >> 23); k2 <= 9 + (end >> 23); ++k2) {
            bitSet.set(k2);
        }
        for (k2 = 73 + (start >> 20); k2 <= 73 + (end >> 20); ++k2) {
            bitSet.set(k2);
        }
        for (k2 = 585 + (start >> 17); k2 <= 585 + (end >> 17); ++k2) {
            bitSet.set(k2);
        }
        for (k2 = 4681 + (start >> 14); k2 <= 4681 + (end >> 14); ++k2) {
            bitSet.set(k2);
        }
        return bitSet;
    }
}

