/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.InputStreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ExternalByteArrayCodec
extends AbstractBitCodec<byte[]> {
    private final OutputStream outputStream;
    private final InputStream inputStream;

    public ExternalByteArrayCodec(OutputStream outputStream, InputStream inputStream) {
        this.outputStream = outputStream;
        this.inputStream = inputStream;
    }

    @Override
    public byte[] read(BitInputStream bitInputStream, int length) throws IOException {
        return InputStreamUtils.readFully(this.inputStream, length);
    }

    @Override
    public void readInto(BitInputStream bitInputStream, byte[] array, int offset, int valueLen) throws IOException {
        InputStreamUtils.readFully(this.inputStream, array, offset, valueLen);
    }

    @Override
    public void skip(BitInputStream bitInputStream) throws IOException {
        this.inputStream.skip(1L);
    }

    @Override
    public void skip(BitInputStream bitInputStream, int length) throws IOException {
        this.inputStream.skip(length);
    }

    @Override
    public long write(BitOutputStream bitOutputStream, byte[] object) throws IOException {
        this.outputStream.write(object);
        return this.numberOfBits(object);
    }

    @Override
    public long numberOfBits(byte[] object) {
        return object.length * 8;
    }

    @Override
    public byte[] read(BitInputStream bitInputStream) throws IOException {
        throw new RuntimeException("Cannot read byte array of unknown length.");
    }
}

