/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    private final InputStream delegate;
    private long count = 0L;

    public CountingInputStream(InputStream inputStream) {
        this.delegate = inputStream;
    }

    @Override
    public int read() throws IOException {
        ++this.count;
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.delegate.read(b);
        this.count += (long)read;
        return read;
    }

    @Override
    public int read(byte[] b, int off, int length) throws IOException {
        int read = this.delegate.read(b, off, length);
        this.count += (long)read;
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.delegate.skip(n);
        this.count += skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    @Override
    public void mark(int readLimit) {
        this.delegate.mark(readLimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
        this.count = 0L;
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    public long getCount() {
        return this.count;
    }
}

