/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.Tribble;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.index.Block;
import htsjdk.tribble.index.ChrIndex;
import htsjdk.tribble.index.MutableIndex;
import htsjdk.tribble.util.LittleEndianInputStream;
import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractIndex
implements MutableIndex {
    public static final int VERSION = 3;
    public static final int MAGIC_NUMBER = 1480870228;
    private static final String NO_MD5 = "";
    private static final long NO_FILE_SIZE = -1L;
    private static final long NO_TS = -1L;
    protected int version = 3;
    protected Path indexedPath = null;
    protected long indexedFileSize = -1L;
    protected long indexedFileTS = -1L;
    protected String indexedFileMD5 = "";
    protected int flags;
    protected final Log logger = Log.getInstance(this.getClass());
    private LinkedHashMap<String, String> properties = new LinkedHashMap();
    protected LinkedHashMap<String, ChrIndex> chrIndices = new LinkedHashMap();
    private static final int SEQUENCE_DICTIONARY_FLAG = 32768;

    public boolean hasFileSize() {
        return this.indexedFileSize != -1L;
    }

    public boolean hasTimestamp() {
        return this.indexedFileTS != -1L;
    }

    public boolean hasMD5() {
        return this.indexedFileMD5 != NO_MD5;
    }

    @Override
    public boolean equalsIgnoreProperties(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractIndex)) {
            System.err.printf("equals: %s not instance of AbstractIndex", obj);
            return false;
        }
        AbstractIndex other = (AbstractIndex)obj;
        if (this.version != other.version) {
            System.err.printf("equals version: this %d != other %d%n", this.version, other.version);
            return false;
        }
        if (!(this.indexedPath == other.indexedPath || this.indexedPath != null && this.indexedPath.equals(other.indexedPath))) {
            System.err.printf("equals indexedPath: this %s != other %s%n", this.indexedPath, other.indexedPath);
            return false;
        }
        if (this.indexedFileSize != other.indexedFileSize) {
            System.err.printf("equals indexedFileSize: this %d != other %d%n", this.indexedFileSize, other.indexedFileSize);
            return false;
        }
        if (!this.indexedFileMD5.equals(other.indexedFileMD5)) {
            System.err.printf("equals indexedFileMD5: this %s != other %s%n", this.indexedFileMD5, other.indexedFileMD5);
            return false;
        }
        if (this.flags != other.flags) {
            System.err.printf("equals flags: this %d != other %d%n", this.flags, other.flags);
            return false;
        }
        if (!this.chrIndices.equals(other.chrIndices)) {
            System.err.printf("equals chrIndeces: this %s != other %s%n", this.chrIndices, other.chrIndices);
            return false;
        }
        return true;
    }

    public AbstractIndex() {
    }

    public AbstractIndex(String featureFile) {
        this();
        try {
            this.indexedPath = IOUtil.getPath(featureFile).toAbsolutePath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IO error: " + e.getMessage(), e);
        }
    }

    public AbstractIndex(File featureFile) {
        this(featureFile.toPath());
    }

    public AbstractIndex(Path featurePath) {
        this();
        this.indexedPath = featurePath.toAbsolutePath();
    }

    public AbstractIndex(AbstractIndex parent) {
        this();
        this.version = parent.version;
        this.indexedPath = parent.indexedPath;
        this.indexedFileSize = parent.indexedFileSize;
        this.indexedFileTS = parent.indexedFileTS;
        this.indexedFileMD5 = parent.indexedFileMD5;
        this.flags = parent.flags;
        this.properties = (LinkedHashMap)parent.properties.clone();
    }

    protected void validateIndexHeader(int indexType, LittleEndianInputStream dis) throws IOException {
        int magicNumber = dis.readInt();
        if (magicNumber != 1480870228) {
            throw new TribbleException(String.format("Unexpected magic number %d", magicNumber));
        }
        int type = dis.readInt();
        if (type != indexType) {
            throw new TribbleException(String.format("Unexpected index type %d", type));
        }
    }

    @Override
    public boolean isCurrentVersion() {
        return this.version == 3;
    }

    @Deprecated
    public File getIndexedFile() {
        return this.getIndexedPath().toFile();
    }

    public Path getIndexedPath() {
        return this.indexedPath;
    }

    public long getIndexedFileSize() {
        return this.indexedFileSize;
    }

    public long getIndexedFileTS() {
        return this.indexedFileTS;
    }

    public String getIndexedFileMD5() {
        return this.indexedFileMD5;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getVersion() {
        return this.version;
    }

    public void setMD5(String md5) {
        this.indexedFileMD5 = md5;
    }

    @Override
    public boolean containsChromosome(String chr) {
        return this.chrIndices.containsKey(chr);
    }

    public void finalizeIndex() {
        try {
            if (this.indexedPath != null) {
                this.indexedFileSize = Files.size(this.indexedPath);
                this.indexedFileTS = Files.getLastModifiedTime(this.indexedPath, new LinkOption[0]).toMillis();
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void writeHeader(LittleEndianOutputStream dos) throws IOException {
        dos.writeInt(1480870228);
        dos.writeInt(this.getType());
        dos.writeInt(this.version);
        dos.writeString(this.indexedPath.toUri().toString());
        dos.writeLong(this.indexedFileSize);
        dos.writeLong(this.indexedFileTS);
        dos.writeString(this.indexedFileMD5);
        dos.writeInt(this.flags);
        dos.writeInt(this.properties.size());
        for (Map.Entry<String, String> prop : this.properties.entrySet()) {
            dos.writeString(prop.getKey());
            dos.writeString(prop.getValue());
        }
    }

    private void readHeader(LittleEndianInputStream dis) throws IOException {
        this.version = dis.readInt();
        this.indexedPath = IOUtil.getPath(dis.readString());
        this.indexedFileSize = dis.readLong();
        this.indexedFileTS = dis.readLong();
        this.indexedFileMD5 = dis.readString();
        this.flags = dis.readInt();
        if (this.version < 3 && (this.flags & 0x8000) == 32768) {
            this.readSequenceDictionary(dis);
        }
        if (this.version >= 3) {
            int nProperties = dis.readInt();
            while (nProperties-- > 0) {
                String key = dis.readString();
                String value = dis.readString();
                this.properties.put(key, value);
            }
        }
    }

    private void readSequenceDictionary(LittleEndianInputStream dis) throws IOException {
        int size = dis.readInt();
        if (size < 0) {
            throw new IllegalStateException("Size of the sequence dictionary entries is negative");
        }
        for (int x = 0; x < size; ++x) {
            dis.readString();
            dis.readInt();
        }
    }

    @Override
    public List<String> getSequenceNames() {
        return new ArrayList<String>(this.chrIndices.keySet());
    }

    @Override
    public List<Block> getBlocks(String chr, int start, int end) {
        return this.getChrIndex(chr).getBlocks(start, end);
    }

    public List<Block> getBlocks(String chr) {
        return this.getChrIndex(chr).getBlocks();
    }

    private final ChrIndex getChrIndex(String chr) {
        ChrIndex chrIdx = this.chrIndices.get(chr);
        if (chrIdx == null) {
            throw new IllegalArgumentException("getBlocks() called with of unknown contig " + chr);
        }
        return chrIdx;
    }

    @Override
    public void write(LittleEndianOutputStream stream) throws IOException {
        this.writeHeader(stream);
        stream.writeInt(this.chrIndices.size());
        for (ChrIndex chrIdx : this.chrIndices.values()) {
            chrIdx.write(stream);
        }
    }

    @Override
    public void write(Path idxPath) throws IOException {
        try (LittleEndianOutputStream idxStream = new LittleEndianOutputStream(new BufferedOutputStream(Files.newOutputStream(idxPath, new OpenOption[0])));){
            this.write(idxStream);
        }
    }

    @Override
    public void writeBasedOnFeaturePath(Path featurePath) throws IOException {
        if (!Files.isRegularFile(featurePath, new LinkOption[0])) {
            throw new IOException("Cannot write based on a non-regular file: " + featurePath.toUri());
        }
        this.write(Tribble.indexPath(featurePath));
    }

    public void read(LittleEndianInputStream dis) throws IOException {
        try {
            this.readHeader(dis);
            int nChromosomes = dis.readInt();
            this.chrIndices = new LinkedHashMap(nChromosomes);
            while (nChromosomes-- > 0) {
                ChrIndex chrIdx = (ChrIndex)this.getChrIndexClass().newInstance();
                chrIdx.read(dis);
                this.chrIndices.put(chrIdx.getName(), chrIdx);
            }
        }
        catch (InstantiationException e) {
            throw new TribbleException.UnableToCreateCorrectIndexType("Unable to create class " + this.getChrIndexClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new TribbleException.UnableToCreateCorrectIndexType("Unable to create class " + this.getChrIndexClass(), e);
        }
        finally {
            dis.close();
        }
    }

    protected void printIndexInfo() {
        System.out.println(String.format("Index for %s with %d indices", this.indexedPath, this.chrIndices.size()));
        BlockStats stats = this.getBlockStats(true);
        System.out.println(String.format("  total blocks %d", stats.total));
        System.out.println(String.format("  total empty blocks %d", stats.empty));
    }

    protected BlockStats getBlockStats(boolean logDetails) {
        BlockStats stats = new BlockStats();
        for (Map.Entry<String, ChrIndex> elt : this.chrIndices.entrySet()) {
            List<Block> blocks = elt.getValue().getBlocks();
            if (blocks == null) continue;
            int nBlocks = blocks.size();
            int nEmptyBlocks = 0;
            for (Block b : elt.getValue().getBlocks()) {
                if (b.getSize() != 0L) continue;
                ++nEmptyBlocks;
            }
            stats.empty += (long)nEmptyBlocks;
            stats.total += (long)nBlocks;
            if (!logDetails) continue;
            System.out.println(String.format("  %s => %d blocks, %d empty, %.2f", elt.getKey(), nBlocks, nEmptyBlocks, 100.0 * (double)nEmptyBlocks / (double)nBlocks));
        }
        return stats;
    }

    protected String statsSummary() {
        BlockStats stats = this.getBlockStats(false);
        return String.format("%12d blocks (%12d empty (%.2f%%))", stats.total, stats.empty, 100.0 * (double)stats.empty / (double)stats.total);
    }

    @Override
    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public void addProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    protected abstract int getType();

    public abstract Class getChrIndexClass();

    protected static class BlockStats {
        long total = 0L;
        long empty = 0L;
        long objects = 0L;
        long size = 0L;

        protected BlockStats() {
        }
    }

    public static enum IndexType {
        LINEAR(1),
        INTERVAL_TREE(2);

        public final int fileHeaderTypeIdentifier;

        private IndexType(int fileHeaderTypeIdentifier) {
            this.fileHeaderTypeIdentifier = fileHeaderTypeIdentifier;
        }
    }
}

