/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.FeatureReader;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.variant.bcf2.BCF2Codec;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class VCFFileReader
implements Closeable,
Iterable<VariantContext> {
    private final FeatureReader<VariantContext> reader;

    public static boolean isBCF(File file) {
        return file.getAbsolutePath().endsWith(".bcf");
    }

    public static SAMSequenceDictionary getSequenceDictionary(File file) {
        SAMSequenceDictionary dict = new VCFFileReader(file, false).getFileHeader().getSequenceDictionary();
        CloserUtil.close(file);
        return dict;
    }

    public VCFFileReader(File file) {
        this(file, true);
    }

    public VCFFileReader(File file, File indexFile) {
        this(file, indexFile, true);
    }

    public VCFFileReader(File file, boolean requireIndex) {
        FeatureCodec<VariantContext, PositionalBufferedStream> codec = VCFFileReader.isBCF(file) ? new BCF2Codec() : new VCFCodec();
        this.reader = AbstractFeatureReader.getFeatureReader(file.getAbsolutePath(), codec, requireIndex);
    }

    public VCFFileReader(File file, File indexFile, boolean requireIndex) {
        FeatureCodec<VariantContext, PositionalBufferedStream> codec = VCFFileReader.isBCF(file) ? new BCF2Codec() : new VCFCodec();
        this.reader = AbstractFeatureReader.getFeatureReader(file.getAbsolutePath(), indexFile.getAbsolutePath(), codec, requireIndex);
    }

    public static IntervalList fromVcf(File file) {
        return VCFFileReader.fromVcf(file, false);
    }

    public static IntervalList fromVcf(File file, boolean includeFiltered) {
        VCFFileReader vcfFileReader = new VCFFileReader(file, false);
        IntervalList intervalList = VCFFileReader.fromVcf(vcfFileReader, includeFiltered);
        vcfFileReader.close();
        return intervalList;
    }

    public static IntervalList fromVcf(VCFFileReader vcf) {
        return VCFFileReader.fromVcf(vcf, false);
    }

    public static IntervalList fromVcf(VCFFileReader vcf, boolean includeFiltered) {
        SAMSequenceDictionary dict = vcf.getFileHeader().getSequenceDictionary();
        SAMFileHeader samFileHeader = new SAMFileHeader();
        samFileHeader.setSequenceDictionary(dict);
        IntervalList list = new IntervalList(samFileHeader);
        int intervals = 0;
        for (VariantContext vc : vcf) {
            if (!includeFiltered && vc.isFiltered()) continue;
            String name = vc.getID();
            Integer intervalEnd = vc.getCommonInfo().getAttributeAsInt("END", vc.getEnd());
            if (".".equals(name) || name == null) {
                name = "interval-" + ++intervals;
            }
            list.add(new Interval(vc.getContig(), vc.getStart(), intervalEnd, false, name));
        }
        return list;
    }

    public VCFHeader getFileHeader() {
        return (VCFHeader)this.reader.getHeader();
    }

    @Override
    public CloseableIterator<VariantContext> iterator() {
        try {
            return this.reader.iterator();
        }
        catch (IOException ioe) {
            throw new TribbleException("Could not create an iterator from a feature reader.", ioe);
        }
    }

    public CloseableIterator<VariantContext> query(String chrom, int start, int end) {
        try {
            return this.reader.query(chrom, start, end);
        }
        catch (IOException ioe) {
            throw new TribbleException("Could not create an iterator from a feature reader.", ioe);
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException ioe) {
            throw new TribbleException("Could not close a variant context feature reader.", ioe);
        }
    }
}

