/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AsyncSAMFileWriter;
import htsjdk.samtools.BAMFileWriter;
import htsjdk.samtools.CRAMFileWriter;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMTextWriter;
import htsjdk.samtools.SamFlagField;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.Md5CalculatingOutputStream;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.zip.DeflaterFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SAMFileWriterFactory
implements Cloneable {
    private static final Log log = Log.getInstance(SAMFileWriterFactory.class);
    private static boolean defaultCreateIndexWhileWriting = Defaults.CREATE_INDEX;
    private boolean createIndex = defaultCreateIndexWhileWriting;
    private static boolean defaultCreateMd5File = Defaults.CREATE_MD5;
    private boolean createMd5File = defaultCreateMd5File;
    private boolean useAsyncIo = Defaults.USE_ASYNC_IO_WRITE_FOR_SAMTOOLS;
    private int asyncOutputBufferSize = 2000;
    private int bufferSize = Defaults.BUFFER_SIZE;
    private File tmpDir;
    private int compressionLevel = BlockCompressedOutputStream.getDefaultCompressionLevel();
    private SamFlagField samFlagFieldOutput = SamFlagField.NONE;
    private Integer maxRecordsInRam = null;
    private DeflaterFactory deflaterFactory = BlockCompressedOutputStream.getDefaultDeflaterFactory();

    public SAMFileWriterFactory() {
    }

    public SAMFileWriterFactory(SAMFileWriterFactory other) {
        if (other == null) {
            throw new IllegalArgumentException("SAMFileWriterFactory(null)");
        }
        this.createIndex = other.createIndex;
        this.createMd5File = other.createMd5File;
        this.useAsyncIo = other.useAsyncIo;
        this.asyncOutputBufferSize = other.asyncOutputBufferSize;
        this.bufferSize = other.bufferSize;
        this.tmpDir = other.tmpDir;
        this.compressionLevel = other.compressionLevel;
        this.maxRecordsInRam = other.maxRecordsInRam;
    }

    public SAMFileWriterFactory clone() {
        return new SAMFileWriterFactory(this);
    }

    public static void setDefaultCreateMd5File(boolean createMd5File) {
        defaultCreateMd5File = createMd5File;
    }

    public static boolean getDefaultCreateMd5File() {
        return defaultCreateMd5File;
    }

    public SAMFileWriterFactory setCreateMd5File(boolean createMd5File) {
        this.createMd5File = createMd5File;
        return this;
    }

    public SAMFileWriterFactory setDeflaterFactory(DeflaterFactory deflaterFactory) {
        if (deflaterFactory == null) {
            throw new IllegalArgumentException("null deflater factory");
        }
        this.deflaterFactory = deflaterFactory;
        return this;
    }

    public SAMFileWriterFactory setCompressionLevel(int compressionLevel) {
        this.compressionLevel = Math.min(9, Math.max(0, compressionLevel));
        return this;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public static void setDefaultCreateIndexWhileWriting(boolean setting) {
        defaultCreateIndexWhileWriting = setting;
    }

    public static boolean getDefaultCreateIndexWhileWriting() {
        return defaultCreateIndexWhileWriting;
    }

    public SAMFileWriterFactory setCreateIndex(boolean setting) {
        this.createIndex = setting;
        return this;
    }

    public SAMFileWriterFactory setMaxRecordsInRam(int maxRecordsInRam) {
        this.maxRecordsInRam = maxRecordsInRam;
        return this;
    }

    public int getMaxRecordsInRam() {
        return this.maxRecordsInRam;
    }

    public SAMFileWriterFactory setUseAsyncIo(boolean useAsyncIo) {
        this.useAsyncIo = useAsyncIo;
        return this;
    }

    public SAMFileWriterFactory setAsyncOutputBufferSize(int asyncOutputBufferSize) {
        this.asyncOutputBufferSize = asyncOutputBufferSize;
        return this;
    }

    public SAMFileWriterFactory setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public SAMFileWriterFactory setTempDirectory(File tmpDir) {
        this.tmpDir = tmpDir;
        return this;
    }

    public File getTempDirectory() {
        return this.tmpDir;
    }

    public SAMFileWriterFactory setSamFlagFieldOutput(SamFlagField samFlagFieldOutput) {
        if (samFlagFieldOutput == null) {
            throw new IllegalArgumentException("Sam flag field was null");
        }
        this.samFlagFieldOutput = samFlagFieldOutput;
        return this;
    }

    public SAMFileWriter makeBAMWriter(SAMFileHeader header, boolean presorted, File outputFile) {
        return this.makeBAMWriter(header, presorted, outputFile, this.getCompressionLevel());
    }

    public SAMFileWriter makeBAMWriter(SAMFileHeader header, boolean presorted, File outputFile, int compressionLevel) {
        try {
            boolean createIndex;
            boolean createMd5File;
            boolean bl = createMd5File = this.createMd5File && IOUtil.isRegularPath(outputFile);
            if (this.createMd5File && !createMd5File) {
                log.warn("Cannot create MD5 file for BAM because output file is not a regular file: " + outputFile.getAbsolutePath());
            }
            OutputStream os = IOUtil.maybeBufferOutputStream(new FileOutputStream(outputFile, false), this.bufferSize);
            if (createMd5File) {
                os = new Md5CalculatingOutputStream(os, new File(outputFile.getAbsolutePath() + ".md5"));
            }
            BAMFileWriter ret = new BAMFileWriter(os, outputFile, compressionLevel, this.deflaterFactory);
            boolean bl2 = createIndex = this.createIndex && IOUtil.isRegularPath(outputFile);
            if (this.createIndex && !createIndex) {
                log.warn("Cannot create index for BAM because output file is not a regular file: " + outputFile.getAbsolutePath());
            }
            this.initializeBAMWriter(ret, header, presorted, createIndex);
            if (this.useAsyncIo) {
                return new AsyncSAMFileWriter(ret, this.asyncOutputBufferSize);
            }
            return ret;
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Error opening file: " + outputFile.getAbsolutePath());
        }
    }

    private void initializeBAMWriter(BAMFileWriter writer, SAMFileHeader header, boolean presorted, boolean createIndex) {
        writer.setSortOrder(header.getSortOrder(), presorted);
        if (this.maxRecordsInRam != null) {
            writer.setMaxRecordsInRam(this.maxRecordsInRam);
        }
        if (this.tmpDir != null) {
            writer.setTempDirectory(this.tmpDir);
        }
        writer.setHeader(header);
        if (createIndex && writer.getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            writer.enableBamIndexConstruction();
        }
    }

    public SAMFileWriter makeSAMWriter(SAMFileHeader header, boolean presorted, File outputFile) {
        if (this.samFlagFieldOutput == SamFlagField.NONE) {
            this.samFlagFieldOutput = Defaults.SAM_FLAG_FIELD_FORMAT;
        }
        try {
            SAMTextWriter ret = this.createMd5File ? new SAMTextWriter(new Md5CalculatingOutputStream((OutputStream)new FileOutputStream(outputFile, false), new File(outputFile.getAbsolutePath() + ".md5")), this.samFlagFieldOutput) : new SAMTextWriter(outputFile, this.samFlagFieldOutput);
            return this.initWriter(header, presorted, ret);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Error opening file: " + outputFile.getAbsolutePath());
        }
    }

    public SAMFileWriter makeSAMWriter(SAMFileHeader header, boolean presorted, OutputStream stream) {
        if (this.samFlagFieldOutput == SamFlagField.NONE) {
            this.samFlagFieldOutput = Defaults.SAM_FLAG_FIELD_FORMAT;
        }
        return this.initWriter(header, presorted, new SAMTextWriter(stream, this.samFlagFieldOutput));
    }

    public SAMFileWriter makeBAMWriter(SAMFileHeader header, boolean presorted, OutputStream stream) {
        return this.initWriter(header, presorted, new BAMFileWriter(stream, null, this.getCompressionLevel(), this.deflaterFactory));
    }

    private SAMFileWriter initWriter(SAMFileHeader header, boolean presorted, SAMFileWriterImpl writer) {
        writer.setSortOrder(header.getSortOrder(), presorted);
        if (this.maxRecordsInRam != null) {
            writer.setMaxRecordsInRam(this.maxRecordsInRam);
        }
        if (this.tmpDir != null) {
            writer.setTempDirectory(this.tmpDir);
        }
        writer.setHeader(header);
        if (this.useAsyncIo) {
            return new AsyncSAMFileWriter(writer, this.asyncOutputBufferSize);
        }
        return writer;
    }

    public SAMFileWriter makeSAMOrBAMWriter(SAMFileHeader header, boolean presorted, File outputFile) {
        String filename = outputFile.getName();
        if (filename.endsWith(".bam")) {
            return this.makeBAMWriter(header, presorted, outputFile);
        }
        if (filename.endsWith(".sam")) {
            return this.makeSAMWriter(header, presorted, outputFile);
        }
        return this.makeBAMWriter(header, presorted, outputFile);
    }

    public SAMFileWriter makeWriter(SAMFileHeader header, boolean presorted, File outputFile, File referenceFasta) {
        if (outputFile.getName().endsWith(SamReader.Type.CRAM_TYPE.fileExtension())) {
            return this.makeCRAMWriter(header, presorted, outputFile, referenceFasta);
        }
        return this.makeSAMOrBAMWriter(header, presorted, outputFile);
    }

    public CRAMFileWriter makeCRAMWriter(SAMFileHeader header, OutputStream stream, File referenceFasta) {
        CRAMFileWriter writer = new CRAMFileWriter(stream, new ReferenceSource(referenceFasta), header, null);
        this.setCRAMWriterDefaults(writer);
        return writer;
    }

    public CRAMFileWriter makeCRAMWriter(SAMFileHeader header, File outputFile, File referenceFasta) {
        return this.createCRAMWriterWithSettings(header, true, outputFile, referenceFasta);
    }

    public CRAMFileWriter makeCRAMWriter(SAMFileHeader header, boolean presorted, File outputFile, File referenceFasta) {
        return this.createCRAMWriterWithSettings(header, presorted, outputFile, referenceFasta);
    }

    private CRAMFileWriter createCRAMWriterWithSettings(SAMFileHeader header, boolean presorted, File outputFile, File referenceFasta) {
        OutputStream cramOS = null;
        FileOutputStream indexOS = null;
        if (this.createIndex) {
            if (!IOUtil.isRegularPath(outputFile)) {
                log.warn("Cannot create index for CRAM because output file is not a regular file: " + outputFile.getAbsolutePath());
            } else {
                try {
                    File indexFile = new File(outputFile.getAbsolutePath() + ".bai");
                    indexOS = new FileOutputStream(indexFile);
                }
                catch (IOException ioe) {
                    throw new RuntimeIOException("Error creating index file for: " + outputFile.getAbsolutePath() + ".bai");
                }
            }
        }
        try {
            cramOS = IOUtil.maybeBufferOutputStream(new FileOutputStream(outputFile, false), this.bufferSize);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Error creating CRAM file: " + outputFile.getAbsolutePath());
        }
        CRAMFileWriter writer = new CRAMFileWriter(this.createMd5File ? new Md5CalculatingOutputStream(cramOS, new File(outputFile.getAbsolutePath() + ".md5")) : cramOS, indexOS, presorted, new ReferenceSource(referenceFasta), header, outputFile.getAbsolutePath());
        this.setCRAMWriterDefaults(writer);
        return writer;
    }

    private void setCRAMWriterDefaults(CRAMFileWriter writer) {
        writer.setPreserveReadNames(true);
        writer.setCaptureAllTags(true);
    }

    public String toString() {
        return "SAMFileWriterFactory [createIndex=" + this.createIndex + ", createMd5File=" + this.createMd5File + ", useAsyncIo=" + this.useAsyncIo + ", asyncOutputBufferSize=" + this.asyncOutputBufferSize + ", bufferSize=" + this.bufferSize + ", tmpDir=" + this.tmpDir + ", compressionLevel=" + this.compressionLevel + ", maxRecordsInRam=" + this.maxRecordsInRam + "]";
    }
}

